/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.commons.ip;

import java.math.BigInteger;
import net.ripe.commons.ip.AbstractIpRange;
import net.ripe.commons.ip.AbstractRange;
import net.ripe.commons.ip.Ipv6;
import net.ripe.commons.ip.Validate;

public final class Ipv6Range
extends AbstractIpRange<Ipv6, Ipv6Range> {
    private static final long serialVersionUID = 1L;

    protected Ipv6Range(Ipv6 start, Ipv6 end) {
        super(start, end);
    }

    @Override
    protected Ipv6Range newInstance(BigInteger start, BigInteger end) {
        return Ipv6Range.from(start).to(end);
    }

    @Override
    protected Ipv6Range newInstance(Ipv6 start, Ipv6 end) {
        return new Ipv6Range(start, end);
    }

    public static Ipv6RangeBuilder from(Ipv6 from) {
        return new Ipv6RangeBuilder(from);
    }

    public static Ipv6RangeBuilder from(BigInteger from) {
        return new Ipv6RangeBuilder(Ipv6.of(from));
    }

    public static Ipv6RangeBuilder from(String from) {
        return new Ipv6RangeBuilder(Ipv6.parse(from));
    }

    public static Ipv6Range parse(String range) {
        int idx = range.indexOf("-");
        if (idx != -1) {
            Ipv6 start = Ipv6.parse(range.substring(0, idx));
            Ipv6 end = Ipv6.parse(range.substring(idx + 1, range.length()));
            return new Ipv6Range(start, end);
        }
        return Ipv6Range.parseCidr(range);
    }

    public static Ipv6Range parseCidr(String cidrString) {
        int idx = cidrString.indexOf("/");
        Validate.isTrue(idx != -1, "Argument [" + cidrString + "] is not a range or does not comply with the CIDR notation");
        String address = cidrString.substring(0, idx);
        String prefix = cidrString.substring(idx + 1, cidrString.length());
        return Ipv6Range.from(address).andPrefixLength(prefix);
    }

    public static Ipv6Range parseDecimalNotation(String range) {
        int idx = range.indexOf("-");
        Validate.isTrue(idx != -1, "Argument [" + range + "] does not comply with the decimal range notation");
        BigInteger start = new BigInteger(range.substring(0, idx));
        BigInteger end = new BigInteger(range.substring(idx + 1, range.length()));
        return Ipv6Range.from(start).to(end);
    }

    public BigInteger size() {
        return ((Ipv6)this.end()).value().subtract(((Ipv6)this.start()).value()).add(BigInteger.ONE);
    }

    public static class Ipv6RangeBuilder
    extends AbstractRange.AbstractRangeBuilder<Ipv6, Ipv6Range> {
        private final Ipv6 from;

        protected Ipv6RangeBuilder(Ipv6 from) {
            this.from = from;
        }

        @Override
        public Ipv6Range to(BigInteger end) {
            return this.to(Ipv6.of(end));
        }

        @Override
        public Ipv6Range to(String end) {
            return this.to(Ipv6.parse(end));
        }

        public Ipv6Range andPrefixLength(String prefixLength) {
            return this.andPrefixLength(Integer.parseInt(prefixLength));
        }

        public Ipv6Range andPrefixLength(int prefixLength) {
            Validate.isTrue(this.from.lowerBoundForPrefix(prefixLength).equals(this.from), this.from + "/" + prefixLength + " is not a legal IPv6 address prefix.");
            return this.to(this.from.upperBoundForPrefix(prefixLength));
        }

        @Override
        public Ipv6Range to(Ipv6 to) {
            return new Ipv6Range(this.from, to);
        }
    }
}

