/*
 * Decompiled with CFR 0.152.
 */
package net.rk4z.beacon;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import net.rk4z.beacon.CancellableEvent;
import net.rk4z.beacon.Event;
import net.rk4z.beacon.EventHook;
import net.rk4z.beacon.Listener;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\tJ,\u0010\u0018\u001a\u00020\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\tJ\u001f\u0010\u0019\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00072\u0006\u0010\u001a\u001a\u0002H\u0015H\u0007\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00072\u0006\u0010\u001a\u001a\u0002H\u0015H\u0007\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0010J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0007J\u0006\u0010#\u001a\u00020\u0014J\b\u0010$\u001a\u00020\u0014H\u0007R0\u0010\u0004\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00070\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lnet/rk4z/beacon/EventBus;", "", "<init>", "()V", "registry", "", "Lkotlin/reflect/KClass;", "Lnet/rk4z/beacon/Event;", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lnet/rk4z/beacon/EventHook;", "asyncExecutor", "Ljava/util/concurrent/ExecutorService;", "logger", "Lorg/slf4j/Logger;", "listeners", "", "Lnet/rk4z/beacon/Listener;", "getListeners", "()Ljava/util/List;", "registerEventHook", "", "T", "eventClass", "eventHook", "unregisterEventHook", "callEvent", "event", "(Lnet/rk4z/beacon/Event;)Lnet/rk4z/beacon/Event;", "callEventAsync", "registerListener", "listener", "unregisterListener", "registerAllListeners", "packageName", "", "initialize", "shutdown", "beacon"})
@SourceDebugExtension(value={"SMAP\nEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventBus.kt\nnet/rk4z/beacon/EventBus\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n381#2,7:138\n1019#3,2:145\n1863#3,2:147\n*S KotlinDebug\n*F\n+ 1 EventBus.kt\nnet/rk4z/beacon/EventBus\n*L\n22#1:138,7\n28#1:145,2\n110#1:147,2\n*E\n"})
public final class EventBus {
    @NotNull
    public static final EventBus INSTANCE = new EventBus();
    @NotNull
    private static final Map<KClass<? extends Event>, CopyOnWriteArrayList<EventHook<? super Event>>> registry = new LinkedHashMap();
    private static ExecutorService asyncExecutor;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final List<Listener> listeners;

    private EventBus() {
    }

    @NotNull
    public final List<Listener> getListeners() {
        return listeners;
    }

    public final <T extends Event> void registerEventHook(@NotNull KClass<T> eventClass, @NotNull EventHook<T> eventHook) {
        EventHook<T> hook;
        CopyOnWriteArrayList<EventHook<? super Event>> handlers;
        CopyOnWriteArrayList<EventHook<Event>> copyOnWriteArrayList;
        Intrinsics.checkNotNullParameter(eventClass, "eventClass");
        Intrinsics.checkNotNullParameter(eventHook, "eventHook");
        Map<KClass<? extends Event>, CopyOnWriteArrayList<EventHook<? super Event>>> $this$getOrPut$iv = registry;
        boolean $i$f$getOrPut = false;
        CopyOnWriteArrayList<EventHook<? super Event>> value$iv = $this$getOrPut$iv.get(eventClass);
        if (value$iv == null) {
            boolean bl = false;
            CopyOnWriteArrayList answer$iv = new CopyOnWriteArrayList();
            $this$getOrPut$iv.put(eventClass, answer$iv);
            copyOnWriteArrayList = answer$iv;
        } else {
            copyOnWriteArrayList = value$iv;
        }
        if (!(handlers = copyOnWriteArrayList).contains(hook = eventHook)) {
            handlers.add(hook);
            List $this$sortByDescending$iv = handlers;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        EventHook it = (EventHook)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPriority().getValue());
                        it = (EventHook)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getPriority().getValue());
                    }
                });
            }
            logger.info("Registered event hook for " + eventClass.getSimpleName() + " with priority " + hook.getPriority());
        }
    }

    public final <T extends Event> void unregisterEventHook(@NotNull KClass<T> eventClass, @NotNull EventHook<T> eventHook) {
        block0: {
            Intrinsics.checkNotNullParameter(eventClass, "eventClass");
            Intrinsics.checkNotNullParameter(eventHook, "eventHook");
            CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(eventClass);
            if (copyOnWriteArrayList == null) break block0;
            copyOnWriteArrayList.remove(eventHook);
        }
    }

    @JvmStatic
    @NotNull
    public static final <T extends Event> T callEvent(@NotNull T event) {
        Intrinsics.checkNotNullParameter(event, "event");
        logger.debug("Calling event: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(Reflection.getOrCreateKotlinClass(event.getClass()));
        if (copyOnWriteArrayList == null) {
            return event;
        }
        CopyOnWriteArrayList<EventHook<? super Event>> target = copyOnWriteArrayList;
        Iterator<EventHook<? super Event>> iterator2 = target.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<EventHook<? super Event>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object object;
            EventHook<? super Event> eventHook = iterator3.next();
            if (event instanceof CancellableEvent && ((CancellableEvent)event).isCancelled()) break;
            if (!eventHook.getIgnoresCondition() && !eventHook.getHandlerClass().handleEvents()) continue;
            Function0<Boolean> function0 = eventHook.getCondition();
            if (function0 != null ? !function0.invoke().booleanValue() : false) continue;
            Object object2 = INSTANCE;
            try {
                EventBus $this$callEvent_u24lambda_u242 = object2;
                boolean bl = false;
                eventHook.getHandler().invoke(event);
                logger.debug("Handled event: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) continue;
            Object it = object = throwable;
            boolean bl = false;
            logger.error("Exception while executing handler: " + ((Throwable)it).getMessage(), (Throwable)it);
        }
        return event;
    }

    @JvmStatic
    @NotNull
    public static final <T extends Event> T callEventAsync(@NotNull T event) {
        Intrinsics.checkNotNullParameter(event, "event");
        logger.debug("Calling event asynchronously: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(Reflection.getOrCreateKotlinClass(event.getClass()));
        if (copyOnWriteArrayList == null) {
            return event;
        }
        CopyOnWriteArrayList<EventHook<? super Event>> target = copyOnWriteArrayList;
        Iterator<EventHook<? super Event>> iterator2 = target.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<EventHook<? super Event>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            EventHook<? super Event> eventHook = iterator3.next();
            if (event instanceof CancellableEvent && ((CancellableEvent)event).isCancelled()) break;
            if (!eventHook.getIgnoresCondition() && !eventHook.getHandlerClass().handleEvents()) continue;
            Function0<Boolean> function0 = eventHook.getCondition();
            if (function0 != null ? !function0.invoke().booleanValue() : false) continue;
            ExecutorService executorService = asyncExecutor;
            if (executorService == null) {
                Intrinsics.throwUninitializedPropertyAccessException("asyncExecutor");
                executorService = null;
            }
            executorService.submit(() -> EventBus.callEventAsync$lambda$6(eventHook, event));
        }
        return event;
    }

    private final void registerListener(Listener listener) {
        listeners.add(listener);
    }

    public final void unregisterListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        listeners.remove(listener);
    }

    @JvmStatic
    public static final void registerAllListeners(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set<Class<Listener>> listenerClasses = reflections.getSubTypesOf(Listener.class);
        Intrinsics.checkNotNull(listenerClasses);
        Iterable $this$forEach$iv = listenerClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class listenerClass = (Class)element$iv;
            boolean bl = false;
            try {
                Listener listener;
                Intrinsics.checkNotNull(listenerClass);
                KClass kClass = JvmClassMappingKt.getKotlinClass(listenerClass);
                KFunction primaryConstructor = KClasses.getPrimaryConstructor(kClass);
                if (primaryConstructor != null) {
                    listener = (Listener)primaryConstructor.call(new Object[0]);
                } else {
                    listener = (Listener)kClass.getObjectInstance();
                    if (listener == null) {
                        listener = (Listener)KClasses.createInstance(kClass);
                    }
                }
                Listener instance = listener;
                Intrinsics.checkNotNull(instance, "null cannot be cast to non-null type net.rk4z.beacon.Listener");
                INSTANCE.registerListener(instance);
                logger.info("Registered listener: " + kClass.getSimpleName());
            }
            catch (Exception e) {
                logger.error("Failed to register listener: " + listenerClass.getName(), e);
            }
        }
    }

    public final void initialize() {
        asyncExecutor = Executors.newCachedThreadPool();
        logger.info("EventManager initialized");
    }

    @JvmStatic
    public static final void shutdown() {
        ExecutorService executorService = asyncExecutor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("asyncExecutor");
            executorService = null;
        }
        executorService.shutdown();
        logger.info("EventManager shutdown");
    }

    private static final void callEventAsync$lambda$6(EventHook $eventHook, Event $event) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter($event, "$event");
            Object object2 = INSTANCE;
            try {
                EventBus $this$callEventAsync_u24lambda_u246_u24lambda_u244 = object2;
                boolean bl = false;
                $eventHook.getHandler().invoke($event);
                logger.debug("Handled event asynchronously: " + Reflection.getOrCreateKotlinClass($event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass($eventHook.getHandlerClass().getClass()).getSimpleName());
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            logger.error("Exception while executing handler asynchronously: " + ((Throwable)it).getMessage(), (Throwable)it);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(EventBus.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        EventBus.logger = logger;
        listeners = new ArrayList();
    }
}

