/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.abilities;

import com.google.common.eventbus.Subscribe;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Broadcaster;
import net.serenitybdd.screenplay.events.ActorBeginsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorEndsPerformanceEvent;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;

public class BrowseTheWeb
extends PageObject
implements Ability {
    private final WebdriverManager webdriverManager = (WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class);
    private Actor actor;

    protected BrowseTheWeb(WebDriver browser) {
        super(browser);
        this.registerForEventNotification();
    }

    private void registerForEventNotification() {
        Broadcaster.getEventBus().register((Object)this);
    }

    public static BrowseTheWeb as(Actor actor) {
        return (BrowseTheWeb)((Object)((BrowseTheWeb)actor.abilityTo(BrowseTheWeb.class)).asActor(actor));
    }

    public static BrowseTheWeb with(WebDriver browser) {
        return new BrowseTheWeb(browser);
    }

    public <T extends PageObject> T onPage(Class<T> pageObjectClass) {
        return (T)Pages.instrumentedPageObjectUsing(pageObjectClass, (WebDriver)this.getDriver());
    }

    @Subscribe
    public void beginPerformance(ActorBeginsPerformanceEvent performanceEvent) {
        if (performanceEvent.getName().equals(this.actor.getName())) {
            this.webdriverManager.setCurrentDriver(this.getDriver());
        }
    }

    @Subscribe
    public void endPerformance(ActorEndsPerformanceEvent performanceEvent) {
        if (performanceEvent.getName().equals(this.actor.getName())) {
            this.webdriverManager.clearCurrentDriver();
        }
    }

    public <T extends Ability> T asActor(Actor actor) {
        this.actor = actor;
        return (T)((Object)this);
    }
}

