/*
 * Decompiled with CFR 0.152.
 */
package jp.ad.sinet.stream.plugins.s3;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jp.ad.sinet.stream.api.SinetStreamIOException;
import jp.ad.sinet.stream.plugins.s3.S3Parameters;
import lombok.Generated;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.waiters.S3Waiter;

class S3Cli {
    @Generated
    private static final Logger log = Logger.getLogger(S3Cli.class.getName());
    S3Client s3;

    S3Cli(S3Parameters s3parameters) {
        log.fine("S3Cli:ctor: s3parameters=" + s3parameters);
        Region[] regionLst = new Region[]{null, Region.AWS_GLOBAL};
        RuntimeException lastex = null;
        for (Region region : regionLst) {
            try {
                S3ClientBuilder builder = S3Client.builder();
                if (region != null) {
                    builder.region(region);
                }
                if (s3parameters.getAwsAccessKeyId() != null && s3parameters.getAwsSecretAccessKey() != null) {
                    AwsBasicCredentials credentials = AwsBasicCredentials.create((String)s3parameters.getAwsAccessKeyId(), (String)s3parameters.getAwsSecretAccessKey());
                    builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials));
                } else {
                    builder.credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build());
                }
                if (s3parameters.getEndpointURI() != null) {
                    builder.endpointOverride(s3parameters.getEndpointURI());
                }
                builder.forcePathStyle(Boolean.valueOf(true));
                this.s3 = (S3Client)builder.build();
                return;
            }
            catch (RuntimeException e) {
                lastex = e;
            }
        }
        throw lastex;
    }

    void close() {
        if (this.s3 != null) {
            this.s3.close();
            this.s3 = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    void createBucket(String bucket) {
        try {
            S3Waiter s3w = this.s3.waiter();
            CreateBucketRequest req = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucket).build();
            this.s3.createBucket(req);
            HeadBucketRequest wreq = (HeadBucketRequest)HeadBucketRequest.builder().bucket(bucket).build();
            WaiterResponse wres = s3w.waitUntilBucketExists(wreq);
            wres.matched().response().ifPresent(x -> log.info(x.toString()));
            log.info("XXX " + bucket + " is ready");
        }
        catch (BucketAlreadyOwnedByYouException e) {
            log.fine("createBucket failure: " + e);
        }
        catch (S3Exception e) {
            throw new SinetStreamIOException("createBucket failure", (Throwable)e);
        }
    }

    void putObj(String bucket, String path, byte[] msg, long timestamp_us) {
        log.fine("pubObj: bucket=" + bucket);
        log.fine("pubObj: path=" + path);
        log.fine("pubObj: msg.len=" + msg.length);
        log.fine("pubObj: timestamp_us=" + timestamp_us);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("timestamp", String.valueOf(timestamp_us));
        try {
            PutObjectRequest req = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(path).metadata(metadata).build();
            PutObjectResponse res = this.s3.putObject(req, RequestBody.fromBytes((byte[])msg));
            log.fine("PutObjectResponse=" + res);
        }
        catch (S3Exception e) {
            throw new SinetStreamIOException("putObject failure", (Throwable)e);
        }
    }

    ListObjRes listObj(String bucket, String prefix, Predicate<String> keyFilter, String continuationToken) {
        log.fine("listObj: bucket=" + bucket);
        log.fine("listObj: prefix=" + prefix);
        log.fine("listObj: continuationToken=" + continuationToken);
        ListObjectsV2Request.Builder builder = ListObjectsV2Request.builder();
        int maxKeys = 1;
        builder.bucket(bucket).maxKeys(Integer.valueOf(maxKeys)).prefix(prefix);
        if (continuationToken != null) {
            builder.continuationToken(continuationToken);
        }
        ListObjectsV2Request req = (ListObjectsV2Request)builder.build();
        ListObjectsV2Response res = this.s3.listObjectsV2(req);
        List objs = res.contents();
        List<String> keys = objs.stream().map(obj -> obj.key()).peek(x -> log.fine("listObj.peek: " + x)).filter(key -> keyFilter.test((String)key)).collect(Collectors.toList());
        ListObjRes r = new ListObjRes(keys, res.nextContinuationToken());
        log.fine("listObjRes=" + r);
        return r;
    }

    GetObjRes getObj(String bucket, String key) {
        log.fine("getObj: bucket=" + bucket);
        log.fine("getObj: key=" + key);
        GetObjectRequest req = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
        ResponseBytes resbytes = this.s3.getObjectAsBytes(req);
        GetObjectResponse res = (GetObjectResponse)resbytes.response();
        String timestamp_us = (String)res.metadata().get("timestamp");
        long tstamp_us = 0L;
        if (timestamp_us != null) {
            try {
                tstamp_us = Long.parseLong(timestamp_us);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        GetObjRes r = new GetObjRes(resbytes.asByteArray(), tstamp_us, res);
        log.fine("GetObjRes=" + r);
        return r;
    }

    void deleteObjs(String bucket, List<String> keys) {
        log.fine("deleteObjs: bucket=" + bucket);
        log.fine("deleteObjs: keys=" + keys);
        LinkedList<ObjectIdentifier> xxx = new LinkedList<ObjectIdentifier>();
        for (String key : keys) {
            xxx.add((ObjectIdentifier)ObjectIdentifier.builder().key(key).build());
        }
        Delete del = (Delete)Delete.builder().objects(xxx).build();
        DeleteObjectsRequest req = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete(del).build();
        try {
            this.s3.deleteObjects(req);
        }
        catch (S3Exception e) {
            throw new SinetStreamIOException("deleteObjects failure", (Throwable)e);
        }
    }

    final class GetObjRes {
        public final byte[] data;
        public final long timestamp_us;
        public final GetObjectResponse res;

        @Generated
        public GetObjRes(byte[] data, long timestamp_us, GetObjectResponse res) {
            this.data = data;
            this.timestamp_us = timestamp_us;
            this.res = res;
        }

        @Generated
        public byte[] getData() {
            return this.data;
        }

        @Generated
        public long getTimestamp_us() {
            return this.timestamp_us;
        }

        @Generated
        public GetObjectResponse getRes() {
            return this.res;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetObjRes)) {
                return false;
            }
            GetObjRes other = (GetObjRes)o;
            if (this.getTimestamp_us() != other.getTimestamp_us()) {
                return false;
            }
            if (!Arrays.equals(this.getData(), other.getData())) {
                return false;
            }
            GetObjectResponse this$res = this.getRes();
            GetObjectResponse other$res = other.getRes();
            return !(this$res == null ? other$res != null : !this$res.equals(other$res));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp_us = this.getTimestamp_us();
            result = result * 59 + (int)($timestamp_us >>> 32 ^ $timestamp_us);
            result = result * 59 + Arrays.hashCode(this.getData());
            GetObjectResponse $res = this.getRes();
            result = result * 59 + ($res == null ? 43 : $res.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "S3Cli.GetObjRes(data=" + Arrays.toString(this.getData()) + ", timestamp_us=" + this.getTimestamp_us() + ", res=" + this.getRes() + ")";
        }
    }

    final class ListObjRes {
        public final List<String> keyList;
        public final String continuationToken;

        @Generated
        public ListObjRes(List<String> keyList, String continuationToken) {
            this.keyList = keyList;
            this.continuationToken = continuationToken;
        }

        @Generated
        public List<String> getKeyList() {
            return this.keyList;
        }

        @Generated
        public String getContinuationToken() {
            return this.continuationToken;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListObjRes)) {
                return false;
            }
            ListObjRes other = (ListObjRes)o;
            List<String> this$keyList = this.getKeyList();
            List<String> other$keyList = other.getKeyList();
            if (this$keyList == null ? other$keyList != null : !((Object)this$keyList).equals(other$keyList)) {
                return false;
            }
            String this$continuationToken = this.getContinuationToken();
            String other$continuationToken = other.getContinuationToken();
            return !(this$continuationToken == null ? other$continuationToken != null : !this$continuationToken.equals(other$continuationToken));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $keyList = this.getKeyList();
            result = result * 59 + ($keyList == null ? 43 : ((Object)$keyList).hashCode());
            String $continuationToken = this.getContinuationToken();
            result = result * 59 + ($continuationToken == null ? 43 : $continuationToken.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "S3Cli.ListObjRes(keyList=" + this.getKeyList() + ", continuationToken=" + this.getContinuationToken() + ")";
        }
    }
}

