/*
 * Decompiled with CFR 0.152.
 */
package jp.ad.sinet.stream.plugins.s3;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import jp.ad.sinet.stream.api.Consistency;
import jp.ad.sinet.stream.api.InvalidConfigurationException;
import jp.ad.sinet.stream.api.SinetStreamIOException;
import jp.ad.sinet.stream.plugins.s3.S3Cli;
import jp.ad.sinet.stream.plugins.s3.S3Parameters;
import jp.ad.sinet.stream.plugins.s3.Util;
import jp.ad.sinet.stream.spi.PluginMessageWriter;
import jp.ad.sinet.stream.spi.WriterParameters;
import jp.ad.sinet.stream.utils.Timestamped;
import lombok.Generated;

public class S3MessageWriter
implements PluginMessageWriter {
    @Generated
    private static final Logger log = Logger.getLogger(S3MessageWriter.class.getName());
    private final String topic;
    private final Consistency consistency;
    private final String clientId;
    S3Cli s3cli;
    Util.ObjPath objPath;
    S3Parameters s3parameters;

    void connect() {
        this.s3cli = new S3Cli(this.s3parameters);
    }

    S3MessageWriter(WriterParameters parameters) {
        log.fine("S3MessageWriter: ctor=" + parameters);
        this.topic = parameters.getTopic();
        if (parameters.getConfig().get("brokers") != null) {
            throw new InvalidConfigurationException("brokers: cannot be specified for s3; use s3.endpoint_url");
        }
        this.consistency = parameters.getConsistency();
        if (this.consistency != Consistency.AT_MOST_ONCE) {
            throw new InvalidConfigurationException("consistency must be AT_MOST_ONCE for s3");
        }
        this.s3parameters = S3Parameters.create(parameters.getConfig());
        log.fine("S3MessageWriter: s3parameters=" + this.s3parameters);
        this.objPath = new Util.ObjPath(new Util(), this.s3parameters.getPrefix(), this.topic, this.s3parameters.getName(), this.s3parameters.getUtcOffset(), this.s3parameters.getSuffix());
        String clientId = parameters.getClientId();
        this.clientId = clientId != null && !clientId.isEmpty() ? clientId : this.objPath.getUuid();
        UUID.randomUUID().toString();
        this.connect();
        if (this.s3parameters.getCreateBucketOnInit().booleanValue()) {
            try {
                this.s3cli.createBucket(this.s3parameters.getBucket());
            }
            catch (SinetStreamIOException e) {
                log.warning("create_bucket_on_init failure: " + e);
                e.printStackTrace();
            }
        }
        if (this.s3parameters.getDeleteObjectsOnInit().booleanValue()) {
            try {
                S3Cli.ListObjRes res;
                LinkedList<String> keys = new LinkedList<String>();
                String continuationToken = null;
                do {
                    res = this.s3cli.listObj(this.s3parameters.getBucket(), this.s3parameters.getPrefix(), k -> true, continuationToken);
                    keys.addAll(res.keyList);
                } while ((continuationToken = res.continuationToken) != null);
                if (!keys.isEmpty()) {
                    this.s3cli.deleteObjs(this.s3parameters.getBucket(), keys);
                }
            }
            catch (SinetStreamIOException e) {
                log.warning("delete_objects_on_init failure: " + e);
                e.printStackTrace();
            }
        }
    }

    public void write(Timestamped<byte[]> message) {
        log.fine("S3MessageWriter: write");
        long tstamp = message.getTstamp();
        String path = this.objPath.gen(tstamp);
        this.s3cli.putObj(this.s3parameters.getBucket(), path, (byte[])message.getValue(), tstamp);
    }

    public void close() {
        if (this.s3cli != null) {
            this.s3cli.close();
            this.s3cli = null;
        }
    }

    public Map<String, Object> getConfig() {
        return null;
    }

    public Object getInfo(List<String> ipath) {
        int ipath_size;
        if (ipath == null || (ipath_size = ipath.size()) == 0) {
            HashMap info = new HashMap();
            HashMap<String, String> winfo = new HashMap<String, String>();
            winfo.put("uuid", this.objPath.getUuid());
            info.put("writer", winfo);
            return info;
        }
        if (ipath_size == 1) {
            if (ipath.get(0).equals("writer")) {
                HashMap<String, String> winfo = new HashMap<String, String>();
                winfo.put("uuid", this.objPath.getUuid());
                return winfo;
            }
        } else if (ipath_size == 2 && ipath.get(0).equals("writer") && ipath.get(1).equals("uuid")) {
            return this.objPath.getUuid();
        }
        return null;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public Consistency getConsistency() {
        return this.consistency;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }
}

