/*
 * Decompiled with CFR 0.152.
 */
package jp.ad.sinet.stream.plugins.s3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import jp.ad.sinet.stream.api.InvalidConfigurationException;
import lombok.Generated;

final class S3Parameters {
    private final String endpointUrl;
    private final String bucket;
    private final String prefix;
    private final String name;
    private final String utcOffset;
    private final String suffix;
    private final String awsAccessKeyId;
    private final String awsSecretAccessKey;
    private final Boolean createBucketOnInit;
    private final Boolean deleteObjectsOnInit;

    private static String getp(Map<String, Object> m, String k, boolean mustp) {
        Object o = m.get(k);
        if (o == null) {
            if (mustp) {
                throw new InvalidConfigurationException("s3." + k + " must be specified");
            }
            return null;
        }
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("s3." + k + " must be string");
        }
    }

    private static boolean getp(Map<String, Object> m, String k, boolean mustp, boolean dflt) {
        Object o = m.get(k);
        if (o == null) {
            if (mustp) {
                throw new InvalidConfigurationException("s3." + k + " must be specified");
            }
            return dflt;
        }
        try {
            return (Boolean)o;
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("s3." + k + " must be string");
        }
    }

    public static S3Parameters create(Map<String, Object> config) {
        try {
            Map s3config = null;
            if (config != null) {
                s3config = (Map)config.get("s3");
            }
            if (s3config == null) {
                throw new InvalidConfigurationException("the parameter s3 must be specified");
            }
            return S3Parameters.s3create(s3config);
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("the parameter s3 must be mapping");
        }
    }

    private static S3Parameters s3create(Map<String, Object> s3config) {
        S3Parameters r = new S3Parameters(S3Parameters.getp(s3config, "endpoint_url", true), S3Parameters.getp(s3config, "bucket", true), S3Parameters.getp(s3config, "prefix", true), S3Parameters.getp(s3config, "name", true), S3Parameters.getp(s3config, "utc_offset", false), S3Parameters.getp(s3config, "suffix", true), S3Parameters.getp(s3config, "aws_access_key_id", false), S3Parameters.getp(s3config, "aws_secret_access_key", false), S3Parameters.getp(s3config, "create_bucket_on_init", false, false), S3Parameters.getp(s3config, "delete_objects_on_init", false, false));
        r.check();
        return r;
    }

    private void check() {
        if (this.awsAccessKeyId != null != (this.awsSecretAccessKey != null)) {
            throw new InvalidConfigurationException("both aws_access_key_id and aws_secret_access_key must be specified");
        }
    }

    URI getEndpointURI() {
        try {
            return new URI(this.endpointUrl);
        }
        catch (URISyntaxException e) {
            throw new InvalidConfigurationException("invalid endpoint_url", (Throwable)e);
        }
    }

    @Generated
    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    @Generated
    public String getBucket() {
        return this.bucket;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUtcOffset() {
        return this.utcOffset;
    }

    @Generated
    public String getSuffix() {
        return this.suffix;
    }

    @Generated
    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    @Generated
    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    @Generated
    public Boolean getCreateBucketOnInit() {
        return this.createBucketOnInit;
    }

    @Generated
    public Boolean getDeleteObjectsOnInit() {
        return this.deleteObjectsOnInit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3Parameters)) {
            return false;
        }
        S3Parameters other = (S3Parameters)o;
        Boolean this$createBucketOnInit = this.getCreateBucketOnInit();
        Boolean other$createBucketOnInit = other.getCreateBucketOnInit();
        if (this$createBucketOnInit == null ? other$createBucketOnInit != null : !((Object)this$createBucketOnInit).equals(other$createBucketOnInit)) {
            return false;
        }
        Boolean this$deleteObjectsOnInit = this.getDeleteObjectsOnInit();
        Boolean other$deleteObjectsOnInit = other.getDeleteObjectsOnInit();
        if (this$deleteObjectsOnInit == null ? other$deleteObjectsOnInit != null : !((Object)this$deleteObjectsOnInit).equals(other$deleteObjectsOnInit)) {
            return false;
        }
        String this$endpointUrl = this.getEndpointUrl();
        String other$endpointUrl = other.getEndpointUrl();
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$utcOffset = this.getUtcOffset();
        String other$utcOffset = other.getUtcOffset();
        if (this$utcOffset == null ? other$utcOffset != null : !this$utcOffset.equals(other$utcOffset)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        String this$awsAccessKeyId = this.getAwsAccessKeyId();
        String other$awsAccessKeyId = other.getAwsAccessKeyId();
        if (this$awsAccessKeyId == null ? other$awsAccessKeyId != null : !this$awsAccessKeyId.equals(other$awsAccessKeyId)) {
            return false;
        }
        String this$awsSecretAccessKey = this.getAwsSecretAccessKey();
        String other$awsSecretAccessKey = other.getAwsSecretAccessKey();
        return !(this$awsSecretAccessKey == null ? other$awsSecretAccessKey != null : !this$awsSecretAccessKey.equals(other$awsSecretAccessKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $createBucketOnInit = this.getCreateBucketOnInit();
        result = result * 59 + ($createBucketOnInit == null ? 43 : ((Object)$createBucketOnInit).hashCode());
        Boolean $deleteObjectsOnInit = this.getDeleteObjectsOnInit();
        result = result * 59 + ($deleteObjectsOnInit == null ? 43 : ((Object)$deleteObjectsOnInit).hashCode());
        String $endpointUrl = this.getEndpointUrl();
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $utcOffset = this.getUtcOffset();
        result = result * 59 + ($utcOffset == null ? 43 : $utcOffset.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        String $awsAccessKeyId = this.getAwsAccessKeyId();
        result = result * 59 + ($awsAccessKeyId == null ? 43 : $awsAccessKeyId.hashCode());
        String $awsSecretAccessKey = this.getAwsSecretAccessKey();
        result = result * 59 + ($awsSecretAccessKey == null ? 43 : $awsSecretAccessKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "S3Parameters(endpointUrl=" + this.getEndpointUrl() + ", bucket=" + this.getBucket() + ", prefix=" + this.getPrefix() + ", name=" + this.getName() + ", utcOffset=" + this.getUtcOffset() + ", suffix=" + this.getSuffix() + ", awsAccessKeyId=" + this.getAwsAccessKeyId() + ", awsSecretAccessKey=" + this.getAwsSecretAccessKey() + ", createBucketOnInit=" + this.getCreateBucketOnInit() + ", deleteObjectsOnInit=" + this.getDeleteObjectsOnInit() + ")";
    }

    @Generated
    public S3Parameters(String endpointUrl, String bucket, String prefix, String name, String utcOffset, String suffix, String awsAccessKeyId, String awsSecretAccessKey, Boolean createBucketOnInit, Boolean deleteObjectsOnInit) {
        this.endpointUrl = endpointUrl;
        this.bucket = bucket;
        this.prefix = prefix;
        this.name = name;
        this.utcOffset = utcOffset;
        this.suffix = suffix;
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = awsSecretAccessKey;
        this.createBucketOnInit = createBucketOnInit;
        this.deleteObjectsOnInit = deleteObjectsOnInit;
    }
}

