/*
 * Decompiled with CFR 0.152.
 */
package jp.ad.sinet.stream.plugins.s3;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jp.ad.sinet.stream.api.InvalidConfigurationException;
import lombok.Generated;

class Util {
    @Generated
    private static final Logger log = Logger.getLogger(Util.class.getName());

    Util() {
    }

    static ZoneId parseUtcOffset(String z) {
        int m;
        int h;
        if (z == null) {
            ZoneId zi = ZoneOffset.systemDefault();
            log.fine("parseUtcOffset: null -> " + zi);
            return zi;
        }
        int i = Integer.parseInt(z);
        if (i < -99 || i > 99) {
            h = i / 100;
            m = i % 100;
        } else {
            h = i;
            m = 0;
        }
        ZoneOffset zo = ZoneOffset.ofHoursMinutes(h, m);
        log.fine("parseUtcOffset: " + z + " -> " + h + "," + m + "=" + zo);
        return zo;
    }

    static Predicate<String> makePathFilter(String prefix, List<String> topics, String name, String suffix) {
        StringBuilder s = new StringBuilder();
        s.append("^").append(Pattern.quote(prefix)).append("/");
        StringBuilder sb = new StringBuilder();
        sb.append("(?:");
        sb.append(String.join((CharSequence)"|", topics.stream().map(x -> Pattern.quote(x)).collect(Collectors.toList())));
        sb.append(")");
        String re_topics = sb.toString();
        s.append(re_topics).append("/");
        String re_year = "[1-9][0-9][0-9][0-9]/";
        String re_month = "(?:0[1-9]|1[012])/";
        String re_day = "(?:0[1-9]|[12][0-9]|3[01])/";
        String re_hour = "(?:[01][0-9]|2[0-3])/";
        String re_minute = "(?:[0-5][0-9])/";
        switch (name) {
            case "day": {
                s.append(re_year + re_month + re_day);
                break;
            }
            case "hour": {
                s.append(re_year + re_month + re_day + re_hour);
                break;
            }
            case "minute": {
                s.append(re_year + re_month + re_day + re_hour + re_minute);
                break;
            }
            default: {
                throw new InvalidConfigurationException("invalid s3.name specified");
            }
        }
        s.append(re_topics).append("-").append("[^/]+").append(Pattern.quote(suffix)).append("$");
        log.fine("re=" + s.toString());
        return Pattern.compile(s.toString()).asPredicate();
    }

    static String extractTopicFromPath(String path) {
        int i1 = path.indexOf(47);
        int i2 = path.indexOf(47, i1);
        if (i1 < 0 || i2 < 0) {
            return null;
        }
        return path.substring(i1, i2);
    }

    class ObjPath {
        String prefix;
        String topic;
        DateTimeFormatter formatter;
        ZoneId zoneId;
        String uuid;
        int seq;
        String suffix;

        ObjPath(String prefix, String topic, String name, String utcOffset, String suffix) {
            String pat;
            this.prefix = prefix;
            this.topic = topic;
            switch (name) {
                case "day": {
                    pat = "yyyy/MM/dd";
                    break;
                }
                case "hour": {
                    pat = "yyyy/MM/dd/HH";
                    break;
                }
                case "minute": {
                    pat = "yyyy/MM/dd/HH/mm";
                    break;
                }
                case "_second": {
                    pat = "yyyy/MM/dd/HH/mm/ss";
                    break;
                }
                default: {
                    throw new InvalidConfigurationException("invalid s3.name specified");
                }
            }
            this.formatter = DateTimeFormatter.ofPattern(pat);
            try {
                this.zoneId = Util.parseUtcOffset(utcOffset);
            }
            catch (RuntimeException e) {
                throw new InvalidConfigurationException("invalid utc_offset");
            }
            this.uuid = UUID.randomUUID().toString();
            this.seq = 0;
            this.suffix = suffix;
        }

        String gen(long now_us) {
            long t = now_us / 1000000L;
            Instant i = Instant.ofEpochSecond(t);
            OffsetDateTime odt = OffsetDateTime.ofInstant(i, this.zoneId);
            ++this.seq;
            StringBuilder s = new StringBuilder();
            s.append(this.prefix).append("/").append(this.topic).append("/").append(odt.format(this.formatter)).append("/").append(this.topic).append("-").append(this.uuid).append("-").append(this.seq).append(this.suffix);
            return s.toString();
        }

        String getUuid() {
            return this.uuid;
        }
    }
}

