/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.gui;

import java.util.Vector;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import net.sourceforge.floggy.persistence.Comparator;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.HospitalMIDlet;
import net.sourceforge.floggy.persistence.ObjectSet;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.gui.DoctorList;
import net.sourceforge.floggy.persistence.model.Doctor;
import net.sourceforge.floggy.persistence.model.Formation;

public class DoctorForm
extends Form
implements CommandListener {
    Doctor medico;
    ObjectSet formacoes;
    TextField txtNome;
    TextField txtCPF;
    DateField dtNascimento;
    TextField txtCRM;
    ChoiceGroup cgFormacao;
    Command cmdOk;
    Command cmdCancelar;
    static /* synthetic */ Class class$net$sourceforge$floggy$persistence$model$Formation;

    public DoctorForm(Doctor medico) {
        super("M\u00e9dico");
        this.medico = medico;
        this.iniciaComponentes();
        this.iniciaFormacao();
    }

    private void iniciaComponentes() {
        this.txtNome = new TextField("Nome", this.medico.getNome(), 30, 0);
        this.append((Item)this.txtNome);
        this.txtCPF = new TextField("CPF", this.medico.getCpf(), 30, 0);
        this.append((Item)this.txtCPF);
        this.dtNascimento = new DateField("Data Nascimento", 1);
        this.dtNascimento.setDate(this.medico.getDataNascimento());
        this.append((Item)this.dtNascimento);
        this.txtCRM = new TextField("CRM", this.medico.getCrm(), 30, 0);
        this.append((Item)this.txtCRM);
        this.cgFormacao = new ChoiceGroup("Forma\u00e7\u00e3o", 2);
        this.append((Item)this.cgFormacao);
        this.cmdOk = new Command("Ok", 4, 0);
        this.addCommand(this.cmdOk);
        this.cmdCancelar = new Command("Cancelar", 3, 1);
        this.addCommand(this.cmdCancelar);
        this.setCommandListener(this);
    }

    public void commandAction(Command cmd, Displayable dsp) {
        if (cmd == this.cmdOk) {
            PersistableManager pm = PersistableManager.getInstance();
            try {
                this.medico.setNome(this.txtNome.getString());
                this.medico.setCpf(this.txtCPF.getString());
                this.medico.setCrm(this.txtCRM.getString());
                this.medico.setDataNascimento(this.dtNascimento.getDate());
                if (this.medico.getFormacoes() != null) {
                    this.medico.getFormacoes().removeAllElements();
                } else {
                    this.medico.setFormacoes(new Vector());
                }
                for (int i = 0; i < this.cgFormacao.size(); ++i) {
                    if (!this.cgFormacao.isSelected(i)) continue;
                    this.medico.getFormacoes().addElement(this.formacoes.get(i));
                }
                pm.save((Persistable)this.medico);
            }
            catch (FloggyException e) {
                e.printStackTrace();
            }
        }
        HospitalMIDlet.setCurrent((Displayable)new DoctorList());
    }

    public void iniciaFormacao() {
        PersistableManager pm = PersistableManager.getInstance();
        try {
            this.formacoes = pm.find(class$net$sourceforge$floggy$persistence$model$Formation == null ? (class$net$sourceforge$floggy$persistence$model$Formation = DoctorForm.class$("net.sourceforge.floggy.persistence.model.Formation")) : class$net$sourceforge$floggy$persistence$model$Formation, null, new Comparator(){

                public int compare(Persistable arg0, Persistable arg1) {
                    Formation f1 = (Formation)arg0;
                    Formation f2 = (Formation)arg1;
                    return f1.getFormacao().compareTo(f2.getFormacao());
                }
            });
            for (int i = 0; i < this.formacoes.size(); ++i) {
                Formation formacao = (Formation)this.formacoes.get(i);
                int index = this.cgFormacao.append(formacao.getFormacao(), null);
                if (this.medico.getFormacoes() == null || !this.medico.getFormacoes().contains(formacao)) continue;
                this.cgFormacao.setSelectedIndex(index, true);
            }
        }
        catch (FloggyException e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

