/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.gui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import net.sourceforge.floggy.persistence.Comparator;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.HospitalMIDlet;
import net.sourceforge.floggy.persistence.ObjectSet;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.gui.DoctorForm;
import net.sourceforge.floggy.persistence.gui.MainForm;
import net.sourceforge.floggy.persistence.model.Doctor;

public class DoctorList
extends List
implements CommandListener {
    ObjectSet medicos;
    Command cmdInserir;
    Command cmdAlterar;
    Command cmdExcluir;
    Command cmdVoltar;
    static /* synthetic */ Class class$net$sourceforge$floggy$persistence$model$Doctor;

    public DoctorList() {
        super("Lista de M\u00e9dicos", 3);
        this.iniciaDados();
        this.iniciaComponentes();
    }

    private void iniciaDados() {
        PersistableManager pm = PersistableManager.getInstance();
        try {
            this.deleteAll();
            this.medicos = pm.find(class$net$sourceforge$floggy$persistence$model$Doctor == null ? (class$net$sourceforge$floggy$persistence$model$Doctor = DoctorList.class$("net.sourceforge.floggy.persistence.model.Doctor")) : class$net$sourceforge$floggy$persistence$model$Doctor, null, new Comparator(){

                public int compare(Persistable arg0, Persistable arg1) {
                    String s1 = arg0 == null ? "" : ((Doctor)arg0).getNome();
                    String s2 = arg1 == null ? "" : ((Doctor)arg1).getNome();
                    return s1.compareTo(s2);
                }
            });
            for (int i = 0; i < this.medicos.size(); ++i) {
                Doctor medico = (Doctor)this.medicos.get(i);
                this.append(medico.getNome() + " - CRM " + medico.getCrm(), null);
            }
        }
        catch (FloggyException e) {
            e.printStackTrace();
        }
    }

    private void iniciaComponentes() {
        this.cmdVoltar = new Command("Voltar", 2, 0);
        this.addCommand(this.cmdVoltar);
        this.cmdInserir = new Command("Inserir", 8, 1);
        this.addCommand(this.cmdInserir);
        this.cmdAlterar = new Command("Alterar", 8, 2);
        this.addCommand(this.cmdAlterar);
        this.cmdExcluir = new Command("Excluir", 8, 3);
        this.addCommand(this.cmdExcluir);
        this.setCommandListener(this);
    }

    public void commandAction(Command cmd, Displayable dsp) {
        if (cmd == this.cmdVoltar) {
            MainForm mainForm = new MainForm();
            HospitalMIDlet.setCurrent((Displayable)mainForm);
        } else if (cmd == this.cmdInserir) {
            Doctor medico = new Doctor();
            HospitalMIDlet.setCurrent((Displayable)new DoctorForm(medico));
        } else if (cmd == this.cmdAlterar) {
            if (this.getSelectedIndex() != -1) {
                Doctor medico = null;
                try {
                    medico = (Doctor)this.medicos.get(this.getSelectedIndex());
                    HospitalMIDlet.setCurrent((Displayable)new DoctorForm(medico));
                }
                catch (FloggyException e) {
                    e.printStackTrace();
                }
            }
        } else if (cmd == this.cmdExcluir && this.getSelectedIndex() != -1) {
            try {
                Doctor medico = (Doctor)this.medicos.get(this.getSelectedIndex());
                PersistableManager.getInstance().delete((Persistable)medico);
                this.iniciaDados();
            }
            catch (FloggyException e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

