/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.gui;

import java.util.Date;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import net.sourceforge.floggy.persistence.Comparator;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.HospitalMIDlet;
import net.sourceforge.floggy.persistence.ObjectSet;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.gui.MainForm;
import net.sourceforge.floggy.persistence.model.Bed;
import net.sourceforge.floggy.persistence.model.BedComparator;
import net.sourceforge.floggy.persistence.model.Doctor;
import net.sourceforge.floggy.persistence.model.Internment;
import net.sourceforge.floggy.persistence.model.Patient;

public class InternmentForm
extends Form
implements CommandListener {
    Internment internacao = new Internment();
    ObjectSet pacientes;
    ObjectSet medicos;
    ObjectSet leitos;
    DateField dtEntrada;
    TextField txtMotivo;
    ChoiceGroup cgPacientes;
    ChoiceGroup cgMedicos;
    ChoiceGroup cgLeitos;
    Command cmdOk;
    Command cmdCancelar;
    static /* synthetic */ Class class$net$sourceforge$floggy$persistence$model$Patient;
    static /* synthetic */ Class class$net$sourceforge$floggy$persistence$model$Doctor;
    static /* synthetic */ Class class$net$sourceforge$floggy$persistence$model$Bed;

    public InternmentForm() {
        super("Interna\u00e7\u00e3o");
        this.iniciaComponentes();
        this.iniciaPacientes();
        this.iniciaMedicos();
        this.iniciaLeitos();
    }

    private void iniciaComponentes() {
        this.dtEntrada = new DateField("Data Entrada", 1);
        this.dtEntrada.setDate(new Date());
        this.append((Item)this.dtEntrada);
        this.txtMotivo = new TextField("Motivo", this.internacao.getMotivo(), 100, 0);
        this.append((Item)this.txtMotivo);
        this.cgPacientes = new ChoiceGroup("Patient", 1);
        this.append((Item)this.cgPacientes);
        this.cgMedicos = new ChoiceGroup("Doctor", 1);
        this.append((Item)this.cgMedicos);
        this.cgLeitos = new ChoiceGroup("Leitos", 1);
        this.append((Item)this.cgLeitos);
        this.cmdOk = new Command("Ok", 4, 0);
        this.addCommand(this.cmdOk);
        this.cmdCancelar = new Command("Cancelar", 3, 1);
        this.addCommand(this.cmdCancelar);
        this.setCommandListener(this);
    }

    public void iniciaPacientes() {
        PersistableManager pm = PersistableManager.getInstance();
        try {
            this.pacientes = pm.find(class$net$sourceforge$floggy$persistence$model$Patient == null ? (class$net$sourceforge$floggy$persistence$model$Patient = InternmentForm.class$("net.sourceforge.floggy.persistence.model.Patient")) : class$net$sourceforge$floggy$persistence$model$Patient, null, new Comparator(){

                public int compare(Persistable arg0, Persistable arg1) {
                    Patient p1 = (Patient)arg0;
                    Patient p2 = (Patient)arg1;
                    return p1.getNome().compareTo(p2.getNome());
                }
            });
            for (int i = 0; i < this.pacientes.size(); ++i) {
                Patient paciente = (Patient)this.pacientes.get(i);
                this.cgPacientes.append(paciente.getNome(), null);
            }
        }
        catch (FloggyException e) {
            e.printStackTrace();
        }
    }

    public void iniciaMedicos() {
        PersistableManager pm = PersistableManager.getInstance();
        try {
            this.medicos = pm.find(class$net$sourceforge$floggy$persistence$model$Doctor == null ? (class$net$sourceforge$floggy$persistence$model$Doctor = InternmentForm.class$("net.sourceforge.floggy.persistence.model.Doctor")) : class$net$sourceforge$floggy$persistence$model$Doctor, null, new Comparator(){

                public int compare(Persistable arg0, Persistable arg1) {
                    Doctor p1 = (Doctor)arg0;
                    Doctor p2 = (Doctor)arg1;
                    return p1.getNome().compareTo(p2.getNome());
                }
            });
            for (int i = 0; i < this.medicos.size(); ++i) {
                Doctor medico = (Doctor)this.medicos.get(i);
                this.cgMedicos.append(medico.getNome(), null);
            }
        }
        catch (FloggyException e) {
            e.printStackTrace();
        }
    }

    public void iniciaLeitos() {
        PersistableManager pm = PersistableManager.getInstance();
        try {
            this.leitos = pm.find(class$net$sourceforge$floggy$persistence$model$Bed == null ? (class$net$sourceforge$floggy$persistence$model$Bed = InternmentForm.class$("net.sourceforge.floggy.persistence.model.Bed")) : class$net$sourceforge$floggy$persistence$model$Bed, null, (Comparator)new BedComparator());
            for (int i = 0; i < this.leitos.size(); ++i) {
                Bed leito = (Bed)this.leitos.get(i);
                this.cgLeitos.append(String.valueOf(leito.getNumber()), null);
            }
        }
        catch (FloggyException e) {
            e.printStackTrace();
        }
    }

    public Patient getPacienteSelecionado() {
        for (int i = 0; i < this.cgPacientes.size(); ++i) {
            if (!this.cgPacientes.isSelected(i)) continue;
            try {
                return (Patient)this.pacientes.get(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Doctor getMedicoSelecionado() {
        for (int i = 0; i < this.cgMedicos.size(); ++i) {
            if (!this.cgMedicos.isSelected(i)) continue;
            try {
                return (Doctor)this.medicos.get(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Bed getLeitoSelecionado() {
        for (int i = 0; i < this.cgLeitos.size(); ++i) {
            if (!this.cgLeitos.isSelected(i)) continue;
            try {
                return (Bed)this.leitos.get(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void commandAction(Command cmd, Displayable dsp) {
        if (cmd == this.cmdOk) {
            PersistableManager pm = PersistableManager.getInstance();
            try {
                this.internacao.setDtEntrada(this.dtEntrada.getDate());
                this.internacao.setMotivo(this.txtMotivo.getString());
                this.internacao.setPaciente(this.getPacienteSelecionado());
                this.internacao.setMedico(this.getMedicoSelecionado());
                this.internacao.setLeito(this.getLeitoSelecionado());
                pm.save((Persistable)this.internacao);
            }
            catch (FloggyException e) {
                e.printStackTrace();
            }
        }
        HospitalMIDlet.setCurrent((Displayable)new MainForm());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

