/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.gui;

import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.HospitalMIDlet;
import net.sourceforge.floggy.persistence.ObjectSet;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.gui.PatientList;
import net.sourceforge.floggy.persistence.model.Patient;

public class PatientForm
extends Form
implements CommandListener {
    Patient paciente;
    ObjectSet formacoes;
    TextField txtNome;
    TextField txtCPF;
    DateField dtNascimento;
    TextField txtEndereco;
    ChoiceGroup cgConvenio;
    TextField txtTelefoneCasa;
    TextField txtTelefoneCelular;
    TextField txtTelefoneTrabalho;
    Command cmdOk;
    Command cmdCancelar;

    public PatientForm(Patient paciente) {
        super("Patient");
        this.paciente = paciente;
        this.iniciaComponentes();
    }

    private void iniciaComponentes() {
        this.txtNome = new TextField("Nome", this.paciente.getNome(), 30, 0);
        this.append((Item)this.txtNome);
        this.txtCPF = new TextField("CPF", this.paciente.getCpf(), 30, 0);
        this.append((Item)this.txtCPF);
        this.dtNascimento = new DateField("Data Nascimento", 1);
        this.dtNascimento.setDate(this.paciente.getDataNascimento());
        this.append((Item)this.dtNascimento);
        this.txtEndereco = new TextField("Endere\u00e7o", this.paciente.getAddress(), 100, 0);
        this.append((Item)this.txtEndereco);
        this.append("Telefones");
        this.txtTelefoneCasa = new TextField("Casa", this.paciente.getTelefoneCasa(), 20, 3);
        this.append((Item)this.txtTelefoneCasa);
        this.txtTelefoneCelular = new TextField("Celular", this.paciente.getTelefoneCelular(), 20, 3);
        this.append((Item)this.txtTelefoneCelular);
        this.txtTelefoneTrabalho = new TextField("Trabalho", this.paciente.getTelefoneTrabalho(), 20, 3);
        this.append((Item)this.txtTelefoneTrabalho);
        this.cgConvenio = new ChoiceGroup("Tipo:", 1);
        this.cgConvenio.append("Particular", null);
        this.cgConvenio.append("Conv\u00eanio", null);
        this.cgConvenio.setSelectedIndex(0, this.paciente.isInsuredByGoverment());
        this.cgConvenio.setSelectedIndex(1, !this.paciente.isInsuredByGoverment());
        this.append((Item)this.cgConvenio);
        this.cmdOk = new Command("Ok", 4, 0);
        this.addCommand(this.cmdOk);
        this.cmdCancelar = new Command("Cancelar", 3, 1);
        this.addCommand(this.cmdCancelar);
        this.setCommandListener(this);
    }

    public void commandAction(Command cmd, Displayable dsp) {
        if (cmd == this.cmdOk) {
            PersistableManager pm = PersistableManager.getInstance();
            try {
                this.paciente.setNome(this.txtNome.getString());
                this.paciente.setCpf(this.txtCPF.getString());
                this.paciente.setDataNascimento(this.dtNascimento.getDate());
                this.paciente.setInsuredByGoverment(this.cgConvenio.isSelected(0));
                this.paciente.setTelefoneCasa(this.txtTelefoneCasa.getString());
                this.paciente.setTelefoneCelular(this.txtTelefoneCelular.getString());
                this.paciente.setTelefoneTrabalho(this.txtTelefoneTrabalho.getString());
                pm.save((Persistable)this.paciente);
            }
            catch (FloggyException e) {
                e.printStackTrace();
            }
        }
        HospitalMIDlet.setCurrent((Displayable)new PatientList());
    }
}

