/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.gui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import net.sourceforge.floggy.persistence.Comparator;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.HospitalMIDlet;
import net.sourceforge.floggy.persistence.ObjectSet;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.gui.MainForm;
import net.sourceforge.floggy.persistence.gui.PatientForm;
import net.sourceforge.floggy.persistence.model.Patient;

public class PatientList
extends List
implements CommandListener {
    ObjectSet pacientes;
    Command cmdInserir;
    Command cmdAlterar;
    Command cmdExcluir;
    Command cmdVoltar;
    static /* synthetic */ Class class$net$sourceforge$floggy$persistence$model$Patient;

    public PatientList() {
        super("Lista de Pacientes", 3);
        this.iniciaDados();
        this.iniciaComponentes();
    }

    private void iniciaDados() {
        PersistableManager pm = PersistableManager.getInstance();
        try {
            this.deleteAll();
            this.pacientes = pm.find(class$net$sourceforge$floggy$persistence$model$Patient == null ? (class$net$sourceforge$floggy$persistence$model$Patient = PatientList.class$("net.sourceforge.floggy.persistence.model.Patient")) : class$net$sourceforge$floggy$persistence$model$Patient, null, new Comparator(){

                public int compare(Persistable arg0, Persistable arg1) {
                    String s1 = arg0 == null ? "" : ((Patient)arg0).getNome();
                    String s2 = arg1 == null ? "" : ((Patient)arg1).getNome();
                    return s1.compareTo(s2);
                }
            });
            for (int i = 0; i < this.pacientes.size(); ++i) {
                Patient paciente = (Patient)this.pacientes.get(i);
                String tipo = paciente.isInsuredByGoverment() ? "Particular" : "Conv\u00eanio";
                this.append(paciente.getNome() + " - " + tipo, null);
            }
        }
        catch (FloggyException e) {
            e.printStackTrace();
        }
    }

    private void iniciaComponentes() {
        this.cmdVoltar = new Command("Voltar", 2, 0);
        this.addCommand(this.cmdVoltar);
        this.cmdInserir = new Command("Inserir", 8, 1);
        this.addCommand(this.cmdInserir);
        this.cmdAlterar = new Command("Alterar", 8, 2);
        this.addCommand(this.cmdAlterar);
        this.cmdExcluir = new Command("Excluir", 8, 3);
        this.addCommand(this.cmdExcluir);
        this.setCommandListener(this);
    }

    public void commandAction(Command cmd, Displayable dsp) {
        if (cmd == this.cmdVoltar) {
            MainForm mainForm = new MainForm();
            HospitalMIDlet.setCurrent((Displayable)mainForm);
        } else if (cmd == this.cmdInserir) {
            Patient paciente = new Patient();
            HospitalMIDlet.setCurrent((Displayable)new PatientForm(paciente));
        } else if (cmd == this.cmdAlterar) {
            if (this.getSelectedIndex() != -1) {
                Patient paciente = null;
                try {
                    paciente = (Patient)this.pacientes.get(this.getSelectedIndex());
                    HospitalMIDlet.setCurrent((Displayable)new PatientForm(paciente));
                }
                catch (FloggyException e) {
                    e.printStackTrace();
                }
            }
        } else if (cmd == this.cmdExcluir && this.getSelectedIndex() != -1) {
            try {
                Patient paciente = (Patient)this.pacientes.get(this.getSelectedIndex());
                PersistableManager.getInstance().delete((Persistable)paciente);
                this.iniciaDados();
            }
            catch (FloggyException e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

