/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.impl.FloggyOutputStream;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.SerializationHelper;

public class MetadataManagerUtil {
    public static final String VERSION_1_0_1 = "1.0.1";
    public static final String VERSION_1_1_0 = "1.1.0";
    public static final String VERSION_1_1_1 = "1.1.1";
    public static final String VERSION_1_2_0 = "1.2.0";
    public static final String VERSION_1_3_0 = "1.3.0";
    public static final String CURRENT_VERSION = "1.3.0";
    private static String rmsVersion;
    private static Hashtable classBasedMetadatas;
    private static Hashtable rmsBasedMetadatas;
    private static Vector notMigratedClassNames;

    public static void addRMSMetadata(PersistableMetadata persistableMetadata) {
        rmsBasedMetadatas.put(persistableMetadata.getClassName(), persistableMetadata);
        notMigratedClassNames.removeElement(persistableMetadata.getClassName());
    }

    public static boolean containsRMSMetadata(PersistableMetadata persistableMetadata) {
        return rmsBasedMetadatas.containsKey(persistableMetadata.getClassName());
    }

    private static void deserialize(byte[] byArray) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        while (dataInputStream.available() != 0) {
            String string = dataInputStream.readUTF();
            if (!"version".equals(string)) continue;
            rmsVersion = dataInputStream.readUTF();
        }
    }

    public static String getBytecodeVersion() {
        return "1.3.0";
    }

    public static PersistableMetadata getClassBasedMetadata(String string) {
        return (PersistableMetadata)classBasedMetadatas.get(string);
    }

    public static Vector getNotMigratedClasses() {
        return notMigratedClassNames;
    }

    public static PersistableMetadata getRMSBasedMetadata(String string) {
        return (PersistableMetadata)rmsBasedMetadatas.get(string);
    }

    public static String getRMSVersion() {
        return rmsVersion;
    }

    public static void init() throws Exception {
    }

    public static void load() throws Exception {
        notMigratedClassNames = new Vector();
        RecordStore recordStore = RecordStore.openRecordStore((String)"FloggyProperties", (boolean)true);
        if (recordStore.getNumRecords() != 0) {
            MetadataManagerUtil.deserialize(recordStore.getRecord(1));
            MetadataManagerUtil.loadRMSStructure();
        } else {
            rmsVersion = "1.3.0";
            MetadataManagerUtil.save(recordStore);
        }
        if (classBasedMetadatas != null) {
            Enumeration enumeration = classBasedMetadatas.keys();
            while (enumeration.hasMoreElements()) {
                PersistableMetadata persistableMetadata;
                String string = (String)enumeration.nextElement();
                PersistableMetadata persistableMetadata2 = (PersistableMetadata)classBasedMetadatas.get(string);
                if (persistableMetadata2.equals(persistableMetadata = (PersistableMetadata)rmsBasedMetadatas.get(string))) continue;
                notMigratedClassNames.addElement(string);
            }
        }
    }

    private static void loadRMSStructure() throws Exception {
        RecordStore recordStore = RecordStore.openRecordStore((String)"FloggyProperties", (boolean)true);
        RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
        while (recordEnumeration.hasNextElement()) {
            int n = recordEnumeration.nextRecordId();
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(n)));
            String string = dataInputStream.readUTF();
            if ("version".equals(string)) continue;
            boolean bl = dataInputStream.readBoolean();
            String string2 = SerializationHelper.readString(dataInputStream);
            String[] stringArray = new String[dataInputStream.readInt()];
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = dataInputStream.readUTF();
                nArray[i] = dataInputStream.readInt();
            }
            Hashtable hashtable = SerializationHelper.readHashtable(dataInputStream);
            String string3 = dataInputStream.readUTF();
            MetadataManagerUtil.addRMSMetadata(new PersistableMetadata(bl, string, string2, stringArray, nArray, hashtable, string3, n));
        }
    }

    private static void save(RecordStore recordStore) throws IOException, RecordStoreException {
        byte[] byArray = MetadataManagerUtil.serialize();
        if (recordStore.getNumRecords() == 1) {
            recordStore.setRecord(1, byArray, 0, byArray.length);
        } else {
            recordStore.addRecord(byArray, 0, byArray.length);
        }
    }

    public static void saveRMSStructure(PersistableMetadata persistableMetadata) throws Exception {
        String[] stringArray = persistableMetadata.getFieldNames();
        int[] nArray = persistableMetadata.getFieldTypes();
        FloggyOutputStream floggyOutputStream = new FloggyOutputStream();
        floggyOutputStream.writeUTF(persistableMetadata.getClassName());
        floggyOutputStream.writeBoolean(persistableMetadata.isAbstract());
        SerializationHelper.writeString(floggyOutputStream, persistableMetadata.getSuperClassName());
        floggyOutputStream.writeInt(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            floggyOutputStream.writeUTF(stringArray[i]);
            floggyOutputStream.writeInt(nArray[i]);
        }
        SerializationHelper.writeHashtable(floggyOutputStream, persistableMetadata.getPersistableImplementations());
        floggyOutputStream.writeUTF(persistableMetadata.getRecordStoreName());
        byte[] byArray = floggyOutputStream.toByteArray();
        RecordStore recordStore = RecordStore.openRecordStore((String)"FloggyProperties", (boolean)true);
        int n = persistableMetadata.getRecordId();
        if (n != -1) {
            recordStore.setRecord(n, byArray, 0, byArray.length);
        } else {
            persistableMetadata.setRecordId(recordStore.addRecord(byArray, 0, byArray.length));
        }
        MetadataManagerUtil.addRMSMetadata(persistableMetadata);
    }

    private static byte[] serialize() throws IOException {
        FloggyOutputStream floggyOutputStream = new FloggyOutputStream();
        floggyOutputStream.writeUTF("version");
        floggyOutputStream.writeUTF(rmsVersion);
        return floggyOutputStream.toByteArray();
    }

    protected MetadataManagerUtil() {
    }
}

