/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.util.Hashtable;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.Comparator;
import net.sourceforge.floggy.persistence.Filter;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.ObjectSet;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.impl.MetadataManagerUtil;
import net.sourceforge.floggy.persistence.impl.ObjectComparator;
import net.sourceforge.floggy.persistence.impl.ObjectFilter;
import net.sourceforge.floggy.persistence.impl.ObjectSetImpl;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.SerializationHelper;
import net.sourceforge.floggy.persistence.impl.__Persistable;

public class PersistableManagerImpl
extends PersistableManager {
    private static Class __persistableClass;
    private static Class deletableClass;
    private static Hashtable references;

    public static __Persistable checkArgumentAndCast(Persistable persistable) {
        if (persistable == null) {
            throw new IllegalArgumentException("The persistable object cannot be null!");
        }
        if (persistable instanceof __Persistable) {
            return (__Persistable)persistable;
        }
        throw new IllegalArgumentException(persistable.getClass().getName() + " is not a valid persistable class. Check the weaver execution!");
    }

    public static void closeRecordStore(RecordStore recordStore) throws FloggyException {
        try {
            RecordStoreReference recordStoreReference;
            if (recordStore != null && (recordStoreReference = (RecordStoreReference)references.get(recordStore.getName())) != null) {
                --recordStoreReference.references;
                if (recordStoreReference.references == 0) {
                    recordStore.closeRecordStore();
                    recordStoreReference.recordStore = null;
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
            throw PersistableManagerImpl.handleException((Exception)((Object)recordStoreException));
        }
    }

    public static __Persistable createInstance(Class clazz) throws FloggyException {
        PersistableManagerImpl.validatePersistableClassArgument(clazz);
        try {
            return (__Persistable)clazz.newInstance();
        }
        catch (Exception exception) {
            throw PersistableManagerImpl.handleException(exception);
        }
    }

    private static RecordStore getRecordStore(__Persistable __Persistable2) throws FloggyException {
        PersistableMetadata persistableMetadata = MetadataManagerUtil.getClassBasedMetadata(__Persistable2.getClass().getName());
        return PersistableManagerImpl.getRecordStore(__Persistable2.getRecordStoreName(), persistableMetadata, false);
    }

    public static RecordStore getRecordStore(String string, PersistableMetadata persistableMetadata) throws FloggyException {
        return PersistableManagerImpl.getRecordStore(string, persistableMetadata, false);
    }

    public static void reset() {
        references.clear();
    }

    public static RecordStore getRecordStore(String string, PersistableMetadata persistableMetadata, boolean bl) throws FloggyException {
        try {
            RecordStoreReference recordStoreReference = (RecordStoreReference)references.get(string);
            if (recordStoreReference == null) {
                recordStoreReference = new RecordStoreReference();
                recordStoreReference.recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                PersistableMetadata persistableMetadata2 = MetadataManagerUtil.getRMSBasedMetadata(persistableMetadata.getClassName());
                if (persistableMetadata2 == null) {
                    if (!MetadataManagerUtil.getBytecodeVersion().equals(MetadataManagerUtil.getRMSVersion()) && !bl) {
                        throw new FloggyException("You are trying to access a Persistable (" + persistableMetadata.getClassName() + ") entity that was not migrate. Please execute a migration first.");
                    }
                    MetadataManagerUtil.saveRMSStructure(persistableMetadata);
                } else if (!persistableMetadata.equals(persistableMetadata2) && !bl) {
                    throw new FloggyException("Class and RMS description doesn't match for class " + persistableMetadata.getClassName() + ". Please execute a migration first.");
                }
                references.put(string, recordStoreReference);
            } else if (recordStoreReference.references == 0) {
                recordStoreReference.recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            }
            ++recordStoreReference.references;
            return recordStoreReference.recordStore;
        }
        catch (Exception exception) {
            throw PersistableManagerImpl.handleException(exception);
        }
    }

    public static void validatePersistableClassArgument(Class clazz) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("The persistable class cannot be null!");
        }
        if (!__persistableClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a valid persistable class. Check the weaver execution!");
        }
    }

    public PersistableManagerImpl() throws Exception {
        SerializationHelper.setPersistableManager(this);
        MetadataManagerUtil.init();
    }

    public void delete(Persistable persistable) throws FloggyException {
        __Persistable __Persistable2 = PersistableManagerImpl.checkArgumentAndCast(persistable);
        int n = __Persistable2.__getId();
        if (n > 0) {
            RecordStore recordStore = PersistableManagerImpl.getRecordStore(__Persistable2);
            try {
                __Persistable2.__delete();
                recordStore.deleteRecord(n);
                __Persistable2.__setId(0);
            }
            catch (RecordStoreException recordStoreException) {
                throw PersistableManagerImpl.handleException((Exception)((Object)recordStoreException));
            }
            finally {
                PersistableManagerImpl.closeRecordStore(recordStore);
            }
        }
    }

    public void deleteAll() throws FloggyException {
        try {
            String[] stringArray = RecordStore.listRecordStores();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("FloggyProperties")) continue;
                RecordStore.deleteRecordStore((String)stringArray[i]);
            }
        }
        catch (Exception exception) {
            throw PersistableManagerImpl.handleException(exception);
        }
    }

    public void deleteAll(Class clazz) throws FloggyException {
        __Persistable __Persistable2 = PersistableManagerImpl.createInstance(clazz);
        PersistableManagerImpl.closeRecordStore(PersistableManagerImpl.getRecordStore(__Persistable2));
        PersistableMetadata persistableMetadata = MetadataManagerUtil.getClassBasedMetadata(clazz.getName());
        if (deletableClass.isAssignableFrom(clazz) || persistableMetadata.getSuperClassName() != null) {
            ObjectSet objectSet = this.find(clazz, null, null);
            for (int i = 0; i < objectSet.size(); ++i) {
                objectSet.get(i, (Persistable)__Persistable2);
                this.delete(__Persistable2);
            }
        } else {
            try {
                RecordStore.deleteRecordStore((String)__Persistable2.getRecordStoreName());
            }
            catch (Exception exception) {
                throw PersistableManagerImpl.handleException(exception);
            }
        }
    }

    public int getId(Persistable persistable) {
        __Persistable __Persistable2 = PersistableManagerImpl.checkArgumentAndCast(persistable);
        return __Persistable2.__getId();
    }

    public ObjectSet find(Class clazz, Filter filter, Comparator comparator) throws FloggyException {
        return this.find(clazz, filter, comparator, false);
    }

    public ObjectSet find(Class clazz, Filter filter, Comparator comparator, boolean bl) throws FloggyException {
        ObjectFilter objectFilter = null;
        ObjectComparator objectComparator = null;
        __Persistable __Persistable2 = PersistableManagerImpl.createInstance(clazz);
        if (filter != null) {
            objectFilter = new ObjectFilter(__Persistable2, filter, bl);
        }
        if (comparator != null) {
            objectComparator = new ObjectComparator(comparator, PersistableManagerImpl.createInstance(clazz), PersistableManagerImpl.createInstance(clazz), bl);
        }
        int[] nArray = null;
        RecordStore recordStore = PersistableManagerImpl.getRecordStore(__Persistable2);
        try {
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords((RecordFilter)objectFilter, (RecordComparator)objectComparator, false);
            int n = recordEnumeration.numRecords();
            if (n > 0) {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = recordEnumeration.nextRecordId();
                }
            }
            recordEnumeration.destroy();
        }
        catch (RecordStoreException recordStoreException) {
            throw PersistableManagerImpl.handleException((Exception)((Object)recordStoreException));
        }
        finally {
            PersistableManagerImpl.closeRecordStore(recordStore);
        }
        return new ObjectSetImpl(nArray, clazz, this, bl);
    }

    public boolean isPersisted(Persistable persistable) {
        __Persistable __Persistable2 = PersistableManagerImpl.checkArgumentAndCast(persistable);
        return __Persistable2.__getId() > 0;
    }

    public static FloggyException handleException(Exception exception) {
        if (exception instanceof FloggyException) {
            return (FloggyException)exception;
        }
        String string = exception.getMessage();
        if (string == null) {
            string = exception.getClass().getName();
        }
        return new FloggyException(string, (Throwable)exception);
    }

    public void load(Persistable persistable, int n) throws FloggyException {
        this.load(persistable, n, false);
    }

    public void load(Persistable persistable, int n, boolean bl) throws FloggyException {
        __Persistable __Persistable2 = PersistableManagerImpl.checkArgumentAndCast(persistable);
        RecordStore recordStore = PersistableManagerImpl.getRecordStore(__Persistable2);
        try {
            byte[] byArray = recordStore.getRecord(n);
            if (byArray != null) {
                __Persistable2.__deserialize(byArray, bl);
            }
            __Persistable2.__setId(n);
        }
        catch (Exception exception) {
            throw PersistableManagerImpl.handleException(exception);
        }
        finally {
            PersistableManagerImpl.closeRecordStore(recordStore);
        }
    }

    public int save(Persistable persistable) throws FloggyException {
        __Persistable __Persistable2 = PersistableManagerImpl.checkArgumentAndCast(persistable);
        RecordStore recordStore = PersistableManagerImpl.getRecordStore(__Persistable2);
        try {
            byte[] byArray = __Persistable2.__serialize();
            int n = __Persistable2.__getId();
            if (n <= 0) {
                n = recordStore.addRecord(byArray, 0, byArray.length);
                __Persistable2.__setId(n);
            } else {
                recordStore.setRecord(n, byArray, 0, byArray.length);
            }
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw PersistableManagerImpl.handleException(exception);
        }
        finally {
            PersistableManagerImpl.closeRecordStore(recordStore);
        }
    }

    static {
        references = new Hashtable();
        try {
            __persistableClass = Class.forName("net.sourceforge.floggy.persistence.impl.__Persistable");
            deletableClass = Class.forName("net.sourceforge.floggy.persistence.Deletable");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private static class RecordStoreReference {
        RecordStore recordStore;
        int references = 0;

        private RecordStoreReference() {
        }
    }
}

