/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.impl.MetadataManagerUtil;
import net.sourceforge.floggy.persistence.impl.PersistableManagerImpl;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.SerializationHelper;
import net.sourceforge.floggy.persistence.impl.__Persistable;
import net.sourceforge.floggy.persistence.impl.migration.HashtableValueNullable;
import net.sourceforge.floggy.persistence.migration.Enumeration;
import net.sourceforge.floggy.persistence.migration.FieldPersistableInfo;

public class EnumerationImpl
implements Enumeration {
    protected PersistableMetadata classBasedMetadata;
    protected RecordEnumeration enumeration;
    protected PersistableManager manager = PersistableManager.getInstance();
    protected RecordStore recordStore;
    protected PersistableMetadata rmsBasedMetadata;
    protected boolean lazy;
    protected boolean iterationMode;
    protected Hashtable superClassesIDs = new Hashtable();
    protected int recordId = -1;

    EnumerationImpl(PersistableMetadata persistableMetadata, PersistableMetadata persistableMetadata2, RecordEnumeration recordEnumeration, RecordStore recordStore, boolean bl, boolean bl2) {
        this.rmsBasedMetadata = persistableMetadata;
        this.classBasedMetadata = persistableMetadata2;
        this.enumeration = recordEnumeration;
        this.recordStore = recordStore;
        this.lazy = bl;
        this.iterationMode = bl2;
    }

    protected void buildPersistable(PersistableMetadata persistableMetadata, byte[] byArray, Hashtable hashtable) throws Exception {
        String[] stringArray = persistableMetadata.getFieldNames();
        int[] nArray = persistableMetadata.getFieldTypes();
        if (byArray != null) {
            Object object;
            int n;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            String string = persistableMetadata.getSuperClassName();
            if (string != null) {
                n = dataInputStream.readInt();
                PersistableMetadata persistableMetadata2 = MetadataManagerUtil.getRMSBasedMetadata(string);
                if (persistableMetadata2 == null) {
                    persistableMetadata2 = MetadataManagerUtil.getClassBasedMetadata(string);
                }
                object = PersistableManagerImpl.getRecordStore(persistableMetadata2.getRecordStoreName(), persistableMetadata2);
                byte[] byArray2 = object.getRecord(n);
                this.buildPersistable(persistableMetadata2, byArray2, hashtable);
                this.superClassesIDs.put(string, new Integer(n));
            }
            for (n = 0; n < stringArray.length; ++n) {
                int n2 = nArray[n];
                if (this.lazy) {
                    if ((n2 & 0x400) == 1024) continue;
                    object = (n2 & 0x20000) == 131072 ? this.readArray(n2 &= 0xFFFDFFFF, stringArray[n], dataInputStream) : ((n2 & 0x40000) == 262144 ? this.readPrimitive(n2 &= 0xFFFBFFFF, dataInputStream) : this.readObject(n2, stringArray[n], dataInputStream));
                    hashtable.put(stringArray[n], object);
                    continue;
                }
                object = (n2 & 0x20000) == 131072 ? this.readArray(n2 &= 0xFFFDFFFF, stringArray[n], dataInputStream) : ((n2 & 0x40000) == 262144 ? this.readPrimitive(n2 &= 0xFFFBFFFF, dataInputStream) : this.readObject(n2, stringArray[n], dataInputStream));
                hashtable.put(stringArray[n], object);
            }
        }
    }

    protected Object[] createArray(int n, int n2) throws FloggyException {
        switch (n) {
            case 1: {
                return new Boolean[n2];
            }
            case 2: {
                return new Byte[n2];
            }
            case 4: {
                return new Calendar[n2];
            }
            case 8: {
                return new Character[n2];
            }
            case 16: {
                return new Date[n2];
            }
            case 32: {
                return new Double[n2];
            }
            case 64: {
                return new Float[n2];
            }
            case 128: {
                return new Hashtable[n2];
            }
            case 256: {
                return new Integer[n2];
            }
            case 512: {
                return new Long[n2];
            }
            case 1024: {
                return new FieldPersistableInfo[n2];
            }
            case 2048: {
                return new Short[n2];
            }
            case 4096: {
                return new Stack[n2];
            }
            case 8192: {
                return new String[n2];
            }
            case 16384: {
                return new StringBuffer[n2];
            }
            case 32768: {
                return new TimeZone[n2];
            }
            case 65536: {
                return new Vector[n2];
            }
        }
        throw new FloggyException("Type Unknow: " + n);
    }

    public int delete() throws FloggyException {
        if (this.recordId != -1) {
            try {
                this.deleteSuperClassesRegisters();
                this.recordStore.deleteRecord(this.recordId);
                int n = this.recordId;
                this.recordId = -1;
                return n;
            }
            catch (RecordStoreException recordStoreException) {
                throw PersistableManagerImpl.handleException((Exception)((Object)recordStoreException));
            }
        }
        throw new FloggyException("There isn't a register to delete. You have to iterate over the enumeration before call delete.");
    }

    protected void deleteSuperClassesRegisters() throws FloggyException, RecordStoreException {
        if (!this.superClassesIDs.isEmpty()) {
            java.util.Enumeration enumeration = this.superClassesIDs.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                PersistableMetadata persistableMetadata = MetadataManagerUtil.getRMSBasedMetadata(string);
                if (persistableMetadata == null) continue;
                RecordStore recordStore = PersistableManagerImpl.getRecordStore(persistableMetadata.getRecordStoreName(), persistableMetadata);
                recordStore.deleteRecord(((Integer)this.superClassesIDs.get(string)).intValue());
            }
        }
    }

    void finish() throws FloggyException {
        if (!this.enumeration.hasNextElement()) {
            this.enumeration.destroy();
            PersistableManagerImpl.closeRecordStore(this.recordStore);
            if (this.rmsBasedMetadata != this.classBasedMetadata) {
                try {
                    this.classBasedMetadata.setRecordId(this.rmsBasedMetadata.getRecordId());
                    MetadataManagerUtil.saveRMSStructure(this.classBasedMetadata);
                }
                catch (Exception exception) {
                    throw PersistableManagerImpl.handleException(exception);
                }
            }
        } else {
            throw new FloggyException("The enumeration must be whole processed before finish the process!");
        }
    }

    public int getSize() {
        return this.enumeration.numRecords();
    }

    public boolean hasMoreElements() {
        return this.enumeration.hasNextElement();
    }

    public Hashtable nextElement() throws FloggyException {
        if (this.recordId != -1 && !this.iterationMode) {
            throw new FloggyException("You should delete or update the current register before step into the next one.");
        }
        this.superClassesIDs.clear();
        HashtableValueNullable hashtableValueNullable = new HashtableValueNullable();
        try {
            this.recordId = this.enumeration.nextRecordId();
            byte[] byArray = this.recordStore.getRecord(this.recordId);
            this.buildPersistable(this.rmsBasedMetadata, byArray, hashtableValueNullable);
        }
        catch (Exception exception) {
            throw PersistableManagerImpl.handleException(exception);
        }
        return hashtableValueNullable;
    }

    protected Object readArray(int n, String string, DataInputStream dataInputStream) throws Exception {
        Object[] objectArray = null;
        if (dataInputStream.readByte() == 0) {
            int n2 = dataInputStream.readInt();
            if ((n & 0x40000) == 262144) {
                switch (n &= 0xFFFBFFFF) {
                    case 1: {
                        objectArray = this.readBooleanArray(n2, dataInputStream);
                        break;
                    }
                    case 2: {
                        objectArray = this.readByteArray(n2, dataInputStream);
                        break;
                    }
                    case 8: {
                        objectArray = this.readCharArray(n2, dataInputStream);
                        break;
                    }
                    case 32: {
                        objectArray = this.readDoubleArray(n2, dataInputStream);
                        break;
                    }
                    case 64: {
                        objectArray = this.readFloatArray(n2, dataInputStream);
                        break;
                    }
                    case 256: {
                        objectArray = this.readIntArray(n2, dataInputStream);
                        break;
                    }
                    case 512: {
                        objectArray = this.readLongArray(n2, dataInputStream);
                        break;
                    }
                    case 2048: {
                        objectArray = this.readShortArray(n2, dataInputStream);
                    }
                }
            } else {
                Object[] objectArray2 = this.createArray(n, n2);
                for (int i = 0; i < n2; ++i) {
                    objectArray2[i] = this.readObject(n, string, dataInputStream);
                }
                objectArray = objectArray2;
            }
        }
        return objectArray;
    }

    protected boolean[] readBooleanArray(int n, DataInputStream dataInputStream) throws Exception {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = dataInputStream.readBoolean();
        }
        return blArray;
    }

    protected byte[] readByteArray(int n, DataInputStream dataInputStream) throws Exception {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = dataInputStream.readByte();
        }
        return byArray;
    }

    protected char[] readCharArray(int n, DataInputStream dataInputStream) throws Exception {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        return cArray;
    }

    protected double[] readDoubleArray(int n, DataInputStream dataInputStream) throws Exception {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dataInputStream.readDouble();
        }
        return dArray;
    }

    protected float[] readFloatArray(int n, DataInputStream dataInputStream) throws Exception {
        float[] fArray = new float[n];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = dataInputStream.readFloat();
        }
        return fArray;
    }

    protected int[] readIntArray(int n, DataInputStream dataInputStream) throws Exception {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    protected long[] readLongArray(int n, DataInputStream dataInputStream) throws Exception {
        long[] lArray = new long[n];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = dataInputStream.readLong();
        }
        return lArray;
    }

    protected Object readObject(int n, String string, DataInputStream dataInputStream) throws Exception {
        switch (n) {
            case 1: {
                return SerializationHelper.readBoolean(dataInputStream);
            }
            case 2: {
                return SerializationHelper.readByte(dataInputStream);
            }
            case 4: {
                return SerializationHelper.readCalendar(dataInputStream);
            }
            case 8: {
                return SerializationHelper.readChar(dataInputStream);
            }
            case 16: {
                return SerializationHelper.readDate(dataInputStream);
            }
            case 32: {
                return SerializationHelper.readDouble(dataInputStream);
            }
            case 64: {
                return SerializationHelper.readFloat(dataInputStream);
            }
            case 128: {
                return SerializationHelper.readHashtable(dataInputStream);
            }
            case 256: {
                return SerializationHelper.readInt(dataInputStream);
            }
            case 512: {
                return SerializationHelper.readLong(dataInputStream);
            }
            case 1024: {
                FieldPersistableInfo fieldPersistableInfo = null;
                String string2 = this.rmsBasedMetadata.getPersistableImplementationClassForField(string);
                switch (dataInputStream.readByte()) {
                    case -1: {
                        string2 = dataInputStream.readUTF();
                    }
                    case 0: {
                        int n2 = dataInputStream.readInt();
                        fieldPersistableInfo = new FieldPersistableInfo(n2, string2);
                    }
                }
                return fieldPersistableInfo;
            }
            case 2048: {
                return SerializationHelper.readShort(dataInputStream);
            }
            case 4096: {
                return SerializationHelper.readStack(dataInputStream, this.lazy);
            }
            case 8192: {
                return SerializationHelper.readString(dataInputStream);
            }
            case 16384: {
                return SerializationHelper.readStringBuffer(dataInputStream);
            }
            case 32768: {
                return SerializationHelper.readTimeZone(dataInputStream);
            }
            case 65536: {
                return SerializationHelper.readVector(dataInputStream, this.lazy);
            }
        }
        throw new FloggyException("Type Unknow: " + n);
    }

    protected Object readPrimitive(int n, DataInputStream dataInputStream) throws Exception {
        switch (n) {
            case 1: {
                return dataInputStream.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return new Byte(dataInputStream.readByte());
            }
            case 8: {
                return new Character(dataInputStream.readChar());
            }
            case 32: {
                return new Double(dataInputStream.readDouble());
            }
            case 64: {
                return new Float(dataInputStream.readFloat());
            }
            case 256: {
                return new Integer(dataInputStream.readInt());
            }
            case 512: {
                return new Long(dataInputStream.readLong());
            }
            case 2048: {
                return new Short(dataInputStream.readShort());
            }
        }
        throw new FloggyException("Type Unknow: " + n);
    }

    protected short[] readShortArray(int n, DataInputStream dataInputStream) throws Exception {
        short[] sArray = new short[n];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        return sArray;
    }

    public int update(Persistable persistable) throws FloggyException {
        if (this.recordId != -1) {
            __Persistable __Persistable2 = PersistableManagerImpl.checkArgumentAndCast(persistable);
            try {
                __Persistable2.__setId(this.recordId);
                this.deleteSuperClassesRegisters();
                int n = this.manager.save((Persistable)__Persistable2);
                this.recordId = -1;
                return n;
            }
            catch (RecordStoreException recordStoreException) {
                throw PersistableManagerImpl.handleException((Exception)((Object)recordStoreException));
            }
        }
        throw new FloggyException("There isn't a register to update. You have to iterate over the enumeration before call update.");
    }
}

