/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.impl.MetadataManagerUtil;
import net.sourceforge.floggy.persistence.impl.PersistableManagerImpl;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.__Persistable;
import net.sourceforge.floggy.persistence.impl.migration.EnumerationImpl;
import net.sourceforge.floggy.persistence.migration.MigrationManager;

public class MigrationManagerImpl
extends MigrationManager {
    protected Hashtable enumerations = new Hashtable();

    public MigrationManagerImpl() throws Exception {
        PersistableManager.getInstance();
    }

    public void finish(Class clazz) throws FloggyException {
        PersistableManagerImpl.validatePersistableClassArgument(clazz);
        EnumerationImpl enumerationImpl = (EnumerationImpl)this.enumerations.get(clazz);
        if (enumerationImpl != null) {
            enumerationImpl.finish();
        }
    }

    public String[] getNotMigratedClasses() {
        Vector vector = MetadataManagerUtil.getNotMigratedClasses();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void quickMigration(Class clazz) throws FloggyException {
        PersistableManagerImpl.validatePersistableClassArgument(clazz);
        String string = clazz.getName();
        PersistableMetadata persistableMetadata = MetadataManagerUtil.getClassBasedMetadata(string);
        PersistableMetadata persistableMetadata2 = MetadataManagerUtil.getRMSBasedMetadata(string);
        if (persistableMetadata2 != null) {
            if (!persistableMetadata.equals(persistableMetadata2)) {
                throw new FloggyException("Class and RMS description doesn't match for class " + string + ". Please execute a normal migration process.");
            }
        } else {
            try {
                MetadataManagerUtil.saveRMSStructure(persistableMetadata);
            }
            catch (Exception exception) {
                throw PersistableManagerImpl.handleException(exception);
            }
        }
    }

    public net.sourceforge.floggy.persistence.migration.Enumeration start(Class clazz, Hashtable hashtable) throws FloggyException {
        __Persistable __Persistable2;
        PersistableManagerImpl.validatePersistableClassArgument(clazz);
        PersistableMetadata persistableMetadata = MetadataManagerUtil.getClassBasedMetadata(clazz.getName());
        if (persistableMetadata.isAbstract()) {
            throw new FloggyException("It is not possible migrate abstract classes. Instead migrate its subclasses");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (hashtable != null) {
            __Persistable2 = hashtable.get("LAZY_LOAD");
            if (__Persistable2 instanceof Boolean) {
                bl = (Boolean)((Object)__Persistable2);
            }
            if ((__Persistable2 = hashtable.get("MIGRATE_FROM_PREVIOUS_1_3_0_VERSION")) instanceof Boolean) {
                bl2 = (Boolean)((Object)__Persistable2);
            }
            if ((__Persistable2 = hashtable.get("ITERATION_MODE")) instanceof Boolean) {
                bl3 = (Boolean)((Object)__Persistable2);
            }
        }
        __Persistable2 = PersistableManagerImpl.createInstance(clazz);
        RecordStore recordStore = null;
        EnumerationImpl enumerationImpl = null;
        PersistableMetadata persistableMetadata2 = null;
        try {
            persistableMetadata2 = MetadataManagerUtil.getRMSBasedMetadata(clazz.getName());
            recordStore = PersistableManagerImpl.getRecordStore(__Persistable2.getRecordStoreName(), persistableMetadata, true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (persistableMetadata2 == null) {
                if (bl2) {
                    persistableMetadata2 = persistableMetadata;
                } else {
                    throw new FloggyException("Set the property MigrationManager.MIGRATE_FROM_PREVIOUS_1_3_0_VERSION to true to migrate from a version lower than 1.3.0.");
                }
            }
            Hashtable hashtable2 = persistableMetadata2.getPersistableImplementations();
            if (!bl && hashtable2 != null) {
                Enumeration enumeration = hashtable2.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string.endsWith("[]")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    PersistableMetadata persistableMetadata3 = MetadataManagerUtil.getClassBasedMetadata(string);
                    PersistableMetadata persistableMetadata4 = MetadataManagerUtil.getRMSBasedMetadata(string);
                    if (persistableMetadata3 == null || persistableMetadata4 == null || persistableMetadata3.equals(persistableMetadata4)) continue;
                    throw new FloggyException("You first must migrate the class " + string + " than you can migrate " + clazz.getName());
                }
            }
            enumerationImpl = new EnumerationImpl(persistableMetadata2, persistableMetadata, recordEnumeration, recordStore, bl, bl3);
            this.enumerations.put(clazz, enumerationImpl);
        }
        catch (Exception exception) {
            throw PersistableManagerImpl.handleException(exception);
        }
        return enumerationImpl;
    }
}

