/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Vector;
import net.sourceforge.floggy.persistence.impl.FloggyOutputStream;
import net.sourceforge.floggy.persistence.impl.SerializationManager;

public class IndexEntry {
    protected Object value;
    protected Vector persistableIds = new Vector();
    protected int recordId = -1;

    public IndexEntry(int n) {
        this(n, null);
    }

    public IndexEntry(int n, Object object) {
        this.recordId = n;
        this.value = object;
    }

    public IndexEntry(Object object) {
        this(-1, object);
    }

    public void deserialize(byte[] byArray) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        this.setValue(SerializationManager.readObject(dataInputStream, false));
        this.persistableIds = SerializationManager.readIntVector(dataInputStream);
        dataInputStream.close();
    }

    public Vector getPersistableIds() {
        return this.persistableIds;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public Object getValue() {
        return this.value;
    }

    public void serialize(FloggyOutputStream floggyOutputStream) throws Exception {
        SerializationManager.writeObject(floggyOutputStream, this.getValue());
        SerializationManager.writeIntVector(floggyOutputStream, this.getPersistableIds());
    }

    public void setRecordId(int n) {
        this.recordId = n;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public String toString() {
        return "IndexEntry [recordId=" + this.recordId + ", persistableIds=" + this.persistableIds + ", value=" + this.value + "]";
    }
}

