/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.impl.FloggyOutputStream;
import net.sourceforge.floggy.persistence.impl.Index;
import net.sourceforge.floggy.persistence.impl.IndexEntry;
import net.sourceforge.floggy.persistence.impl.IndexMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.__Persistable;

public class IndexManager {
    private static Hashtable indexes = new Hashtable();
    private static boolean storeIndexAfterSave = false;

    private IndexManager() {
    }

    public static void afterDelete(__Persistable __Persistable2) throws Exception {
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(__Persistable2.getClass().getName());
        Vector vector = persistableMetadata.getIndexMetadatas();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                IndexMetadata indexMetadata = (IndexMetadata)vector.elementAt(i);
                IndexManager.afterDelete(__Persistable2, indexMetadata);
            }
        }
    }

    public static void afterDelete(__Persistable __Persistable2, IndexMetadata indexMetadata) throws Exception {
        if (__Persistable2.__getId() > 0) {
            Index index;
            IndexEntry indexEntry;
            Object object;
            if (indexes.containsKey(indexMetadata.getId()) && (object = __Persistable2.__getIndexValue(indexMetadata.getName())) != null && (indexEntry = (index = (Index)indexes.get(indexMetadata.getId())).getIndexEntry(object)) != null) {
                index.remove(__Persistable2.__getId());
            }
        } else {
            throw new IllegalArgumentException("The persistable object does not have a reference to the RMS system.");
        }
    }

    public static void afterSave(__Persistable __Persistable2) throws Exception {
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(__Persistable2.getClass().getName());
        Vector vector = persistableMetadata.getIndexMetadatas();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                IndexMetadata indexMetadata = (IndexMetadata)vector.elementAt(i);
                IndexManager.afterSave(__Persistable2, indexMetadata);
            }
        }
    }

    public static void afterSave(__Persistable __Persistable2, IndexMetadata indexMetadata) throws Exception {
        if (__Persistable2.__getId() > 0) {
            Index index = null;
            Object object = __Persistable2.__getIndexValue(indexMetadata.getName());
            String string = indexMetadata.getId();
            if (indexes.containsKey(string)) {
                index = (Index)indexes.get(string);
            } else {
                index = new Index();
                indexes.put(string, index);
            }
            if (object == null) {
                IndexEntry indexEntry = index.getIndexEntry(__Persistable2.__getId());
                if (indexEntry != null) {
                    index.remove(__Persistable2.__getId());
                }
            } else {
                index.put(__Persistable2.__getId(), object);
            }
            if (storeIndexAfterSave) {
                IndexManager.save(string, index);
            }
        } else {
            throw new IllegalArgumentException("The persistable object does not have a reference to the RMS system.");
        }
    }

    public static void deleteIndex(String string) throws Exception {
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(string);
        Vector vector = persistableMetadata.getIndexMetadatas();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                IndexMetadata indexMetadata = (IndexMetadata)vector.elementAt(i);
                String string2 = indexMetadata.getId();
                if (indexes.containsKey(string2)) {
                    Index index = (Index)indexes.get(string2);
                    index.clear();
                }
                RecordStoreManager.deleteRecordStore(string2);
            }
        }
    }

    public static int[] getId(Class clazz, String string, Object object) throws Exception {
        IndexMetadata indexMetadata = IndexManager.getIndexMetadata(clazz, string);
        Index index = (Index)indexes.get(indexMetadata.getId());
        return index.getIds(object);
    }

    public static IndexMetadata getIndexMetadata(Class clazz, String string) throws FloggyException {
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(clazz.getName());
        Vector vector = persistableMetadata.getIndexMetadatas();
        int n = vector.size();
        IndexMetadata indexMetadata = null;
        for (int i = 0; i < n; ++i) {
            indexMetadata = (IndexMetadata)vector.elementAt(i);
            if (!indexMetadata.getName().equals(string)) continue;
            return indexMetadata;
        }
        throw new FloggyException("The " + string + " index does not exist to " + clazz.getName() + " persistable.");
    }

    public static boolean getStoreIndexAfterSave() {
        return storeIndexAfterSave;
    }

    public static void init() throws Exception {
        Enumeration enumeration = PersistableMetadataManager.getClassBasedMetadatas();
        while (enumeration.hasMoreElements()) {
            PersistableMetadata persistableMetadata = (PersistableMetadata)enumeration.nextElement();
            Vector vector = persistableMetadata.getIndexMetadatas();
            if (vector == null) continue;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                IndexMetadata indexMetadata = (IndexMetadata)vector.elementAt(i);
                IndexManager.loadIndex(persistableMetadata, indexMetadata);
            }
        }
    }

    public static void loadIndex(PersistableMetadata persistableMetadata, IndexMetadata indexMetadata) throws Exception {
        if (indexes.containsKey(indexMetadata.getId())) {
            return;
        }
        RecordStore recordStore = RecordStoreManager.getRecordStore(indexMetadata, persistableMetadata);
        Index index = new Index();
        RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
        while (recordEnumeration.hasNextElement()) {
            int n = recordEnumeration.nextRecordId();
            byte[] byArray = recordStore.getRecord(n);
            IndexEntry indexEntry = new IndexEntry(n);
            indexEntry.deserialize(byArray);
            index.put(indexEntry);
        }
        indexes.put(indexMetadata.getId(), index);
        RecordStoreManager.closeRecordStore(recordStore);
    }

    public static void reset() {
        Enumeration enumeration = indexes.elements();
        while (enumeration.hasMoreElements()) {
            Index index = (Index)enumeration.nextElement();
            index.idValue.clear();
            index.valueIds.clear();
        }
        indexes.clear();
    }

    public static void setStoreIndexAfterSave(boolean bl) {
        storeIndexAfterSave = bl;
    }

    public static void shutdown() throws Exception {
        Enumeration enumeration = indexes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Index index = (Index)indexes.get(string);
            IndexManager.save(string, index);
        }
    }

    private static void save(String string, Index index) throws Exception {
        FloggyOutputStream floggyOutputStream = new FloggyOutputStream();
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        Enumeration enumeration = index.valueIds.elements();
        while (enumeration.hasMoreElements()) {
            IndexEntry indexEntry = (IndexEntry)enumeration.nextElement();
            indexEntry.serialize(floggyOutputStream);
            int n = indexEntry.getRecordId();
            byte[] byArray = floggyOutputStream.toByteArray();
            if (n != -1) {
                recordStore.setRecord(n, byArray, 0, byArray.length);
            } else {
                n = recordStore.addRecord(byArray, 0, byArray.length);
                indexEntry.setRecordId(n);
            }
            floggyOutputStream.reset();
        }
        recordStore.closeRecordStore();
    }
}

