/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.util.Enumeration;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.Comparator;
import net.sourceforge.floggy.persistence.Filter;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.IndexFilter;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.PolymorphicObjectSet;
import net.sourceforge.floggy.persistence.SingleObjectSet;
import net.sourceforge.floggy.persistence.impl.IndexManager;
import net.sourceforge.floggy.persistence.impl.ObjectComparator;
import net.sourceforge.floggy.persistence.impl.ObjectSetImpl;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.PolymorphicObjectSetImpl;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.SerializationManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.__Persistable;
import net.sourceforge.floggy.persistence.impl.strategy.JoinedStrategyObjectFilter;
import net.sourceforge.floggy.persistence.impl.strategy.PerClassStrategyObjectFilter;
import net.sourceforge.floggy.persistence.impl.strategy.SingleStrategyObjectFilter;

public class PersistableManagerImpl
extends PersistableManager {
    protected Class deletableClass = Class.forName("net.sourceforge.floggy.persistence.Deletable");
    protected Class perClassStrategyClass = Class.forName("net.sourceforge.floggy.persistence.strategy.PerClassStrategy");
    protected Class singleStrategyClass = Class.forName("net.sourceforge.floggy.persistence.strategy.SingleStrategy");

    public PersistableManagerImpl() throws Exception {
        SerializationManager.setPersistableManager(this);
        PersistableMetadataManager.init();
        IndexManager.init();
    }

    public int batchSave(Persistable persistable) throws FloggyException {
        __Persistable __Persistable2 = Utils.checkArgumentAndCast(persistable);
        int n = __Persistable2.__getId();
        if (n > 0) {
            throw new FloggyException("You should not use this method to update the persistable object.");
        }
        n = this.save(persistable);
        __Persistable2.__setId(0);
        return n;
    }

    public void delete(Persistable persistable) throws FloggyException {
        __Persistable __Persistable2 = Utils.checkArgumentAndCast(persistable);
        int n = __Persistable2.__getId();
        if (n > 0) {
            RecordStore recordStore = RecordStoreManager.getRecordStore(__Persistable2);
            try {
                __Persistable2.__delete();
                recordStore.deleteRecord(n);
                IndexManager.afterDelete(__Persistable2);
                __Persistable2.__setId(0);
            }
            catch (Exception exception) {
                throw Utils.handleException(exception);
            }
            finally {
                RecordStoreManager.closeRecordStore(recordStore);
            }
        }
    }

    public void deleteAll() throws FloggyException {
        try {
            Enumeration enumeration = PersistableMetadataManager.getClassBasedMetadatas();
            while (enumeration.hasMoreElements()) {
                PersistableMetadata persistableMetadata = (PersistableMetadata)enumeration.nextElement();
                IndexManager.deleteIndex(persistableMetadata.getClassName());
                RecordStoreManager.deleteRecordStore(persistableMetadata.getRecordStoreName());
            }
        }
        catch (Exception exception) {
            throw Utils.handleException(exception);
        }
    }

    public void deleteAll(Class clazz) throws FloggyException {
        __Persistable __Persistable2 = Utils.createInstance(clazz);
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(clazz.getName());
        if (this.deletableClass.isAssignableFrom(clazz) || persistableMetadata.getSuperClassName() != null) {
            SingleObjectSet singleObjectSet = this.find(clazz, null, null);
            for (int i = 0; i < singleObjectSet.size(); ++i) {
                __Persistable2 = (__Persistable)singleObjectSet.get(i);
                this.delete(__Persistable2);
            }
        } else {
            try {
                RecordStoreManager.deleteRecordStore(__Persistable2.getRecordStoreName());
                IndexManager.deleteIndex(clazz.getName());
            }
            catch (Exception exception) {
                throw Utils.handleException(exception);
            }
        }
    }

    public SingleObjectSet find(Class clazz, Filter filter, Comparator comparator) throws FloggyException {
        return this.find(clazz, filter, comparator, false);
    }

    public SingleObjectSet find(Class clazz, Filter filter, Comparator comparator, boolean bl) throws FloggyException {
        RecordFilter recordFilter = null;
        ObjectComparator objectComparator = null;
        __Persistable __Persistable2 = Utils.createInstance(clazz);
        recordFilter = this.getFilter(__Persistable2, filter, bl);
        if (comparator != null) {
            objectComparator = new ObjectComparator(comparator, Utils.createInstance(clazz), Utils.createInstance(clazz), bl);
        }
        int[] nArray = null;
        RecordStore recordStore = RecordStoreManager.getRecordStore(__Persistable2);
        try {
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(recordFilter, (RecordComparator)objectComparator, false);
            int n = recordEnumeration.numRecords();
            if (n > 0) {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = recordEnumeration.nextRecordId();
                }
            }
            recordEnumeration.destroy();
        }
        catch (RecordStoreException recordStoreException) {
            throw Utils.handleException((Exception)((Object)recordStoreException));
        }
        finally {
            RecordStoreManager.closeRecordStore(recordStore);
        }
        return new ObjectSetImpl(nArray, clazz, this, bl);
    }

    public SingleObjectSet find(Class clazz, IndexFilter indexFilter, boolean bl) throws FloggyException {
        if (indexFilter == null) {
            throw new IllegalArgumentException("The indexFilter cannot be null");
        }
        Utils.validatePersistableClassArgument(clazz);
        try {
            int[] nArray = IndexManager.getId(clazz, indexFilter.getIndexName(), indexFilter.getIndexValue());
            return new ObjectSetImpl(nArray, clazz, this, bl);
        }
        catch (Exception exception) {
            throw Utils.handleException(exception);
        }
    }

    public int getId(Persistable persistable) {
        __Persistable __Persistable2 = Utils.checkArgumentAndCast(persistable);
        return __Persistable2.__getId();
    }

    public Object getProperty(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("The property name cannot be null or empty");
        }
        if (string.equals("BATCH_MODE")) {
            return RecordStoreManager.getBatchMode() ? Utils.TRUE : Utils.FALSE;
        }
        if (string.equals("STORE_INDEX_AFTER_SAVE_OPERATION")) {
            return IndexManager.getStoreIndexAfterSave() ? Utils.TRUE : Utils.FALSE;
        }
        throw new IllegalArgumentException("Unreconized property: " + string);
    }

    public boolean isPersisted(Persistable persistable) {
        __Persistable __Persistable2 = Utils.checkArgumentAndCast(persistable);
        return __Persistable2.__getId() > 0;
    }

    public void load(Persistable persistable, int n) throws FloggyException {
        this.load(persistable, n, false);
    }

    public void load(Persistable persistable, int n, boolean bl) throws FloggyException {
        __Persistable __Persistable2 = Utils.checkArgumentAndCast(persistable);
        RecordStore recordStore = RecordStoreManager.getRecordStore(__Persistable2);
        try {
            byte[] byArray = recordStore.getRecord(n);
            if (byArray != null) {
                __Persistable2.__deserialize(byArray, bl);
            }
            __Persistable2.__setId(n);
        }
        catch (Exception exception) {
            throw Utils.handleException(exception);
        }
        finally {
            RecordStoreManager.closeRecordStore(recordStore);
        }
    }

    public PolymorphicObjectSet polymorphicFind(Class clazz, Filter filter, boolean bl) throws FloggyException {
        RecordFilter recordFilter = null;
        __Persistable __Persistable2 = null;
        int[] nArray = null;
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(clazz.getName());
        PolymorphicObjectSetImpl polymorphicObjectSetImpl = new PolymorphicObjectSetImpl(this, bl);
        String[] stringArray = persistableMetadata.getDescendents();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{clazz.getName()};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                clazz = Class.forName(stringArray[i]);
                __Persistable2 = Utils.createInstance(clazz);
                recordFilter = this.getFilter(__Persistable2, filter, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw Utils.handleException(classNotFoundException);
            }
            RecordStore recordStore = RecordStoreManager.getRecordStore(__Persistable2);
            try {
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(recordFilter, null, false);
                int n = recordEnumeration.numRecords();
                if (n > 0) {
                    nArray = new int[n];
                    for (int j = 0; j < n; ++j) {
                        nArray[j] = recordEnumeration.nextRecordId();
                    }
                    polymorphicObjectSetImpl.addList(nArray, clazz);
                }
                recordEnumeration.destroy();
                continue;
            }
            catch (RecordStoreException recordStoreException) {
                throw Utils.handleException((Exception)((Object)recordStoreException));
            }
            finally {
                RecordStoreManager.closeRecordStore(recordStore);
            }
        }
        return polymorphicObjectSetImpl;
    }

    public int save(Persistable persistable) throws FloggyException {
        __Persistable __Persistable2 = Utils.checkArgumentAndCast(persistable);
        RecordStore recordStore = RecordStoreManager.getRecordStore(__Persistable2);
        try {
            byte[] byArray = __Persistable2.__serialize(true);
            int n = __Persistable2.__getId();
            if (n <= 0) {
                n = recordStore.addRecord(byArray, 0, byArray.length);
                __Persistable2.__setId(n);
            } else {
                recordStore.setRecord(n, byArray, 0, byArray.length);
            }
            IndexManager.afterSave(__Persistable2);
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            throw Utils.handleException(exception);
        }
        finally {
            RecordStoreManager.closeRecordStore(recordStore);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, Object object) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("The property name cannot be null or empty");
        }
        if (object == null) {
            throw new IllegalArgumentException("The property value cannot be null");
        }
        if (string.equals("BATCH_MODE")) {
            if (!(object instanceof Boolean)) throw new IllegalArgumentException("The property PersistableManager.BATCH_MODE must be an instance of Boolean");
            RecordStoreManager.setBatchMode((Boolean)object);
            return;
        } else {
            if (!string.equals("STORE_INDEX_AFTER_SAVE_OPERATION")) throw new IllegalArgumentException("Unreconized property: " + string);
            if (!(object instanceof Boolean)) throw new IllegalArgumentException("The property PersistableManager.STORE_INDEX_AFTER_SAVE_OPERATION must be an instance of Boolean");
            IndexManager.setStoreIndexAfterSave((Boolean)object);
        }
    }

    public void shutdown() throws FloggyException {
        try {
            IndexManager.shutdown();
            RecordStoreManager.shutdown();
        }
        catch (Exception exception) {
            throw Utils.handleException(exception);
        }
    }

    protected RecordFilter getFilter(__Persistable __Persistable2, Filter filter, boolean bl) {
        Class<?> clazz = __Persistable2.getClass();
        Object object = null;
        if (this.perClassStrategyClass.isAssignableFrom(clazz)) {
            if (filter != null) {
                object = new PerClassStrategyObjectFilter(__Persistable2, filter, bl);
            }
        } else {
            object = this.singleStrategyClass.isAssignableFrom(clazz) ? (filter != null ? new SingleStrategyObjectFilter(__Persistable2, filter, bl) : new SingleStrategyObjectFilter(__Persistable2, bl)) : (filter != null ? new JoinedStrategyObjectFilter(__Persistable2, filter, bl) : new JoinedStrategyObjectFilter(bl));
        }
        return object;
    }
}

