/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.Utils;

public class PersistableMetadata {
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int CALENDAR = 4;
    public static final int CHARACTER = 8;
    public static final int DATE = 16;
    public static final int DOUBLE = 32;
    public static final int FLOAT = 64;
    public static final int HASHTABLE = 128;
    public static final int INT = 256;
    public static final int LONG = 512;
    public static final int PERSISTABLE = 1024;
    public static final int SHORT = 2048;
    public static final int STACK = 4096;
    public static final int STRING = 8192;
    public static final int STRINGBUFFER = 16384;
    public static final int TIMEZONE = 32768;
    public static final int VECTOR = 65536;
    public static final int ARRAY = 131072;
    public static final int PRIMITIVE = 262144;
    public static final int JOINED_STRATEGY = 1;
    public static final int PER_CLASS_STRATEGY = 2;
    public static final int SINGLE_STRATEGY = 4;
    private Hashtable persistableImplementations;
    private String className;
    private String recordStoreName;
    private String recordStoreVersion;
    private String suiteName;
    private String superClassName;
    private String vendorName;
    private Vector indexMetadatas;
    private String[] fieldNames;
    private int[] fieldTypes;
    private boolean isAbstract;
    private transient int recordId = -1;
    private String[] descendents;
    private int persistableStrategy;

    public PersistableMetadata(boolean bl, String string, String string2, String[] stringArray, int[] nArray, Hashtable hashtable, Vector vector, String string3, int n, String[] stringArray2) {
        this(bl, string, string2, stringArray, nArray, hashtable, vector, string3, null, n, -1);
        this.descendents = stringArray2;
    }

    public PersistableMetadata(boolean bl, String string, String string2, String[] stringArray, int[] nArray, Hashtable hashtable, Vector vector, String string3, String string4, int n, int n2) {
        this.isAbstract = bl;
        this.className = string;
        this.superClassName = string2;
        this.fieldNames = stringArray;
        this.fieldTypes = nArray;
        this.persistableImplementations = hashtable;
        this.indexMetadatas = vector;
        this.recordStoreName = string3;
        this.recordStoreVersion = string4;
        this.persistableStrategy = n;
        this.recordId = n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PersistableMetadata persistableMetadata = (PersistableMetadata)object;
        if (this.className == null ? persistableMetadata.className != null : !this.className.equals(persistableMetadata.className)) {
            return false;
        }
        if (!Utils.equals(this.fieldNames, persistableMetadata.fieldNames)) {
            return false;
        }
        if (!Utils.equals(this.fieldTypes, persistableMetadata.fieldTypes)) {
            return false;
        }
        if (this.isAbstract != persistableMetadata.isAbstract) {
            return false;
        }
        if ("1.4.0".equals(PersistableMetadataManager.getRMSVersion()) && (this.indexMetadatas == null ? persistableMetadata.indexMetadatas != null : !Utils.equals(this.indexMetadatas, persistableMetadata.indexMetadatas))) {
            return false;
        }
        if (this.persistableImplementations == null ? persistableMetadata.persistableImplementations != null : !Utils.equals(this.persistableImplementations, persistableMetadata.persistableImplementations)) {
            return false;
        }
        if (this.persistableStrategy != persistableMetadata.persistableStrategy) {
            return false;
        }
        if (this.recordStoreName == null ? persistableMetadata.recordStoreName != null : !this.recordStoreName.equals(persistableMetadata.recordStoreName)) {
            return false;
        }
        return !(this.superClassName == null ? persistableMetadata.superClassName != null : !this.superClassName.equals(persistableMetadata.superClassName));
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getDescendents() {
        return this.descendents;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public int[] getFieldTypes() {
        return this.fieldTypes;
    }

    public Vector getIndexMetadatas() {
        return this.indexMetadatas;
    }

    public String getPersistableImplementationClassForField(String string) {
        return (String)this.persistableImplementations.get(string);
    }

    public Hashtable getPersistableImplementations() {
        return this.persistableImplementations;
    }

    public int getPersistableStrategy() {
        return this.persistableStrategy;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public String getRecordStoreName() {
        return this.recordStoreName;
    }

    public String getRecordStoreVersion() {
        return this.recordStoreVersion;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.className == null ? 0 : this.className.hashCode());
        n = 31 * n + Utils.hashCode(this.fieldNames);
        n = 31 * n + Utils.hashCode(this.fieldTypes);
        n = 31 * n + (this.isAbstract ? 1231 : 1237);
        n = 31 * n + (this.persistableImplementations == null ? 0 : ((Object)this.persistableImplementations).hashCode());
        if ("1.4.0".equals(PersistableMetadataManager.getRMSVersion())) {
            n = 31 * n + (this.indexMetadatas == null ? 0 : ((Object)this.indexMetadatas).hashCode());
        }
        n = 31 * n + this.persistableStrategy;
        n = 31 * n + (this.recordStoreName == null ? 0 : this.recordStoreName.hashCode());
        n = 31 * n + (this.superClassName == null ? 0 : this.superClassName.hashCode());
        return n;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setDescendents(String[] stringArray) {
        this.descendents = stringArray;
    }

    public void setIndexMetadatas(Vector vector) {
        this.indexMetadatas = vector;
    }

    public void setPersistableStrategy(int n) {
        this.persistableStrategy = n;
    }

    public void setRecordId(int n) {
        this.recordId = n;
    }

    public void setRecordStoreName(String string) {
        this.recordStoreName = string;
    }

    public void setRecordStoreVersion(String string) {
        this.recordStoreVersion = string;
    }

    public void setSuiteName(String string) {
        this.suiteName = string;
    }

    public void setVendorName(String string) {
        this.vendorName = string;
    }

    public String toString() {
        return "PersistableMetadata [isAbstract=" + this.isAbstract + ", className=" + this.className + ", superClassName=" + this.superClassName + ", fieldNames=" + (this.fieldNames != null ? this.arrayToString(this.fieldNames, this.fieldNames.length) : null) + ", fieldTypes=" + (this.fieldTypes != null ? this.arrayToString(this.fieldTypes, this.fieldTypes.length) : null) + ", persistableImplementations=" + this.persistableImplementations + ", indexMetadatas=" + this.indexMetadatas + ", recordStoreName=" + this.recordStoreName + ", persistableStrategy=" + this.persistableStrategy + "]";
    }

    private String arrayToString(Object object, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (object instanceof int[]) {
                stringBuffer.append(((int[])object)[i]);
            }
            if (!(object instanceof Object[])) continue;
            stringBuffer.append(((Object[])object)[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

