/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.impl.IndexMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.__Persistable;

public class RecordStoreManager {
    private static Hashtable references = new Hashtable();
    private static boolean batchMode = false;

    protected RecordStoreManager() {
    }

    public static void closeRecordStore(RecordStore recordStore) throws FloggyException {
        try {
            RecordStoreReference recordStoreReference;
            if (recordStore != null && (recordStoreReference = (RecordStoreReference)references.get(recordStore.getName())) != null) {
                --recordStoreReference.references;
                if (recordStoreReference.references == 0 && !batchMode) {
                    recordStore.closeRecordStore();
                    recordStoreReference.recordStore = null;
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
            throw Utils.handleException((Exception)((Object)recordStoreException));
        }
    }

    public static void deleteRecordStore(String string) throws Exception {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            // empty catch block
        }
    }

    public static boolean getBatchMode() {
        return batchMode;
    }

    public static RecordStore getRecordStore(__Persistable __Persistable2) throws FloggyException {
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(__Persistable2.getClass().getName());
        return RecordStoreManager.getRecordStore(__Persistable2.getRecordStoreName(), persistableMetadata, false);
    }

    public static RecordStore getRecordStore(IndexMetadata indexMetadata, PersistableMetadata persistableMetadata) throws Exception {
        return RecordStoreManager.getRecordStore(indexMetadata.getRecordStoreName(), persistableMetadata, false);
    }

    public static RecordStore getRecordStore(String string, PersistableMetadata persistableMetadata) throws FloggyException {
        return RecordStoreManager.getRecordStore(string, persistableMetadata, false);
    }

    public static RecordStore getRecordStore(String string, PersistableMetadata persistableMetadata, boolean bl) throws FloggyException {
        try {
            RecordStoreReference recordStoreReference = (RecordStoreReference)references.get(string);
            if (recordStoreReference == null) {
                RecordStoreManager.check(persistableMetadata, bl);
                recordStoreReference = new RecordStoreReference();
                String string2 = persistableMetadata.getSuiteName();
                String string3 = persistableMetadata.getVendorName();
                recordStoreReference.recordStore = string2 != null && string3 != null ? RecordStore.openRecordStore((String)string, (String)string3, (String)string2) : RecordStore.openRecordStore((String)string, (boolean)true);
                references.put(string, recordStoreReference);
            } else {
                if (persistableMetadata.getPersistableStrategy() == 4) {
                    RecordStoreManager.check(persistableMetadata, bl);
                }
                if (recordStoreReference.references == 0) {
                    String string4 = persistableMetadata.getSuiteName();
                    String string5 = persistableMetadata.getVendorName();
                    recordStoreReference.recordStore = string4 != null && string5 != null ? RecordStore.openRecordStore((String)string, (String)string5, (String)string4) : RecordStore.openRecordStore((String)string, (boolean)true);
                }
            }
            ++recordStoreReference.references;
            return recordStoreReference.recordStore;
        }
        catch (Exception exception) {
            throw Utils.handleException(exception);
        }
    }

    public static void init() {
    }

    public static void reset() {
        references.clear();
    }

    public static void setBatchMode(boolean bl) {
        batchMode = bl;
    }

    public static void shutdown() throws FloggyException {
        Enumeration enumeration = references.elements();
        while (enumeration.hasMoreElements()) {
            RecordStoreReference recordStoreReference = (RecordStoreReference)enumeration.nextElement();
            RecordStore recordStore = recordStoreReference.recordStore;
            if (recordStore == null) continue;
            try {
                recordStore.closeRecordStore();
                recordStoreReference.recordStore = null;
            }
            catch (Exception exception) {
                throw Utils.handleException(exception);
            }
        }
    }

    private static void check(PersistableMetadata persistableMetadata, boolean bl) throws Exception {
        PersistableMetadata persistableMetadata2 = PersistableMetadataManager.getRMSBasedMetadata(persistableMetadata.getClassName());
        if (persistableMetadata2 == null) {
            if (!PersistableMetadataManager.getBytecodeVersion().equals(PersistableMetadataManager.getRMSVersion()) && !bl) {
                throw new FloggyException("You are trying to access a Persistable (" + persistableMetadata.getClassName() + ") entity that was not migrate. Please execute a migration first.");
            }
            PersistableMetadataManager.saveRMSStructure(persistableMetadata);
        } else if (!persistableMetadata.equals(persistableMetadata2) && !bl) {
            throw new FloggyException("Class and RMS description doesn't match for class " + persistableMetadata.getClassName() + ". Please execute a migration first.");
        }
    }

    private static class RecordStoreReference {
        RecordStore recordStore;
        int references = 0;

        private RecordStoreReference() {
        }
    }
}

