/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.impl.__Persistable;

public class Utils {
    private static Class __persistableClass;
    public static final Boolean FALSE;
    public static final Boolean TRUE;

    public static __Persistable checkArgumentAndCast(Persistable persistable) {
        if (persistable == null) {
            throw new IllegalArgumentException("The persistable object cannot be null!");
        }
        if (persistable instanceof __Persistable) {
            return (__Persistable)persistable;
        }
        throw new IllegalArgumentException(persistable.getClass().getName() + " is not a valid persistable class. Check the weaver execution!");
    }

    public static __Persistable createInstance(Class clazz) throws FloggyException {
        Utils.validatePersistableClassArgument(clazz);
        try {
            return (__Persistable)clazz.newInstance();
        }
        catch (Exception exception) {
            throw Utils.handleException(exception);
        }
    }

    public static boolean equals(String[] stringArray, String[] stringArray2) {
        if (stringArray == stringArray2) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        int n = stringArray.length;
        if (stringArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            String string2 = stringArray2[i];
            if (string != null ? string.equals(string2) : string2 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Vector vector, Vector vector2) {
        if (vector == vector2) {
            return true;
        }
        if (vector == null || vector2 == null) {
            return false;
        }
        if (vector.size() != vector2.size()) {
            return false;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            Object e2 = vector2.elementAt(i);
            if (!(e == null ? e2 != null : !e.equals(e2))) continue;
            return false;
        }
        return true;
    }

    public static FloggyException handleException(Exception exception) {
        if (exception instanceof FloggyException) {
            return (FloggyException)exception;
        }
        String string = exception.getMessage();
        if (string == null) {
            string = exception.getClass().getName();
        }
        return new FloggyException(string, (Throwable)exception);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String readUTF8(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3 = byArray[0] & 0xFF;
        int n4 = byArray[1] & 0xFF;
        if ((n3 | n4) < 0) {
            throw new EOFException();
        }
        int n5 = (n3 << 8) + (n4 << 0) + 2;
        byte[] byArray2 = new byte[n5];
        char[] cArray = new char[n5];
        int n6 = 0;
        for (n2 = 2; n2 < n5 && (n = byArray[n2] & 0xFF) <= 127; ++n2) {
            cArray[n6++] = (char)n;
        }
        block6: while (n2 < n5) {
            n = byArray2[n2] & 0xFF;
            switch (n >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    cArray[n6++] = (char)n;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n5) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray2[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + n2);
                    }
                    cArray[n6++] = (char)((n & 0x1F) << 6 | by & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((n2 += 3) > n5) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray2[n2 - 2];
                    byte by2 = byArray2[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (n2 - 1));
                    }
                    cArray[n6++] = (char)((n & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + n2);
        }
        return new String(cArray, 0, n6);
    }

    public static void validatePersistableClassArgument(Class clazz) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("The persistable class cannot be null!");
        }
        if (!__persistableClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a valid persistable class. Check the weaver execution!");
        }
    }

    static boolean equals(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == hashtable2) {
            return true;
        }
        if (hashtable == null || hashtable2 == null) {
            return false;
        }
        if (hashtable.size() != hashtable2.size()) {
            return false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            if (!(v == null ? hashtable2.get(k) != null || !hashtable2.containsKey(k) : !v.equals(hashtable2.get(k)))) continue;
            return false;
        }
        return true;
    }

    static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n = nArray.length;
        if (nArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            n = 31 * n + nArray[i];
        }
        return n;
    }

    static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            n = 31 * n + (objectArray[i] == null ? 0 : objectArray[i].hashCode());
        }
        return n;
    }

    static {
        try {
            __persistableClass = Class.forName("net.sourceforge.floggy.persistence.impl.__Persistable");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        FALSE = new Boolean(false);
        TRUE = new Boolean(true);
    }
}

