/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.io.DataInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.SerializationManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.__Persistable;
import net.sourceforge.floggy.persistence.impl.migration.HashtableValueNullable;
import net.sourceforge.floggy.persistence.migration.Enumeration;
import net.sourceforge.floggy.persistence.migration.FieldPersistableInfo;

public abstract class AbstractEnumerationImpl
implements Enumeration {
    protected PersistableManager manager = PersistableManager.getInstance();
    protected PersistableMetadata classBasedMetadata;
    protected PersistableMetadata rmsBasedMetadata;
    protected RecordEnumeration enumeration;
    protected RecordStore recordStore;
    protected boolean iterationMode;
    protected boolean lazy;
    protected int recordId = -1;

    protected AbstractEnumerationImpl(PersistableMetadata persistableMetadata, PersistableMetadata persistableMetadata2, RecordEnumeration recordEnumeration, RecordStore recordStore, boolean bl, boolean bl2) throws RecordStoreException {
        this.rmsBasedMetadata = persistableMetadata;
        this.classBasedMetadata = persistableMetadata2;
        this.enumeration = recordEnumeration;
        this.recordStore = recordStore;
        this.lazy = bl;
        this.iterationMode = bl2;
    }

    public int delete() throws FloggyException {
        if (this.recordId != -1) {
            try {
                this.recordStore.deleteRecord(this.recordId);
                int n = this.recordId;
                this.recordId = -1;
                return n;
            }
            catch (RecordStoreException recordStoreException) {
                throw Utils.handleException((Exception)((Object)recordStoreException));
            }
        }
        throw new FloggyException("There isn't a register to delete. You have to iterate over the enumeration before call delete.");
    }

    public int getSize() {
        return this.enumeration.numRecords();
    }

    public boolean hasMoreElements() {
        return this.enumeration.hasNextElement();
    }

    public Hashtable nextElement() throws FloggyException {
        if (this.recordId != -1 && !this.iterationMode) {
            throw new FloggyException("You should delete or update the current register before step into the next one.");
        }
        HashtableValueNullable hashtableValueNullable = new HashtableValueNullable();
        try {
            this.recordId = this.enumeration.nextRecordId();
            byte[] byArray = this.recordStore.getRecord(this.recordId);
            this.buildPersistable(this.rmsBasedMetadata, byArray, hashtableValueNullable);
        }
        catch (Exception exception) {
            throw Utils.handleException(exception);
        }
        return hashtableValueNullable;
    }

    public int update(Persistable persistable) throws FloggyException {
        if (this.recordId != -1) {
            __Persistable __Persistable2 = Utils.checkArgumentAndCast(persistable);
            __Persistable2.__setId(this.recordId);
            int n = this.manager.save((Persistable)__Persistable2);
            this.recordId = -1;
            return n;
        }
        throw new FloggyException("There isn't a register to update. You have to iterate over the enumeration before call update.");
    }

    protected abstract void buildPersistable(PersistableMetadata var1, byte[] var2, Hashtable var3) throws Exception;

    protected Object[] createArray(int n, int n2) throws FloggyException {
        switch (n) {
            case 1: {
                return new Boolean[n2];
            }
            case 2: {
                return new Byte[n2];
            }
            case 4: {
                return new Calendar[n2];
            }
            case 8: {
                return new Character[n2];
            }
            case 16: {
                return new Date[n2];
            }
            case 32: {
                return new Double[n2];
            }
            case 64: {
                return new Float[n2];
            }
            case 128: {
                return new Hashtable[n2];
            }
            case 256: {
                return new Integer[n2];
            }
            case 512: {
                return new Long[n2];
            }
            case 1024: {
                return new FieldPersistableInfo[n2];
            }
            case 2048: {
                return new Short[n2];
            }
            case 4096: {
                return new Stack[n2];
            }
            case 8192: {
                return new String[n2];
            }
            case 16384: {
                return new StringBuffer[n2];
            }
            case 32768: {
                return new TimeZone[n2];
            }
            case 65536: {
                return new Vector[n2];
            }
        }
        throw new FloggyException("Type Unknow: " + n);
    }

    protected Object[] createArrayCLDC10(int n, int n2) throws FloggyException {
        switch (n) {
            case 1: {
                return new Boolean[n2];
            }
            case 2: {
                return new Byte[n2];
            }
            case 4: {
                return new Calendar[n2];
            }
            case 8: {
                return new Character[n2];
            }
            case 16: {
                return new Date[n2];
            }
            case 128: {
                return new Hashtable[n2];
            }
            case 256: {
                return new Integer[n2];
            }
            case 512: {
                return new Long[n2];
            }
            case 1024: {
                return new FieldPersistableInfo[n2];
            }
            case 2048: {
                return new Short[n2];
            }
            case 4096: {
                return new Stack[n2];
            }
            case 8192: {
                return new String[n2];
            }
            case 16384: {
                return new StringBuffer[n2];
            }
            case 32768: {
                return new TimeZone[n2];
            }
            case 65536: {
                return new Vector[n2];
            }
        }
        throw new FloggyException("Type Unknow: " + n);
    }

    protected Object readArray(int n, String string, DataInputStream dataInputStream) throws Exception {
        Object[] objectArray = null;
        if (dataInputStream.readByte() == 0) {
            int n2 = dataInputStream.readInt();
            if ((n & 0x40000) == 262144) {
                switch (n &= 0xFFFBFFFF) {
                    case 1: {
                        objectArray = this.readBooleanArray(n2, dataInputStream);
                        break;
                    }
                    case 2: {
                        objectArray = this.readByteArray(n2, dataInputStream);
                        break;
                    }
                    case 8: {
                        objectArray = this.readCharArray(n2, dataInputStream);
                        break;
                    }
                    case 32: {
                        objectArray = this.readDoubleArray(n2, dataInputStream);
                        break;
                    }
                    case 64: {
                        objectArray = this.readFloatArray(n2, dataInputStream);
                        break;
                    }
                    case 256: {
                        objectArray = this.readIntArray(n2, dataInputStream);
                        break;
                    }
                    case 512: {
                        objectArray = this.readLongArray(n2, dataInputStream);
                        break;
                    }
                    case 2048: {
                        objectArray = this.readShortArray(n2, dataInputStream);
                    }
                }
            } else {
                Object[] objectArray2 = this.createArray(n, n2);
                for (int i = 0; i < n2; ++i) {
                    objectArray2[i] = this.readObject(n, string, dataInputStream);
                }
                objectArray = objectArray2;
            }
        }
        return objectArray;
    }

    protected Object readArrayCLDC10(int n, String string, DataInputStream dataInputStream) throws Exception {
        Object[] objectArray = null;
        if (dataInputStream.readByte() == 0) {
            int n2 = dataInputStream.readInt();
            if ((n & 0x40000) == 262144) {
                switch (n &= 0xFFFBFFFF) {
                    case 1: {
                        objectArray = this.readBooleanArray(n2, dataInputStream);
                        break;
                    }
                    case 2: {
                        objectArray = this.readByteArray(n2, dataInputStream);
                        break;
                    }
                    case 8: {
                        objectArray = this.readCharArray(n2, dataInputStream);
                        break;
                    }
                    case 256: {
                        objectArray = this.readIntArray(n2, dataInputStream);
                        break;
                    }
                    case 512: {
                        objectArray = this.readLongArray(n2, dataInputStream);
                        break;
                    }
                    case 2048: {
                        objectArray = this.readShortArray(n2, dataInputStream);
                    }
                }
            } else {
                Object[] objectArray2 = this.createArray(n, n2);
                for (int i = 0; i < n2; ++i) {
                    objectArray2[i] = this.readObject(n, string, dataInputStream);
                }
                objectArray = objectArray2;
            }
        }
        return objectArray;
    }

    protected boolean[] readBooleanArray(int n, DataInputStream dataInputStream) throws Exception {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = dataInputStream.readBoolean();
        }
        return blArray;
    }

    protected byte[] readByteArray(int n, DataInputStream dataInputStream) throws Exception {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = dataInputStream.readByte();
        }
        return byArray;
    }

    protected char[] readCharArray(int n, DataInputStream dataInputStream) throws Exception {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        return cArray;
    }

    protected double[] readDoubleArray(int n, DataInputStream dataInputStream) throws Exception {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dataInputStream.readDouble();
        }
        return dArray;
    }

    protected float[] readFloatArray(int n, DataInputStream dataInputStream) throws Exception {
        float[] fArray = new float[n];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = dataInputStream.readFloat();
        }
        return fArray;
    }

    protected int[] readIntArray(int n, DataInputStream dataInputStream) throws Exception {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    protected long[] readLongArray(int n, DataInputStream dataInputStream) throws Exception {
        long[] lArray = new long[n];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = dataInputStream.readLong();
        }
        return lArray;
    }

    protected Object readObject(int n, String string, DataInputStream dataInputStream) throws Exception {
        switch (n) {
            case 1: {
                return SerializationManager.readBoolean(dataInputStream);
            }
            case 2: {
                return SerializationManager.readByte(dataInputStream);
            }
            case 4: {
                return SerializationManager.readCalendar(dataInputStream);
            }
            case 8: {
                return SerializationManager.readChar(dataInputStream);
            }
            case 16: {
                return SerializationManager.readDate(dataInputStream);
            }
            case 32: {
                return SerializationManager.readDouble(dataInputStream);
            }
            case 64: {
                return SerializationManager.readFloat(dataInputStream);
            }
            case 128: {
                return SerializationManager.readHashtable(dataInputStream);
            }
            case 256: {
                return SerializationManager.readInt(dataInputStream);
            }
            case 512: {
                return SerializationManager.readLong(dataInputStream);
            }
            case 1024: {
                FieldPersistableInfo fieldPersistableInfo = null;
                String string2 = this.rmsBasedMetadata.getPersistableImplementationClassForField(string);
                switch (dataInputStream.readByte()) {
                    case -1: {
                        string2 = dataInputStream.readUTF();
                    }
                    case 0: {
                        int n2 = dataInputStream.readInt();
                        fieldPersistableInfo = new FieldPersistableInfo(n2, string2);
                    }
                }
                return fieldPersistableInfo;
            }
            case 2048: {
                return SerializationManager.readShort(dataInputStream);
            }
            case 4096: {
                return SerializationManager.readStack(dataInputStream, this.lazy);
            }
            case 8192: {
                return SerializationManager.readString(dataInputStream);
            }
            case 16384: {
                return SerializationManager.readStringBuffer(dataInputStream);
            }
            case 32768: {
                return SerializationManager.readTimeZone(dataInputStream);
            }
            case 65536: {
                return SerializationManager.readVector(dataInputStream, this.lazy);
            }
        }
        throw new FloggyException("Type Unknow: " + n);
    }

    protected Object readObjectCLDC10(int n, String string, DataInputStream dataInputStream) throws Exception {
        switch (n) {
            case 1: {
                return SerializationManager.readBoolean(dataInputStream);
            }
            case 2: {
                return SerializationManager.readByte(dataInputStream);
            }
            case 4: {
                return SerializationManager.readCalendar(dataInputStream);
            }
            case 8: {
                return SerializationManager.readChar(dataInputStream);
            }
            case 16: {
                return SerializationManager.readDate(dataInputStream);
            }
            case 128: {
                return SerializationManager.readHashtable(dataInputStream);
            }
            case 256: {
                return SerializationManager.readInt(dataInputStream);
            }
            case 512: {
                return SerializationManager.readLong(dataInputStream);
            }
            case 1024: {
                FieldPersistableInfo fieldPersistableInfo = null;
                String string2 = this.rmsBasedMetadata.getPersistableImplementationClassForField(string);
                switch (dataInputStream.readByte()) {
                    case -1: {
                        string2 = dataInputStream.readUTF();
                    }
                    case 0: {
                        int n2 = dataInputStream.readInt();
                        fieldPersistableInfo = new FieldPersistableInfo(n2, string2);
                    }
                }
                return fieldPersistableInfo;
            }
            case 2048: {
                return SerializationManager.readShort(dataInputStream);
            }
            case 4096: {
                return SerializationManager.readStack(dataInputStream, this.lazy);
            }
            case 8192: {
                return SerializationManager.readString(dataInputStream);
            }
            case 16384: {
                return SerializationManager.readStringBuffer(dataInputStream);
            }
            case 32768: {
                return SerializationManager.readTimeZone(dataInputStream);
            }
            case 65536: {
                return SerializationManager.readVector(dataInputStream, this.lazy);
            }
        }
        throw new FloggyException("Type Unknow: " + n);
    }

    protected Object readPrimitive(int n, DataInputStream dataInputStream) throws Exception {
        switch (n) {
            case 1: {
                return dataInputStream.readBoolean() ? Utils.TRUE : Utils.FALSE;
            }
            case 2: {
                return new Byte(dataInputStream.readByte());
            }
            case 8: {
                return new Character(dataInputStream.readChar());
            }
            case 32: {
                return new Double(dataInputStream.readDouble());
            }
            case 64: {
                return new Float(dataInputStream.readFloat());
            }
            case 256: {
                return new Integer(dataInputStream.readInt());
            }
            case 512: {
                return new Long(dataInputStream.readLong());
            }
            case 2048: {
                return new Short(dataInputStream.readShort());
            }
        }
        throw new FloggyException("Type Unknow: " + n);
    }

    protected Object readPrimitiveCLDC10(int n, DataInputStream dataInputStream) throws Exception {
        switch (n) {
            case 1: {
                return dataInputStream.readBoolean() ? Utils.TRUE : Utils.FALSE;
            }
            case 2: {
                return new Byte(dataInputStream.readByte());
            }
            case 8: {
                return new Character(dataInputStream.readChar());
            }
            case 256: {
                return new Integer(dataInputStream.readInt());
            }
            case 512: {
                return new Long(dataInputStream.readLong());
            }
            case 2048: {
                return new Short(dataInputStream.readShort());
            }
        }
        throw new FloggyException("Type Unknow: " + n);
    }

    protected short[] readShortArray(int n, DataInputStream dataInputStream) throws Exception {
        short[] sArray = new short[n];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        return sArray;
    }

    void finish() throws FloggyException {
        if (!this.enumeration.hasNextElement()) {
            this.enumeration.destroy();
            RecordStoreManager.closeRecordStore(this.recordStore);
            if (this.rmsBasedMetadata != this.classBasedMetadata) {
                try {
                    this.classBasedMetadata.setRecordId(this.rmsBasedMetadata.getRecordId());
                    this.classBasedMetadata.setRecordStoreVersion(PersistableMetadataManager.getBytecodeVersion());
                    PersistableMetadataManager.saveRMSStructure(this.classBasedMetadata);
                }
                catch (Exception exception) {
                    throw Utils.handleException(exception);
                }
            }
        } else {
            throw new FloggyException("The enumeration must be whole processed before finish the process!");
        }
    }
}

