/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.__Persistable;
import net.sourceforge.floggy.persistence.impl.migration.AbstractEnumerationImpl;
import net.sourceforge.floggy.persistence.impl.migration.HashtableValueNullable;

public class JoinedStrategyEnumerationImpl
extends AbstractEnumerationImpl {
    protected Hashtable superClassesIDs = new Hashtable();

    public JoinedStrategyEnumerationImpl(PersistableMetadata persistableMetadata, PersistableMetadata persistableMetadata2, RecordEnumeration recordEnumeration, RecordStore recordStore, boolean bl, boolean bl2) throws IOException, RecordStoreException {
        super(persistableMetadata, persistableMetadata2, recordEnumeration, recordStore, bl, bl2);
    }

    public int delete() throws FloggyException {
        if (this.recordId != -1) {
            try {
                this.deleteSuperClassesRegisters();
                this.recordStore.deleteRecord(this.recordId);
                int n = this.recordId;
                this.recordId = -1;
                return n;
            }
            catch (RecordStoreException recordStoreException) {
                throw Utils.handleException((Exception)((Object)recordStoreException));
            }
        }
        throw new FloggyException("There isn't a register to delete. You have to iterate over the enumeration before call delete.");
    }

    public Hashtable nextElement() throws FloggyException {
        if (this.recordId != -1 && !this.iterationMode) {
            throw new FloggyException("You should delete or update the current register before step into the next one.");
        }
        this.superClassesIDs.clear();
        HashtableValueNullable hashtableValueNullable = new HashtableValueNullable();
        try {
            this.recordId = this.enumeration.nextRecordId();
            byte[] byArray = this.recordStore.getRecord(this.recordId);
            this.buildPersistable(this.rmsBasedMetadata, byArray, hashtableValueNullable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Utils.handleException(exception);
        }
        return hashtableValueNullable;
    }

    public int update(Persistable persistable) throws FloggyException {
        if (this.recordId != -1) {
            __Persistable __Persistable2 = Utils.checkArgumentAndCast(persistable);
            try {
                __Persistable2.__setId(this.recordId);
                this.deleteSuperClassesRegisters();
                int n = this.manager.save((Persistable)__Persistable2);
                this.recordId = -1;
                return n;
            }
            catch (RecordStoreException recordStoreException) {
                throw Utils.handleException((Exception)((Object)recordStoreException));
            }
        }
        throw new FloggyException("There isn't a register to update. You have to iterate over the enumeration before call update.");
    }

    protected void buildPersistable(PersistableMetadata persistableMetadata, byte[] byArray, Hashtable hashtable) throws Exception {
        String[] stringArray = persistableMetadata.getFieldNames();
        int[] nArray = persistableMetadata.getFieldTypes();
        if (byArray != null) {
            Object object;
            int n;
            String string;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            if (PersistableMetadataManager.getRMSVersion().equals("1.4.0")) {
                dataInputStream.skipBytes(4);
            }
            if ((string = persistableMetadata.getSuperClassName()) != null) {
                n = dataInputStream.readInt();
                PersistableMetadata persistableMetadata2 = PersistableMetadataManager.getRMSBasedMetadata(string);
                if (persistableMetadata2 == null) {
                    persistableMetadata2 = PersistableMetadataManager.getClassBasedMetadata(string);
                }
                object = RecordStoreManager.getRecordStore(persistableMetadata2.getRecordStoreName(), persistableMetadata2);
                byte[] byArray2 = object.getRecord(n);
                this.buildPersistable(persistableMetadata2, byArray2, hashtable);
                this.superClassesIDs.put(string, new Integer(n));
                RecordStoreManager.closeRecordStore(object);
            }
            for (n = 0; n < stringArray.length; ++n) {
                int n2 = nArray[n];
                if (this.lazy) {
                    if ((n2 & 0x400) == 1024) continue;
                    object = (n2 & 0x20000) == 131072 ? this.readArray(n2 &= 0xFFFDFFFF, stringArray[n], dataInputStream) : ((n2 & 0x40000) == 262144 ? this.readPrimitive(n2 &= 0xFFFBFFFF, dataInputStream) : this.readObject(n2, stringArray[n], dataInputStream));
                    hashtable.put(stringArray[n], object);
                    continue;
                }
                object = (n2 & 0x20000) == 131072 ? this.readArray(n2 &= 0xFFFDFFFF, stringArray[n], dataInputStream) : ((n2 & 0x40000) == 262144 ? this.readPrimitive(n2 &= 0xFFFBFFFF, dataInputStream) : this.readObject(n2, stringArray[n], dataInputStream));
                hashtable.put(stringArray[n], object);
            }
        }
    }

    protected void deleteSuperClassesRegisters() throws FloggyException, RecordStoreException {
        if (!this.superClassesIDs.isEmpty()) {
            Enumeration enumeration = this.superClassesIDs.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                PersistableMetadata persistableMetadata = PersistableMetadataManager.getRMSBasedMetadata(string);
                if (persistableMetadata == null) continue;
                RecordStore recordStore = RecordStoreManager.getRecordStore(persistableMetadata.getRecordStoreName(), persistableMetadata);
                recordStore.deleteRecord(((Integer)this.superClassesIDs.get(string)).intValue());
                RecordStoreManager.closeRecordStore(recordStore);
            }
        }
    }
}

