/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.__Persistable;
import net.sourceforge.floggy.persistence.impl.migration.AbstractEnumerationImpl;
import net.sourceforge.floggy.persistence.impl.migration.JoinedStrategyEnumerationImpl;
import net.sourceforge.floggy.persistence.impl.migration.PerClassStrategyEnumerationImpl;
import net.sourceforge.floggy.persistence.impl.migration.SingleStrategyEnumerationImpl;
import net.sourceforge.floggy.persistence.migration.MigrationManager;

public class MigrationManagerImpl
extends MigrationManager {
    protected Hashtable enumerations = new Hashtable();

    public MigrationManagerImpl() throws Exception {
        PersistableManager.getInstance();
    }

    public void finish(Class clazz) throws FloggyException {
        Utils.validatePersistableClassArgument(clazz);
        AbstractEnumerationImpl abstractEnumerationImpl = (AbstractEnumerationImpl)this.enumerations.get(clazz);
        if (abstractEnumerationImpl != null) {
            abstractEnumerationImpl.finish();
        }
    }

    public String[] getNotMigratedClasses() {
        Vector vector = PersistableMetadataManager.getNotMigratedClasses();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void quickMigration(Class clazz) throws FloggyException {
        Utils.validatePersistableClassArgument(clazz);
        String string = clazz.getName();
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(string);
        PersistableMetadata persistableMetadata2 = PersistableMetadataManager.getRMSBasedMetadata(string);
        if (persistableMetadata2 != null) {
            if (!persistableMetadata.equals(persistableMetadata2)) {
                throw new FloggyException("Class and RMS description doesn't match for class " + string + ". Please execute a normal migration process.");
            }
        } else {
            try {
                PersistableMetadataManager.saveRMSStructure(persistableMetadata);
            }
            catch (Exception exception) {
                throw Utils.handleException(exception);
            }
        }
    }

    public net.sourceforge.floggy.persistence.migration.Enumeration start(Class clazz, Hashtable hashtable) throws FloggyException {
        RecordStore recordStore;
        Utils.validatePersistableClassArgument(clazz);
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(clazz.getName());
        if (persistableMetadata.isAbstract()) {
            throw new FloggyException("It is not possible migrate abstract classes. Instead migrate its subclasses");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (hashtable != null) {
            recordStore = (RecordStore)hashtable.get("LAZY_LOAD");
            if (recordStore instanceof Boolean) {
                bl = (Boolean)recordStore;
            }
            if ((recordStore = (RecordStore)hashtable.get("MIGRATE_FROM_PREVIOUS_1_3_0_VERSION")) instanceof Boolean) {
                bl2 = (Boolean)recordStore;
            }
            if ((recordStore = (RecordStore)hashtable.get("ITERATION_MODE")) instanceof Boolean) {
                bl3 = (Boolean)recordStore;
            }
        }
        recordStore = null;
        AbstractEnumerationImpl abstractEnumerationImpl = null;
        PersistableMetadata persistableMetadata2 = null;
        try {
            __Persistable __Persistable2;
            persistableMetadata2 = PersistableMetadataManager.getRMSBasedMetadata(clazz.getName());
            if (persistableMetadata2 == null) {
                if (bl2) {
                    persistableMetadata2 = persistableMetadata;
                } else {
                    throw new FloggyException("Set the property MigrationManager.MIGRATE_FROM_PREVIOUS_1_3_0_VERSION to true to migrate from a version lower than 1.3.0.");
                }
            }
            if (persistableMetadata.getPersistableStrategy() == 4 && persistableMetadata2.getPersistableStrategy() == 1) {
                recordStore = RecordStoreManager.getRecordStore(persistableMetadata2.getRecordStoreName(), persistableMetadata2, true);
            } else {
                __Persistable2 = Utils.createInstance(clazz);
                recordStore = RecordStoreManager.getRecordStore(__Persistable2.getRecordStoreName(), persistableMetadata, true);
            }
            __Persistable2 = recordStore.enumerateRecords(null, null, false);
            Hashtable hashtable2 = persistableMetadata2.getPersistableImplementations();
            if (!bl && hashtable2 != null) {
                Enumeration enumeration = hashtable2.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string.endsWith("[]")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    PersistableMetadata persistableMetadata3 = PersistableMetadataManager.getClassBasedMetadata(string);
                    PersistableMetadata persistableMetadata4 = PersistableMetadataManager.getRMSBasedMetadata(string);
                    if (persistableMetadata3 == null || persistableMetadata4 == null || persistableMetadata3.equals(persistableMetadata4)) continue;
                    throw new FloggyException("You first must migrate the class " + string + " than you can migrate " + clazz.getName());
                }
            }
            switch (persistableMetadata2.getPersistableStrategy()) {
                case 4: {
                    abstractEnumerationImpl = new SingleStrategyEnumerationImpl(persistableMetadata2, persistableMetadata, (RecordEnumeration)__Persistable2, recordStore, bl, bl3);
                    break;
                }
                case 2: {
                    abstractEnumerationImpl = new PerClassStrategyEnumerationImpl(persistableMetadata2, persistableMetadata, (RecordEnumeration)__Persistable2, recordStore, bl, bl3);
                    break;
                }
                case 1: {
                    abstractEnumerationImpl = new JoinedStrategyEnumerationImpl(persistableMetadata2, persistableMetadata, (RecordEnumeration)__Persistable2, recordStore, bl, bl3);
                    break;
                }
            }
            this.enumerations.put(clazz, abstractEnumerationImpl);
        }
        catch (Exception exception) {
            throw Utils.handleException(exception);
        }
        return abstractEnumerationImpl;
    }
}

