/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.migration.AbstractEnumerationImpl;
import net.sourceforge.floggy.persistence.impl.migration.HashtableValueNullable;

public class SingleStrategyEnumerationImpl
extends AbstractEnumerationImpl {
    protected Vector datas;
    protected Vector ids;
    protected int currentIndex = 0;

    public SingleStrategyEnumerationImpl(PersistableMetadata persistableMetadata, PersistableMetadata persistableMetadata2, RecordEnumeration recordEnumeration, RecordStore recordStore, boolean bl, boolean bl2) throws IOException, RecordStoreException {
        super(persistableMetadata, persistableMetadata2, recordEnumeration, recordStore, bl, bl2);
        this.datas = new Vector(recordEnumeration.numRecords());
        this.ids = new Vector(this.datas.size());
        while (recordEnumeration.hasNextElement()) {
            int n = recordEnumeration.nextRecordId();
            byte[] byArray = recordStore.getRecord(n);
            String string = Utils.readUTF8(byArray);
            if (!string.equals(persistableMetadata.getClassName())) continue;
            this.ids.addElement(new Integer(n));
            this.datas.addElement(byArray);
        }
    }

    public int getSize() {
        return this.datas.size();
    }

    public boolean hasMoreElements() {
        return this.currentIndex < this.getSize();
    }

    public Hashtable nextElement() throws FloggyException {
        if (this.recordId != -1 && !this.iterationMode) {
            throw new FloggyException("You should delete or update the current register before step into the next one.");
        }
        HashtableValueNullable hashtableValueNullable = new HashtableValueNullable();
        try {
            byte[] byArray = (byte[])this.datas.elementAt(this.currentIndex);
            this.recordId = (Integer)this.ids.elementAt(this.currentIndex);
            this.buildPersistable(this.rmsBasedMetadata, byArray, hashtableValueNullable);
            ++this.currentIndex;
        }
        catch (Exception exception) {
            throw Utils.handleException(exception);
        }
        return hashtableValueNullable;
    }

    protected void buildPersistable(PersistableMetadata persistableMetadata, byte[] byArray, Hashtable hashtable) throws Exception {
        String[] stringArray = persistableMetadata.getFieldNames();
        int[] nArray = persistableMetadata.getFieldTypes();
        if (byArray != null) {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            dataInputStream.readUTF();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                int n = nArray[i];
                if (this.lazy) {
                    if ((n & 0x400) == 1024) continue;
                    object = (n & 0x20000) == 131072 ? this.readArray(n &= 0xFFFDFFFF, stringArray[i], dataInputStream) : ((n & 0x40000) == 262144 ? this.readPrimitive(n &= 0xFFFBFFFF, dataInputStream) : this.readObject(n, stringArray[i], dataInputStream));
                    hashtable.put(stringArray[i], object);
                    continue;
                }
                object = (n & 0x20000) == 131072 ? this.readArray(n &= 0xFFFDFFFF, stringArray[i], dataInputStream) : ((n & 0x40000) == 262144 ? this.readPrimitive(n &= 0xFFFBFFFF, dataInputStream) : this.readObject(n, stringArray[i], dataInputStream));
                hashtable.put(stringArray[i], object);
            }
        }
    }

    void finish() throws FloggyException {
        if (!this.enumeration.hasNextElement()) {
            this.enumeration.destroy();
            RecordStoreManager.closeRecordStore(this.recordStore);
            if (this.rmsBasedMetadata != this.classBasedMetadata) {
                try {
                    this.classBasedMetadata.setRecordId(this.rmsBasedMetadata.getRecordId());
                    PersistableMetadataManager.saveRMSStructure(this.classBasedMetadata);
                }
                catch (Exception exception) {
                    throw Utils.handleException(exception);
                }
            }
        } else {
            throw new FloggyException("The enumeration must be whole processed before finish the process!");
        }
    }
}

