/*
 * file:       ViewFactory14.java
 * author:     Jon Iles
 * copyright:  (c) Packwood Software 2010
 * date:       16/04/2010
 */

/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

package net.sf.mpxj.mpp;

import java.io.IOException;
import java.util.Map;

import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.View;
import net.sf.mpxj.ViewType;

/**
 * Default implementation of a view factory for MPP14 files.
 */
class ViewFactory14 implements ViewFactory
{
   /**
    * {@inheritDoc}
    */
   public View createView(ProjectFile file, byte[] fixedMeta, byte[] fixedData, Var2Data varData, Map<Integer, FontBase> fontBases) throws IOException
   {
      View view;
      int splitViewFlag = MPPUtility.getShort(fixedData, 110);
      if (splitViewFlag == 1)
      {
         view = new SplitView9(file, fixedData, varData);
      }
      else
      {
         ViewType type = ViewType.getInstance(MPPUtility.getShort(fixedData, 112));
         switch (type)
         {
            case GANTT_CHART :
            {
               view = new GanttChartView14(file, fixedMeta, fixedData, varData, fontBases);
               break;
            }

            default :
            {
               view = new GenericView14(file, fixedData, varData);
               break;
            }
         }
      }

      return (view);
   }
}
