/*
 * Decompiled with CFR 0.152.
 */
package net.synedra.validatorfx;

import java.util.LinkedHashMap;
import java.util.Map;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import net.synedra.validatorfx.Check;
import net.synedra.validatorfx.Severity;
import net.synedra.validatorfx.ValidationMessage;
import net.synedra.validatorfx.ValidationResult;

public class Validator {
    private Map<Check, ChangeListener<ValidationResult>> checks = new LinkedHashMap<Check, ChangeListener<ValidationResult>>();
    private ReadOnlyObjectWrapper<ValidationResult> validationResultProperty = new ReadOnlyObjectWrapper((Object)new ValidationResult());
    private ReadOnlyBooleanWrapper containsWarningsProperty = new ReadOnlyBooleanWrapper();
    private ReadOnlyBooleanWrapper containsErrorsProperty = new ReadOnlyBooleanWrapper();

    public Check createCheck() {
        Check check = new Check();
        this.add(check);
        return check;
    }

    public void add(Check check) {
        ChangeListener listener = (obs, oldv, newv) -> this.refreshProperties();
        this.checks.put(check, (ChangeListener<ValidationResult>)listener);
        check.validationResultProperty().addListener(listener);
    }

    public void remove(Check check) {
        ChangeListener<ValidationResult> listener = this.checks.remove(check);
        if (listener != null) {
            check.validationResultProperty().removeListener(listener);
        }
        this.refreshProperties();
    }

    public ValidationResult getValidationResult() {
        return (ValidationResult)this.validationResultProperty.get();
    }

    public ReadOnlyObjectProperty<ValidationResult> validationResultProperty() {
        return this.validationResultProperty.getReadOnlyProperty();
    }

    public ReadOnlyBooleanProperty containsWarningsProperty() {
        return this.containsWarningsProperty.getReadOnlyProperty();
    }

    public boolean containsWarnings() {
        return this.containsWarningsProperty().get();
    }

    public ReadOnlyBooleanProperty containsErrorsProperty() {
        return this.containsErrorsProperty.getReadOnlyProperty();
    }

    public boolean containsErrors() {
        return this.containsErrorsProperty().get();
    }

    public boolean validate() {
        for (Check check : this.checks.keySet()) {
            check.recheck();
        }
        return !this.containsErrors();
    }

    private void refreshProperties() {
        ValidationResult nextResult = new ValidationResult();
        for (Check check : this.checks.keySet()) {
            nextResult.addAll(check.getValidationResult().getMessages());
        }
        this.validationResultProperty.set((Object)nextResult);
        boolean hasWarnings = false;
        boolean hasErrors = false;
        for (ValidationMessage msg : nextResult.getMessages()) {
            hasWarnings = hasWarnings || msg.getSeverity() == Severity.WARNING;
            hasErrors = hasErrors || msg.getSeverity() == Severity.ERROR;
        }
        this.containsWarningsProperty.set(hasWarnings);
        this.containsErrorsProperty.set(hasErrors);
    }
}

