/*
 * Decompiled with CFR 0.152.
 */
package net.synedra.validatorfx;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class TooltipWrapper<T extends Node>
extends HBox {
    private T node;
    private Tooltip disabledTooltip;
    private ObservableValue<Boolean> disabledProperty;
    private BooleanProperty visibleProperty = new SimpleBooleanProperty(true);

    public TooltipWrapper(T node, ObservableValue<Boolean> disabledProperty, ObservableValue<String> tooltipText) {
        this.node = node;
        this.disabledProperty = disabledProperty;
        node.disableProperty().bind(disabledProperty);
        disabledProperty.addListener((observable, oldValue, newValue) -> this.updateTooltip());
        this.setId(node.getId() + "-wrapper");
        this.setAlignment(Pos.CENTER);
        HBox.setHgrow(node, (Priority)Priority.ALWAYS);
        this.visibleProperty().bind((ObservableValue)this.visibleProperty);
        this.getChildren().add(node);
        this.disabledTooltip = new Tooltip();
        this.disabledTooltip.setId(node.getId() + "-tooltip");
        this.disabledTooltip.getStyleClass().add((Object)"TooltipWrapper");
        this.disabledTooltip.textProperty().bind(tooltipText);
    }

    public T getWrappedNode() {
        return this.node;
    }

    public Tooltip getDisabledTooltip() {
        return this.disabledTooltip;
    }

    private void updateTooltip() {
        if (Boolean.TRUE.equals(this.disabledProperty.getValue())) {
            Tooltip.install((Node)this, (Tooltip)this.disabledTooltip);
        } else {
            Tooltip.uninstall((Node)this, (Tooltip)this.disabledTooltip);
        }
    }
}

