/*
 * Decompiled with CFR 0.152.
 */
package net.therore.pluginloader;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class PluginClassLoader
extends URLClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle.", "javassist.", "org.aspectj.", "net.sf.cglib."};
    private static final String CLASS_FILE_SUFFIX = ".class";
    protected static final boolean parallelCapableClassLoaderAvailable;
    protected final Set<String> LOADED_CLASSES = Collections.synchronizedSet(new HashSet());
    protected final Set<String> JAR_URL_PREFIXES;
    private final Set<String> excludedPackages = Collections.newSetFromMap(new ConcurrentHashMap(8));
    private final Set<String> excludedClasses = Collections.newSetFromMap(new ConcurrentHashMap(8));

    public PluginClassLoader(URL[] urls) {
        super(urls, (ClassLoader)null);
        for (String packageName : DEFAULT_EXCLUDED_PACKAGES) {
            this.excludePackage(packageName);
        }
        this.JAR_URL_PREFIXES = Arrays.stream(urls).map(url -> "jar:" + url.toString()).collect(Collectors.toSet());
    }

    public static Method getMethodIfAvailable(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Method[] methods;
        if (paramTypes != null) {
            try {
                return clazz.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
        HashSet<Method> candidates = new HashSet<Method>(1);
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            candidates.add(method);
        }
        if (candidates.size() == 1) {
            return (Method)candidates.iterator().next();
        }
        return null;
    }

    public void excludePackage(String packageName) {
        this.excludedPackages.add(packageName);
    }

    public void excludeClass(String name) {
        this.excludedClasses.add(name);
    }

    protected boolean isExcluded(String name) {
        if (this.excludedClasses.contains(name)) {
            return true;
        }
        for (String packageName : this.excludedPackages) {
            if (!name.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        if (this.isEligibleForOverriding(name) && (result = super.findClass(name)) != null) {
            this.LOADED_CLASSES.add(name);
            if (resolve) {
                this.resolveClass(result);
            }
            return result;
        }
        return super.loadClass(name, resolve);
    }

    public boolean isEligibleForOverriding(String name) {
        if (this.isExcluded(name)) {
            return false;
        }
        if (this.LOADED_CLASSES.contains(name)) {
            return false;
        }
        return this.findResource(name.replace('.', '/') + CLASS_FILE_SUFFIX) != null;
    }

    static {
        boolean bl = parallelCapableClassLoaderAvailable = PluginClassLoader.getMethodIfAvailable(ClassLoader.class, "registerAsParallelCapable", new Class[0]) != null;
        if (parallelCapableClassLoaderAvailable) {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

