/*
 * Decompiled with CFR 0.152.
 */
package net.therore.spring.mockito;

import java.lang.reflect.Field;
import net.therore.spring.mockito.MockedBean;
import org.mockito.Mockito;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.util.ClassUtils;

public class MockedBeanRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Field[] fields;
        for (Field field : fields = ((StandardAnnotationMetadata)importingClassMetadata).getIntrospectedClass().getDeclaredFields()) {
            MockedBean annotation = field.getAnnotation(MockedBean.class);
            if (annotation == null) continue;
            Class<?> clazz = field.getType();
            String[] names = annotation.value();
            AbstractBeanDefinition definition = BeanDefinitionBuilder.rootBeanDefinition(Mockito.class).setFactoryMethod("mock").addConstructorArgValue((Object)clazz.getName()).getBeanDefinition();
            if (names.length == 0) {
                names = new String[]{ClassUtils.getShortNameAsProperty(clazz)};
            }
            for (String name : names) {
                registry.registerBeanDefinition(name, (BeanDefinition)definition);
            }
        }
    }
}

