/*
 * Decompiled with CFR 0.152.
 */
package net.therore.spring.mockito;

import java.lang.reflect.Field;
import net.therore.spring.mockito.MockedBean;
import net.therore.spring.mockito.MockitoDelegate;
import net.therore.spring.mockito.SpiedBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.Primary;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;

public class MockedBeanRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Field[] fields;
        for (Field field : fields = ((StandardAnnotationMetadata)importingClassMetadata).getIntrospectedClass().getDeclaredFields()) {
            SpiedBean spiedBean;
            MockedBean mockedBean = field.getAnnotation(MockedBean.class);
            if (mockedBean != null) {
                this.registerMockedBean(registry, field, mockedBean);
            }
            if ((spiedBean = field.getAnnotation(SpiedBean.class)) == null) continue;
            this.registerSpiedBean(registry, field, spiedBean);
        }
    }

    private void registerMockedBean(BeanDefinitionRegistry registry, Field field, MockedBean annotation) {
        Class<?> clazz = field.getType();
        String[] names = annotation.value();
        RootBeanDefinition definition = (RootBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(MockitoDelegate.class).setFactoryMethod("mock").addConstructorArgValue((Object)clazz.getName()).getBeanDefinition();
        Qualifier qualifier = field.getAnnotation(Qualifier.class);
        if (qualifier == null) {
            qualifier = field.getDeclaringClass().getAnnotation(Qualifier.class);
        }
        if (qualifier != null) {
            if (Primary.class.equals((Object)qualifier)) {
                definition.setPrimary(true);
            }
            definition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)qualifier.value()));
        }
        if (names.length == 0) {
            names = new String[]{field.getName()};
        }
        for (String name : names) {
            try {
                registry.removeBeanDefinition(name);
            }
            catch (NoSuchBeanDefinitionException e) {
                // empty catch block
            }
            registry.registerBeanDefinition(name, (BeanDefinition)definition);
        }
    }

    private void registerSpiedBean(BeanDefinitionRegistry registry, Field field, SpiedBean annotation) {
        Class<?> clazz = field.getType();
        String name = annotation.value();
        if (name.isEmpty()) {
            name = field.getName();
        }
        BeanDefinition realDefinition = registry.getBeanDefinition(name);
        realDefinition.setAutowireCandidate(false);
        String realBeanName = "_real_" + name;
        registry.registerBeanDefinition(realBeanName, realDefinition);
        RootBeanDefinition definition = (RootBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(MockitoDelegate.class).setFactoryMethod("spy").addConstructorArgValue((Object)clazz.getName()).getBeanDefinition();
        definition.setPrimary(true);
        Qualifier qualifier = field.getAnnotation(Qualifier.class);
        if (qualifier == null) {
            qualifier = field.getDeclaringClass().getAnnotation(Qualifier.class);
        }
        if (qualifier != null) {
            definition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)qualifier.value()));
        }
        registry.registerBeanDefinition(name, (BeanDefinition)definition);
    }
}

