/*
 * Decompiled with CFR 0.152.
 */
package net.therore.spring.mockito.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import org.hamcrest.Matcher;
import org.mockito.ArgumentMatcher;

public class EventMatchers {
    private EventMatchers() {
    }

    public static Matcher<ILoggingEvent> errorWithException() {
        return new ArgumentMatcher<ILoggingEvent>(){

            public boolean matches(Object argument) {
                LoggingEvent event = (LoggingEvent)argument;
                return event.getLevel().isGreaterOrEqual(Level.WARN) && event.getThrowableProxy() != null;
            }
        };
    }

    public static Matcher<ILoggingEvent> text(final String text) {
        return new ArgumentMatcher<ILoggingEvent>(){

            public boolean matches(Object argument) {
                LoggingEvent event = (LoggingEvent)argument;
                return event.getFormattedMessage().contains(text);
            }
        };
    }
}

