/*
 * Decompiled with CFR 0.152.
 */
package net.therore.spring.mockito.logback;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import net.therore.spring.mockito.logback.Log;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.LoggerFactory;

public class LogbackRule
implements TestRule {
    private Appender appender;
    private Log log;
    private final Logger rootLogger;

    public LogbackRule() {
        this((Logger)LoggerFactory.getLogger((String)"ROOT"));
    }

    public LogbackRule(Logger rootLogger) {
        this.rootLogger = rootLogger;
        this.reset();
    }

    private void reset() {
        this.appender = null;
        this.log = null;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                LogbackRule.this.rootLogger.addAppender(LogbackRule.this.appender = (Appender)Mockito.mock(Appender.class));
                LogbackRule.this.log = (Log)Mockito.mock(Log.class);
                ((Appender)Mockito.doAnswer((Answer)new Answer(){

                    public Object answer(InvocationOnMock invocation) throws Throwable {
                        LogbackRule.this.log.contains((ILoggingEvent)invocation.getArguments()[0]);
                        return null;
                    }
                }).when((Object)LogbackRule.this.appender)).doAppend(Matchers.any(ILoggingEvent.class));
                try {
                    base.evaluate();
                }
                finally {
                    LogbackRule.this.rootLogger.detachAppender(LogbackRule.this.appender);
                    LogbackRule.this.reset();
                }
            }
        };
    }

    public Log getLog() {
        return this.log;
    }
}

