/*
 * Decompiled with CFR 0.152.
 */
package net.therore.concurrent.camel;

import java.util.concurrent.ExecutorService;
import net.therore.concurrent.camel.SelfTuningThreadPoolFactory;
import net.therore.concurrent.camel.SelfTuningThreadPoolProfile;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolFactory;

public class SelfTunigExecutorServiceManager
extends DefaultExecutorServiceManager {
    private SelfTuningThreadPoolFactory threadPoolFactory;
    private Long keepAliveSeconds;
    private String name = "SelfTunigExecutorServiceManager";

    public SelfTunigExecutorServiceManager(CamelContext camelContext) {
        super(camelContext);
        SelfTuningThreadPoolProfile profile = new SelfTuningThreadPoolProfile(this.getDefaultThreadPoolProfile());
        this.registerThreadPoolProfile(profile);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public void setKeepAliveSeconds(long keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.threadPoolFactory = new SelfTuningThreadPoolFactory(this.name, this.keepAliveSeconds);
        this.setThreadPoolFactory((ThreadPoolFactory)this.threadPoolFactory);
    }

    public void doStop() {
        if (this.threadPoolFactory != null) {
            this.threadPoolFactory.shutDown();
        }
        this.threadPoolFactory = null;
    }

    public ExecutorService newThreadPool(Object source, String name, int poolSize, int maxPoolSize) {
        SelfTuningThreadPoolProfile profile = new SelfTuningThreadPoolProfile(name);
        profile.setInitPoolSize(poolSize);
        profile.setPoolSize(1);
        profile.setMaxPoolSize(maxPoolSize);
        return this.newThreadPool(source, name, profile);
    }

    public ExecutorService newFixedThreadPool(Object source, String name, int poolSize) {
        SelfTuningThreadPoolProfile profile = new SelfTuningThreadPoolProfile(name);
        profile.setInitPoolSize(poolSize);
        profile.setPoolSize(1);
        profile.setMaxPoolSize(poolSize);
        profile.setKeepAliveTime(0L);
        return this.newThreadPool(source, name, profile);
    }
}

