/*
 * Decompiled with CFR 0.152.
 */
package net.therore.concurrent.camel;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.therore.concurrent.SelfTuningExecutors;
import net.therore.concurrent.camel.SelfTuningThreadPoolProfile;
import org.apache.camel.impl.DefaultThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;

public class SelfTuningThreadPoolFactory
extends DefaultThreadPoolFactory {
    private final SelfTuningExecutors executors;

    public SelfTuningThreadPoolFactory(String name, Long keepAliveSeconds) {
        this.executors = name != null ? (keepAliveSeconds != null ? new SelfTuningExecutors(name, keepAliveSeconds.longValue()) : new SelfTuningExecutors(name)) : (keepAliveSeconds != null ? new SelfTuningExecutors(keepAliveSeconds.longValue()) : new SelfTuningExecutors());
    }

    public ExecutorService newThreadPool(ThreadPoolProfile profile, ThreadFactory factory) {
        int queueSize;
        int priority;
        int maximumPoolSize;
        int initPoolSize;
        int corePoolSize;
        if (profile instanceof SelfTuningThreadPoolProfile) {
            SelfTuningThreadPoolProfile sprofile = (SelfTuningThreadPoolProfile)profile;
            corePoolSize = sprofile.getPoolSize();
            initPoolSize = sprofile.getInitPoolSize();
            maximumPoolSize = sprofile.getMaxPoolSize();
            priority = sprofile.getPriority();
            queueSize = sprofile.getMaxQueueSize();
        } else {
            corePoolSize = profile.getPoolSize();
            initPoolSize = profile.getPoolSize();
            maximumPoolSize = profile.getMaxPoolSize();
            priority = profile.getMaxPoolSize();
            queueSize = profile.getMaxQueueSize();
        }
        return this.executors.newSelfTuningExecutor(corePoolSize, initPoolSize, maximumPoolSize, priority, queueSize);
    }

    public ExecutorService newThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) throws IllegalArgumentException {
        int initPoolSize = corePoolSize;
        int maximumPoolSize = maxPoolSize;
        int priority = maxPoolSize;
        int queueSize = maxQueueSize;
        return this.executors.newSelfTuningExecutor(corePoolSize, initPoolSize, maximumPoolSize, priority, queueSize);
    }

    public void shutDown() {
        this.executors.shutDown();
    }
}

