/*
 * Decompiled with CFR 0.152.
 */
package net.therore.concurrent.camel;

import org.apache.camel.spi.ThreadPoolProfile;

public class SelfTuningThreadPoolProfile
extends ThreadPoolProfile {
    private static final long serialVersionUID = 1L;
    private Integer initPoolSize = null;
    private Integer priority = null;

    public SelfTuningThreadPoolProfile() {
    }

    public SelfTuningThreadPoolProfile(String id) {
        super(id);
    }

    public SelfTuningThreadPoolProfile(ThreadPoolProfile profile) {
        this.setDefaultProfile(profile.isDefaultProfile());
        this.setId(profile.getId());
        this.setKeepAliveTime(profile.getKeepAliveTime());
        this.setMaxPoolSize(profile.getMaxPoolSize());
        this.setMaxQueueSize(profile.getMaxQueueSize());
        this.setPoolSize(profile.getPoolSize());
        this.setRejectedPolicy(profile.getRejectedPolicy());
        this.setTimeUnit(profile.getTimeUnit());
        if (profile instanceof SelfTuningThreadPoolProfile) {
            SelfTuningThreadPoolProfile sprofile = (SelfTuningThreadPoolProfile)profile;
            this.setInitPoolSize(sprofile.getInitPoolSize());
            this.setPriority(sprofile.getPriority());
        }
    }

    public SelfTuningThreadPoolProfile clone() {
        SelfTuningThreadPoolProfile cloned = new SelfTuningThreadPoolProfile();
        cloned.setDefaultProfile(this.isDefaultProfile());
        cloned.setId(this.getId());
        cloned.setKeepAliveTime(this.getKeepAliveTime());
        cloned.setMaxPoolSize(this.getMaxPoolSize());
        cloned.setMaxQueueSize(this.getMaxQueueSize());
        cloned.setPoolSize(this.getPoolSize());
        cloned.setRejectedPolicy(this.getRejectedPolicy());
        cloned.setTimeUnit(this.getTimeUnit());
        cloned.setInitPoolSize(this.initPoolSize);
        cloned.setPriority(this.priority);
        return cloned;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("SelfTuningThreadPoolProfile[").append("id (").append(this.getId()).append(") size: ").append(this.getPoolSize()).append("-").append(this.getMaxPoolSize()).append(", keepAlive: ").append(this.getKeepAliveTime()).append(" ").append((Object)this.getTimeUnit()).append(", maxQueue: ").append(this.getMaxQueueSize()).append(", rejectedPolicy: ").append(this.getRejectedPolicy()).append(", initPoolSize: ").append(this.getInitPoolSize()).append(", priority: ").append(this.getPriority()).append("]");
        return result.toString();
    }

    public int getInitPoolSize() {
        if (this.initPoolSize == null) {
            this.initPoolSize = this.getPoolSize();
        }
        return this.initPoolSize;
    }

    public void setInitPoolSize(int initPoolSize) {
        this.initPoolSize = initPoolSize;
    }

    public int getPriority() {
        if (this.priority == null) {
            this.priority = this.getMaxPoolSize();
        }
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setPoolSize(Integer poolSize) {
        super.setPoolSize(poolSize);
        if (this.initPoolSize == null) {
            this.initPoolSize = poolSize;
        }
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        super.setMaxQueueSize(maxQueueSize);
        if (this.priority == null) {
            this.priority = maxQueueSize;
        }
    }

    public void addDefaults(ThreadPoolProfile defaultProfile) {
        super.addDefaults(defaultProfile);
        if (!(defaultProfile instanceof SelfTuningThreadPoolProfile)) {
            return;
        }
        SelfTuningThreadPoolProfile sdefaultProfile = (SelfTuningThreadPoolProfile)defaultProfile;
        if (this.initPoolSize == null) {
            this.initPoolSize = sdefaultProfile.getInitPoolSize();
        }
        if (this.priority == null) {
            this.priority = sdefaultProfile.getPriority();
        }
    }
}

