package net.therore.concurrent.quartz;

import net.therore.concurrent.SelfTuningExecutorService;
import net.therore.concurrent.SelfTuningExecutors;

import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class SelfTuningThreadPool implements ThreadPool {

	private SelfTuningExecutorService service;
	private int corePoolSize;
	private int initPoolSize;
	private int maximumPoolSize;
	private int priority;
	private int queueSize;

	public SelfTuningThreadPool() {
		super();
	}
	
	public int getCorePoolSize() {
		return corePoolSize;
	}

	public void setCorePoolSize(int corePoolSize) {
		this.corePoolSize = corePoolSize;
	}

	public void setInitPoolSize(int initPoolSize) {
		this.initPoolSize = initPoolSize;
	}

	public int getInitPoolSize() {
		return this.initPoolSize;
	}

	public int getMaximumPoolSize() {
		return maximumPoolSize;
	}

	public void setMaximumPoolSize(int maximumPoolSize) {
		this.maximumPoolSize = maximumPoolSize;
	}

	public int getPriority() {
		return priority;
	}

	public void setPriority(int priority) {
		this.priority = priority;
	}

	public int getQueueSize() {
		return queueSize;
	}

	public void setQueueSize(int queueSize) {
		this.queueSize = queueSize;
	}

	@Override
	public boolean runInThread(Runnable runnable) {
		service.execute(runnable);
		return true;
	}

	@Override
	public int blockForAvailableThreads() {
		int result = service.getPoolSize() - service.getActiveCount();
		if (result<0)
			result = 0;
		return result;
	}

	@Override
	public void initialize() throws SchedulerConfigException {
		SelfTuningExecutors selfTuningExecutors = SelfTuningExecutors.defaultSelfTuningExecutors();
		this.service = selfTuningExecutors.newSelfTuningExecutor(corePoolSize, initPoolSize, maximumPoolSize, priority, queueSize);
	}

	@Override
	public void shutdown(boolean waitForJobsToComplete) {
		this.service.shutdown();
	}

	@Override
	public int getPoolSize() {
		return service.getPoolSize();
	}

	@Override
	public void setInstanceId(String schedInstId) {
	}

	@Override
	public void setInstanceName(String schedName) {
	}

}
