/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.therore.concurrent.quartz;

import net.therore.concurrent.SelfTuningExecutorService;
import net.therore.concurrent.SelfTuningExecutors;

import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

/**
 * @author alfredo.diaz@therore.net
 */
public class SelfTuningThreadPool implements ThreadPool {

	private SelfTuningExecutorService service;
	private int corePoolSize;
	private int initPoolSize;
	private int maximumPoolSize;
	private int priority;
	private int queueSize;

	public SelfTuningThreadPool() {
		super();
	}
	
	public int getCorePoolSize() {
		return corePoolSize;
	}

	public void setCorePoolSize(int corePoolSize) {
		this.corePoolSize = corePoolSize;
	}

	public void setInitPoolSize(int initPoolSize) {
		this.initPoolSize = initPoolSize;
	}

	public int getInitPoolSize() {
		return this.initPoolSize;
	}

	public int getMaximumPoolSize() {
		return maximumPoolSize;
	}

	public void setMaximumPoolSize(int maximumPoolSize) {
		this.maximumPoolSize = maximumPoolSize;
	}

	public int getPriority() {
		return priority;
	}

	public void setPriority(int priority) {
		this.priority = priority;
	}

	public int getQueueSize() {
		return queueSize;
	}

	public void setQueueSize(int queueSize) {
		this.queueSize = queueSize;
	}

	@Override
	public boolean runInThread(Runnable runnable) {
		service.execute(runnable);
		return true;
	}

	@Override
	public int blockForAvailableThreads() {
		int result = service.getPoolSize() - service.getActiveCount();
		if (result<0)
			result = 0;
		return result;
	}

	@Override
	public void initialize() throws SchedulerConfigException {
		SelfTuningExecutors selfTuningExecutors = SelfTuningExecutors.defaultSelfTuningExecutors();
		this.service = selfTuningExecutors.newSelfTuningExecutor(corePoolSize, initPoolSize, maximumPoolSize, priority, queueSize);
	}

	@Override
	public void shutdown(boolean waitForJobsToComplete) {
		this.service.shutdown();
	}

	@Override
	public int getPoolSize() {
		return service.getPoolSize();
	}

	@Override
	public void setInstanceId(String schedInstId) {
	}

	@Override
	public void setInstanceName(String schedName) {
	}

}
