/*
 * Decompiled with CFR 0.152.
 */
package net.therore.concurrent;

import java.util.Arrays;

public abstract class ParameterOptimizer {
    private static final int LENGTH = 3;
    public static double MAX_STEP = 2.0;
    private int minValue;
    private final int maxValue;
    private int priority;

    public ParameterOptimizer(int minValue, int maxValue, int priority) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.priority = priority;
    }

    public int getMinValue() {
        return Math.max(this.minValue, this.getTotalValue() * this.priority / this.getTotalPriority() - 1);
    }

    public abstract int getTotalPriority();

    public abstract int getTotalValue();

    protected int optimalValue(double[] x, double[] y) {
        double x2mult;
        double optimalValue = Double.NaN;
        int direction = 0;
        try {
            if (x[0] != x[1] && x[0] != x[2] && x[1] != x[2]) {
                double[] c;
                if ((c = new double[]{y[0], (y[1] - c[0]) / (x[1] - x[0]), (y[2] - c[0] - c[1] * (x[2] - x[0])) / ((x[2] - x[0]) * (x[2] - x[1]))})[2] < 0.0) {
                    optimalValue = (c[2] * (x[0] + x[1]) - c[1]) / (2.0 * c[2]);
                } else {
                    direction = (int)Math.signum(c[1]);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Double.isNaN(optimalValue)) {
            int o = (int)x[0];
            int p = (int)x[1];
            int q = (int)x[2];
            int avg = (int)Math.round((x[0] + x[1] + x[2]) / 3.0);
            if (avg < 2) {
                avg = 2;
            }
            if (avg == o || avg == p || avg == q) {
                if (direction == 0) {
                    direction = 2 * (avg % 2 + 1) - 3;
                }
                for (int i = 1; !(i > 4 || (avg += direction * i) != o && avg != p && avg != q || (avg -= direction * 2 * i) != o && avg != p && avg != q); avg += direction * i, ++i) {
                }
            }
            optimalValue = avg;
        }
        if (optimalValue > (x2mult = MAX_STEP * x[2])) {
            optimalValue = x2mult;
        } else {
            double x2div = x[2] / MAX_STEP;
            if (optimalValue < x2div) {
                optimalValue = x2div;
            }
        }
        int minValue = this.getMinValue();
        int result = optimalValue < (double)minValue ? minValue : (optimalValue > (double)this.maxValue ? this.maxValue : (int)Math.round(optimalValue));
        return result;
    }

    protected void checkValues(double[] x, double[] y, double[] c) {
        for (int i = 0; i < 3; ++i) {
            double result = c[0] + c[1] * (x[i] - x[0]) + c[2] * (x[i] - x[0]) * (x[i] - x[1]);
            if (!(Math.abs(result - y[i]) > 1.0E-5)) continue;
            throw new RuntimeException("calculation error. x = " + Arrays.toString(x) + ", y = " + Arrays.toString(y));
        }
    }
}

