/*
 * Decompiled with CFR 0.152.
 */
package net.therore.concurrent;

import java.util.Arrays;
import net.therore.concurrent.ParameterOptimizer;

public class SampleContainer {
    private static final int LENGTH = 3;
    public static final long OVERHEAD_RELATION = 100L;
    public static final int MIN_SLOT_EXECUTIONS = 10;
    private final Sample[] samples = new Sample[3];
    private int last = 0;
    private long lastOverhead = 0L;

    public SampleContainer(int initValue) {
        this.samples[0] = new Sample(initValue);
        this.samples[1] = new Sample(initValue);
        this.samples[2] = new Sample(initValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getThroughput() {
        Sample[] sampleArray = this.samples;
        synchronized (this.samples) {
            Sample sample = this.samples[(this.last + 3 - 2) % 3];
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sample.interval != 0L ? (double)sample.terminatedExecutions * 1000.0 / (double)sample.interval : 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int annotationExecution(long timestamp, ParameterOptimizer poolSizeCalculator, ExecutionState state) {
        Sample[] sampleArray = this.samples;
        synchronized (this.samples) {
            Sample sample = this.samples[(this.last + 3 - 1) % 3];
            long tsdiff = timestamp - sample.timestamp;
            if (sample.terminatedExecutions > sample.poolSize * 10 && tsdiff > 100L * this.lastOverhead) {
                long startTs = System.currentTimeMillis();
                sample.interval = sample.timestamp != 0L ? tsdiff : 0L;
                double[] x = new double[3];
                double[] y = new double[3];
                for (int i = 0; i < 3; ++i) {
                    int pos = (i + this.last) % 3;
                    sample = this.samples[pos];
                    x[i] = sample.poolSize;
                    y[i] = sample.interval != 0L ? (double)sample.terminatedExecutions / (double)sample.interval : 0.0;
                }
                int poolSize = poolSizeCalculator.optimalValue(x, y);
                sample = this.samples[this.last];
                sample.timestamp = timestamp;
                sample.poolSize = poolSize;
                sample.terminatedExecutions = 1;
                sample.interval = 0L;
                this.last = (this.last + 1) % 3;
                this.lastOverhead = System.currentTimeMillis() - startTs;
            } else {
                if (sample.timestamp == 0L) {
                    sample.timestamp = timestamp;
                }
                sample.terminatedExecutions++;
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return sample.poolSize;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append("last: ").append(this.last).append(", samples: ").append(Arrays.toString(this.samples)).append("]");
        return result.toString();
    }

    public static enum ExecutionState {
        STARTED,
        TERMINATED;

    }

    public static class Sample {
        private long timestamp = 0L;
        private int poolSize;
        private int executions;
        private int terminatedExecutions;
        private long interval;

        public Sample(int initValue) {
            this.poolSize = initValue;
            this.executions = 0;
            this.interval = 0L;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("[").append("timestamp = ").append(this.timestamp).append(", poolSize = ").append(this.poolSize).append(", startedExecutions = ").append(this.executions).append(", terminatedExecutions = ").append(this.terminatedExecutions).append(", interval = ").append(this.interval).append("]");
            return result.toString();
        }
    }
}

