/*
 * Decompiled with CFR 0.152.
 */
package net.therore.concurrent;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import net.therore.concurrent.ParameterOptimizer;
import net.therore.concurrent.SampleContainer;
import net.therore.concurrent.SelfTuningExecutorServiceMBean;
import net.therore.concurrent.SelfTuningExecutors;

public class SelfTuningExecutorService
extends AbstractExecutorService
implements ExecutorService,
SelfTuningExecutorServiceMBean {
    public static final long POLL_MSECS = 5000L;
    public static final int DEFAULT_POOLSIZE = 1;
    private final ReentrantLock mainLock = new ReentrantLock();
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private final String name;
    private final SelfTuningExecutors executors;
    private final ThreadPoolExecutor coreExecutorService;
    private final SampleContainer sampleContainer;
    private final ArrayBlockingQueue<Runnable> workQueue;
    private final ParameterOptimizer optimizer;
    private final AtomicInteger activeCount;
    private final AtomicInteger totalExecutions;
    private final int queueSize;
    private final int initPoolSize;
    private final int corePoolSize;
    private final int maximumPoolSize;
    private final int priority;
    private volatile int poolSize = 1;

    public SelfTuningExecutorService(SelfTuningExecutors executors, ThreadPoolExecutor coreExecutorService, String name, int corePoolSize, int initPoolSize, int maximumPoolSize, int priority, int queueSize) {
        this.name = name == null ? String.valueOf(System.identityHashCode(this)) : name;
        this.executors = executors;
        this.coreExecutorService = coreExecutorService;
        this.sampleContainer = new SampleContainer(initPoolSize);
        this.queueSize = queueSize;
        this.workQueue = new ArrayBlockingQueue(queueSize, true);
        this.activeCount = new AtomicInteger(0);
        this.totalExecutions = new AtomicInteger(0);
        this.initPoolSize = initPoolSize;
        this.poolSize = initPoolSize;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.priority = priority;
        this.optimizer = new ParameterOptimizer(corePoolSize, maximumPoolSize, priority){

            @Override
            public int getTotalPriority() {
                return SelfTuningExecutorService.this.executors.getTotalPriority();
            }

            @Override
            public int getTotalValue() {
                return SelfTuningExecutorService.this.executors.getPoolSize();
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    public int getInitPoolSize() {
        return this.initPoolSize;
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public double getThroughput() {
        return this.sampleContainer.getThroughput();
    }

    @Override
    public int getActiveCount() {
        return this.activeCount.get();
    }

    @Override
    public int getTotalExecutions() {
        return this.totalExecutions.get();
    }

    public int getRunState() {
        if (!this.coreExecutorService.isShutdown()) {
            return 0;
        }
        if (this.coreExecutorService.isTerminated()) {
            return 3;
        }
        return 1;
    }

    @Override
    public void shutdown() {
        this.coreExecutorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.coreExecutorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.coreExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.coreExecutorService.isTerminated();
    }

    @Override
    public boolean isTerminating() {
        return this.coreExecutorService.isTerminating();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.coreExecutorService.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        int runState = this.getRunState();
        try {
            while (!this.addIfUnderCorePoolSize(command)) {
                if (runState == 0 && this.workQueue.offer(command, 5000L, TimeUnit.MILLISECONDS)) {
                    if (runState != 0 || this.poolSize == 0) {
                        this.ensureQueuedTaskHandled(command);
                    }
                } else if (runState == 0) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            this.reject(command);
        }
    }

    void reject(Runnable command) {
        this.coreExecutorService.getRejectedExecutionHandler().rejectedExecution(command, this.coreExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThread(Runnable firstTask) {
        FlowControlWrapper w = new FlowControlWrapper(firstTask);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.activeCount.incrementAndGet();
        }
        finally {
            mainLock.unlock();
        }
        this.coreExecutorService.execute(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfUnderCorePoolSize(Runnable firstTask) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int runState = this.getRunState();
            if (this.activeCount.get() < this.poolSize && runState == 0) {
                this.addThread(firstTask);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureQueuedTaskHandled(Runnable command) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        boolean reject = false;
        try {
            int state = this.getRunState();
            if (state != 0 && this.workQueue.remove(command)) {
                reject = true;
            } else if (state < 2 && this.activeCount.get() < this.poolSize && !this.workQueue.isEmpty()) {
                this.addThread(null);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (reject) {
            this.reject(command);
        }
    }

    protected Runnable getTask() {
        int state = this.getRunState();
        Runnable r = state == 1 ? this.workQueue.poll() : (this.activeCount.get() <= this.poolSize ? this.workQueue.poll() : null);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerDone(FlowControlWrapper w) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.activeCount.decrementAndGet() == 0) {
                this.tryTerminate();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    private void tryTerminate() {
        int state;
        if (this.activeCount.get() == 0 && (state = this.getRunState()) < 2 && !this.workQueue.isEmpty()) {
            state = 0;
            this.addThread(null);
        }
    }

    public class FlowControlWrapper
    implements Runnable {
        private Runnable firstTask;

        public FlowControlWrapper(Runnable firstTask) {
            this.firstTask = firstTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable task = this.firstTask;
                this.firstTask = null;
                while (task != null || (task = SelfTuningExecutorService.this.getTask()) != null) {
                    SelfTuningExecutorService.this.sampleContainer.annotationExecution(System.currentTimeMillis(), SelfTuningExecutorService.this.optimizer, SampleContainer.ExecutionState.STARTED);
                    SelfTuningExecutorService.this.totalExecutions.incrementAndGet();
                    task.run();
                    task = null;
                    int tmpPoolSize = SelfTuningExecutorService.this.sampleContainer.annotationExecution(System.currentTimeMillis(), SelfTuningExecutorService.this.optimizer, SampleContainer.ExecutionState.TERMINATED);
                    ReentrantLock mainLock = SelfTuningExecutorService.this.mainLock;
                    mainLock.lock();
                    try {
                        SelfTuningExecutorService.this.poolSize = tmpPoolSize;
                        int count = SelfTuningExecutorService.this.activeCount.get();
                        if (count <= tmpPoolSize) {
                            if (count >= tmpPoolSize) continue;
                            SelfTuningExecutorService.this.addThread(null);
                            continue;
                        }
                        break;
                    }
                    finally {
                        mainLock.unlock();
                    }
                }
            }
            finally {
                SelfTuningExecutorService.this.workerDone(this);
            }
        }
    }
}

