/*
 * Decompiled with CFR 0.152.
 */
package net.therore.concurrent;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.therore.concurrent.SelfTuningExecutorService;
import net.therore.concurrent.SelfTuningExecutorsMBean;

public class SelfTuningExecutors
implements SelfTuningExecutorsMBean {
    public static final String MBEAN_DOMAIN = "net.therore.concurrent";
    public static final long DEFAULT_KEEP_ALIVE_SECONDS = 86400L;
    private static volatile SelfTuningExecutors defaultSelfTuningExecutors = null;
    private ThreadPoolExecutor coreExecutorService;
    private int defaultQueueSize = 100;
    private AtomicInteger totalPriority = new AtomicInteger(0);
    private CopyOnWriteArrayList<SelfTuningExecutorService> executorServices = new CopyOnWriteArrayList();
    private final MBeanServer mbs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SelfTuningExecutors defaultSelfTuningExecutors() {
        if (defaultSelfTuningExecutors != null) return defaultSelfTuningExecutors;
        Class<SelfTuningExecutors> clazz = SelfTuningExecutors.class;
        synchronized (SelfTuningExecutors.class) {
            if (defaultSelfTuningExecutors != null) return defaultSelfTuningExecutors;
            defaultSelfTuningExecutors = new SelfTuningExecutors("default", 86400L);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultSelfTuningExecutors;
        }
    }

    public SelfTuningExecutors() {
        this(86400L);
    }

    public SelfTuningExecutors(String name, long keepAliveSeconds) {
        this.coreExecutorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, keepAliveSeconds, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        this.registerMBean(MBEAN_DOMAIN, "SelfTuningExecutors", null, name, this);
    }

    public SelfTuningExecutors(long keepAliveSeconds) {
        this.coreExecutorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, keepAliveSeconds, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        this.registerMBean(MBEAN_DOMAIN, "SelfTuningExecutors", null, String.valueOf(System.identityHashCode(this)), this);
    }

    public SelfTuningExecutors(String name) {
        this.coreExecutorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 86400L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        this.registerMBean(MBEAN_DOMAIN, "SelfTuningExecutors", null, name, this);
    }

    private void registerMBean(String domain, String component, String clazz, String object, Object mbean) {
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            if (object != null && !object.isEmpty()) {
                properties.put("context", object);
            }
            if (component != null && !component.isEmpty()) {
                properties.put("type", component);
            }
            if (clazz != null && !clazz.isEmpty()) {
                properties.put("name", clazz);
            }
            this.mbs.registerMBean(mbean, new ObjectName(domain, properties));
        }
        catch (InstanceAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        catch (NullPointerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getDefaultQueueSize() {
        return this.defaultQueueSize;
    }

    @Override
    public void setDefaultQueueSize(int defaultQueueSize) {
        this.defaultQueueSize = defaultQueueSize;
    }

    @Override
    public int getTotalPriority() {
        return this.totalPriority.get();
    }

    @Override
    public int getPoolSize() {
        int result = 0;
        for (SelfTuningExecutorService service : this.executorServices) {
            result += service.getPoolSize();
        }
        return result;
    }

    public SelfTuningExecutorService newSelfTuningExecutor(int corePoolSize, int initPoolSize, int maximumPoolSize) {
        return this.newSelfTuningExecutor(corePoolSize, initPoolSize, maximumPoolSize, maximumPoolSize, this.defaultQueueSize);
    }

    public SelfTuningExecutorService newSelfTuningExecutor(String name, int corePoolSize, int initPoolSize, int maximumPoolSize) {
        return this.newSelfTuningExecutor(name, corePoolSize, initPoolSize, maximumPoolSize, maximumPoolSize, this.defaultQueueSize);
    }

    public SelfTuningExecutorService newSelfTuningExecutor(int corePoolSize, int initPoolSize, int maximumPoolSize, int priority, int queueSize) {
        this.totalPriority.addAndGet(priority);
        SelfTuningExecutorService executorService = new SelfTuningExecutorService(this, this.coreExecutorService, null, corePoolSize, initPoolSize, maximumPoolSize, priority, queueSize);
        this.executorServices.add(executorService);
        this.registerMBean(MBEAN_DOMAIN, "SelfTuningExecutors", "ExecutorService", executorService.getName(), executorService);
        return executorService;
    }

    public SelfTuningExecutorService newSelfTuningExecutor(String name, int corePoolSize, int initPoolSize, int maximumPoolSize, int priority, int queueSize) {
        this.totalPriority.addAndGet(priority);
        SelfTuningExecutorService executorService = new SelfTuningExecutorService(this, this.coreExecutorService, name, corePoolSize, initPoolSize, maximumPoolSize, priority, queueSize);
        this.executorServices.add(executorService);
        this.registerMBean(MBEAN_DOMAIN, "SelfTuningExecutors", "ExecutorService", name, executorService);
        return executorService;
    }

    @Override
    public boolean isShutdown() {
        return this.coreExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.coreExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminating() {
        return this.coreExecutorService.isTerminating();
    }

    public void shutDown() {
        this.coreExecutorService.shutdown();
    }
}

