/*
 * Decompiled with CFR 0.152.
 */
package net.transgressoft.commons.music;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.transgressoft.commons.music.audio.ReactiveAudioItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.base.CharMatcher;
import org.jetbrains.kotlin.com.google.common.base.Splitter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u0002H\u00060\u0005j\b\u0012\u0004\u0012\u0002H\u0006`\u0007\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\bJ!\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u000eJ!\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eJ\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010 \u001a\u00020\u001eH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001eR\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lnet/transgressoft/commons/music/AudioUtils;", "", "<init>", "()V", "audioItemTrackDiscNumberComparator", "Ljava/util/Comparator;", "I", "Lkotlin/Comparator;", "Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;", "compareDiscNumbers", "", "disc1", "", "disc2", "(Ljava/lang/Short;Ljava/lang/Short;)I", "compareTrackNumbers", "track1", "track2", "endsWithRemix", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "startsWithRemixBy", "hasFt", "hasFeat", "hasFeaturing", "startsWithWith", "artistsRegexMap", "", "getArtistsNamesInvolved", "", "", "title", "artistName", "albumArtistName", "getNamesInArtist", "getNamesInTitle", "beautifyArtistName", "name", "music-commons-core"})
@SourceDebugExtension(value={"SMAP\nAudioUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioUtils.kt\nnet/transgressoft/commons/music/AudioUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1563#2:221\n1634#2,2:222\n1636#2:225\n1563#2:226\n1634#2,3:227\n1563#2:230\n1634#2,3:231\n1563#2:234\n1634#2,3:235\n1#3:224\n*S KotlinDebug\n*F\n+ 1 AudioUtils.kt\nnet/transgressoft/commons/music/AudioUtils\n*L\n159#1:221\n159#1:222,2\n159#1:225\n160#1:226\n160#1:227,3\n166#1:230\n166#1:231,3\n205#1:234\n205#1:235,3\n*E\n"})
public final class AudioUtils {
    @NotNull
    public static final AudioUtils INSTANCE;
    private static final Pattern endsWithRemix;
    private static final Pattern startsWithRemixBy;
    private static final Pattern hasFt;
    private static final Pattern hasFeat;
    private static final Pattern hasFeaturing;
    private static final Pattern startsWithWith;
    @NotNull
    private static final Map<Pattern, Pattern> artistsRegexMap;

    private AudioUtils() {
    }

    @NotNull
    public final <I extends ReactiveAudioItem<I>> Comparator<I> audioItemTrackDiscNumberComparator() {
        return AudioUtils::audioItemTrackDiscNumberComparator$lambda$0;
    }

    private final int compareDiscNumbers(Short disc1, Short disc2) {
        return disc1 == null && disc2 == null ? 0 : (disc1 == null ? 1 : (disc2 == null ? -1 : disc1 - disc2));
    }

    private final int compareTrackNumbers(Short track1, Short track2) {
        return track1 == null && track2 == null ? 0 : (track1 == null ? 1 : (track2 == null ? -1 : track1 - track2));
    }

    @NotNull
    public final Set<String> getArtistsNamesInvolved(@NotNull String title, @NotNull String artistName, @NotNull String albumArtistName) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)artistName, (String)"artistName");
        Intrinsics.checkNotNullParameter((Object)albumArtistName, (String)"albumArtistName");
        Set artistsInvolved = new LinkedHashSet();
        List list = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)",&")).trimResults().omitEmptyStrings().splitToList((CharSequence)albumArtistName);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitToList(...)");
        Collection albumArtistNames = list;
        artistsInvolved.addAll(albumArtistNames);
        artistsInvolved.addAll((Collection)this.getNamesInArtist(artistName));
        artistsInvolved.addAll((Collection)this.getNamesInTitle(title));
        artistsInvolved.remove("");
        return artistsInvolved;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getNamesInArtist(String artistName) {
        String[] stringArray;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String versusPattern = "\\s+(?i)(versus)\\s+";
        String vsPattern = "\\s+(?i)(vs)(\\.|\\s+)";
        String featPattern = "\\s+(?i)(feat)(\\.|\\s+)";
        String ftPattern = "\\s+(?i)(ft)(\\.|\\s+)";
        String commaPattern = "\\s*,\\s*";
        String ampersandPattern = "\\s+&\\s+";
        String separatorPattern = "(" + versusPattern + "|" + vsPattern + "|" + featPattern + "|" + ftPattern + "|" + commaPattern + "|" + ampersandPattern + ")";
        Object object = artistName;
        Regex regex = new Regex(separatorPattern);
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$map = false;
        void var11_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object2;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            stringArray = ((Object)StringsKt.trim((CharSequence)it)).toString();
            if (((CharSequence)stringArray).length() > 0) {
                void p0;
                char c = stringArray.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)p0));
                String[] stringArray2 = stringArray;
                int n2 = 1;
                String string2 = stringArray2.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                object2 = stringBuilder2.append(string2).toString();
            } else {
                object2 = stringArray;
            }
            collection.add(object2);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            stringArray = new String[]{" "};
            collection.add(CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" ", null, null, (int)0, null, AudioUtils::getNamesInArtist$lambda$1$0, (int)30, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.beautifyArtistName(it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getNamesInTitle(String title) {
        void $this$mapTo$iv$iv;
        String string;
        Object keyPattern;
        Set artistsInsideParenthesis = new LinkedHashSet();
        for (Map.Entry<Pattern, Pattern> entry : artistsRegexMap.entrySet()) {
            keyPattern = entry.getKey();
            Pattern value = entry.getValue();
            Matcher matcher = value.matcher(title);
            if (!matcher.find()) continue;
            String string2 = title.substring(matcher.start());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            CharSequence charSequence = string2;
            string = new Regex("[(\\[|)\\]]");
            String string3 = "";
            charSequence = string.replace(charSequence, string3);
            String string4 = ((Pattern)keyPattern).pattern();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pattern(...)");
            string = string4;
            string = new Regex(string);
            string3 = "";
            charSequence = string.replace(charSequence, string3);
            string = new Regex("\\s(?i)(vs)\\s");
            string3 = "&";
            charSequence = string.replace(charSequence, string3);
            string = new Regex("\\s+");
            string3 = " ";
            String insideParenthesisString = string.replace(charSequence, string3);
            List list = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"&,")).trimResults().omitEmptyStrings().splitToList((CharSequence)insideParenthesisString);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitToList(...)");
            artistsInsideParenthesis.addAll(list);
            break;
        }
        Iterable $this$map$iv = artistsInsideParenthesis;
        boolean $i$f$map = false;
        keyPattern = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            collection.add(CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" ", null, null, (int)0, null, AudioUtils::getNamesInTitle$lambda$0$0, (int)30, null));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String beautifyArtistName(@NotNull String name2) {
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CharSequence charSequence = name2;
        if (((CharSequence)charSequence).length() > 0) {
            void p0;
            char c = ((String)charSequence).charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)p0));
            object = charSequence;
            int n = 1;
            String string2 = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = stringBuilder2.append(string2).toString();
        } else {
            string = charSequence;
        }
        charSequence = string;
        object = new Regex("\\s+");
        String string3 = " ";
        charSequence = object.replace(charSequence, string3);
        object = new Regex(" (?i)(vs)(\\.|\\s)");
        string3 = " vs ";
        charSequence = object.replace(charSequence, string3);
        object = new Regex(" (?i)(versus) ");
        string3 = " versus ";
        return object.replace(charSequence, string3);
    }

    private static final int audioItemTrackDiscNumberComparator$lambda$0(ReactiveAudioItem audioItem1, ReactiveAudioItem audioItem2) {
        int discNumberComparison = INSTANCE.compareDiscNumbers(audioItem1.getDiscNumber(), audioItem2.getDiscNumber());
        return discNumberComparison == 0 ? INSTANCE.compareTrackNumbers(audioItem1.getTrackNumber(), audioItem2.getTrackNumber()) : discNumberComparison;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence getNamesInArtist$lambda$1$0(String word) {
        String string;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String string2 = word;
        if (((CharSequence)string2).length() > 0) {
            void p0;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)p0));
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence getNamesInTitle$lambda$0$0(String itt) {
        String string;
        Intrinsics.checkNotNullParameter((Object)itt, (String)"itt");
        String string2 = itt;
        if (((CharSequence)string2).length() > 0) {
            void p0;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)p0));
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = string2;
        }
        return string;
    }

    static {
        Map map;
        INSTANCE = new AudioUtils();
        endsWithRemix = Pattern.compile("[(|\\[](\\s*(&?\\s*(\\w+)\\s+)+(?i)(remix))[)|\\]]");
        startsWithRemixBy = Pattern.compile("[(|\\[](?i)(remix)(\\s+)(?i)(by)(.+)[)|\\]]");
        hasFt = Pattern.compile("[(\\[|\\s](?i)(ft) (.+)");
        hasFeat = Pattern.compile("[(\\[|\\s](?i)(feat) (.+)");
        hasFeaturing = Pattern.compile("[(\\[|\\s](?i)(featuring) (.+)");
        startsWithWith = Pattern.compile("[(|\\[](?i)(with) (.+)[)|\\]]");
        Map $this$artistsRegexMap_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$artistsRegexMap_u24lambda_u240.put(Pattern.compile(" (?i)(remix)"), endsWithRemix);
        $this$artistsRegexMap_u24lambda_u240.put(Pattern.compile("(?i)(remix)(\\s+)(?i)(by) "), startsWithRemixBy);
        $this$artistsRegexMap_u24lambda_u240.put(Pattern.compile("(?i)(ft) "), hasFt);
        $this$artistsRegexMap_u24lambda_u240.put(Pattern.compile("(?i)(feat) "), hasFeat);
        $this$artistsRegexMap_u24lambda_u240.put(Pattern.compile("(?i)(featuring) "), hasFeaturing);
        $this$artistsRegexMap_u24lambda_u240.put(Pattern.compile("(?i)(with) "), startsWithWith);
        artistsRegexMap = MapsKt.build((Map)map);
    }
}

