/*
 * Decompiled with CFR 0.152.
 */
package net.transgressoft.commons.music.audio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import net.transgressoft.commons.entity.IdentifiableEntity;
import net.transgressoft.commons.event.CrudEvent;
import net.transgressoft.commons.event.FlowEventPublisher;
import net.transgressoft.commons.event.StandardCrudEvent;
import net.transgressoft.commons.event.TransEvent;
import net.transgressoft.commons.event.TransEventPublisher;
import net.transgressoft.commons.music.audio.Artist;
import net.transgressoft.commons.music.audio.ArtistCatalogRegistry;
import net.transgressoft.commons.music.audio.ArtistView;
import net.transgressoft.commons.music.audio.ImmutableArtist;
import net.transgressoft.commons.music.audio.ImmutableArtistKt;
import net.transgressoft.commons.music.audio.MutableArtistCatalog;
import net.transgressoft.commons.music.audio.ReactiveAudioItem;
import net.transgressoft.commons.persistence.RegistryBase;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00050\u0003B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rJ\u001b\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0016\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rJ\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\rH\u0002J\u0012\u0010\u0019\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0002J\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u001b2\u0006\u0010 \u001a\u00020\u0004J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0004J\b\u0010$\u001a\u00020\u0004H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lnet/transgressoft/commons/music/audio/ArtistCatalogRegistry;", "I", "Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;", "Lnet/transgressoft/commons/persistence/RegistryBase;", "", "Lnet/transgressoft/commons/music/audio/MutableArtistCatalog;", "<init>", "()V", "log", "Lmu/KLogger;", "addAudioItems", "", "audioItems", "", "updateCatalog", "", "updatedAudioItem", "oldAudioItem", "(Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;)V", "artistOrAlbumChanged", "(Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;)Z", "audioItemOrderingChanged", "removeAudioItems", "toArtistNames", "", "artistUniqueId", "getArtistView", "Ljava/util/Optional;", "Lnet/transgressoft/commons/music/audio/ArtistView;", "artist", "Lnet/transgressoft/commons/music/audio/Artist;", "findFirst", "artistName", "findAlbumAudioItems", "", "albumName", "toString", "music-commons-core"})
@SourceDebugExtension(value={"SMAP\nArtistCatalogRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtistCatalogRegistry.kt\nnet/transgressoft/commons/music/audio/ArtistCatalogRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,164:1\n1#2:165\n1869#3,2:166\n1563#3:168\n1634#3,3:169\n295#3,2:172\n188#4,3:174\n*S KotlinDebug\n*F\n+ 1 ArtistCatalogRegistry.kt\nnet/transgressoft/commons/music/audio/ArtistCatalogRegistry\n*L\n120#1:166,2\n150#1:168\n150#1:169,3\n159#1:172,2\n56#1:174,3\n*E\n"})
public final class ArtistCatalogRegistry<I extends ReactiveAudioItem<I>>
extends RegistryBase<String, MutableArtistCatalog<I>> {
    @NotNull
    private final KLogger log = KotlinLogging.INSTANCE.logger(ArtistCatalogRegistry::log$lambda$0);

    public ArtistCatalogRegistry() {
        super(null, (TransEventPublisher)new FlowEventPublisher("ArtistCatalogRegistry"), 1, null);
        CrudEvent.Type[] typeArray = new CrudEvent.Type[]{CrudEvent.Type.READ, CrudEvent.Type.CREATE, CrudEvent.Type.UPDATE, CrudEvent.Type.DELETE};
        this.disableEvents(typeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addAudioItems(@NotNull Collection<? extends I> audioItems) {
        Intrinsics.checkNotNullParameter(audioItems, (String)"audioItems");
        ArtistCatalogRegistry artistCatalogRegistry = this;
        synchronized (artistCatalogRegistry) {
            boolean bl = false;
            List catalogsBeforeUpdate = new ArrayList();
            Map<Boolean, List<Object>> map = audioItems.stream().filter(arg_0 -> ArtistCatalogRegistry.addAudioItems$lambda$0$1(arg_0 -> ArtistCatalogRegistry.addAudioItems$lambda$0$0(this, arg_0), arg_0)).map(arg_0 -> ArtistCatalogRegistry.addAudioItems$lambda$0$3(arg_0 -> ArtistCatalogRegistry.addAudioItems$lambda$0$2(this, catalogsBeforeUpdate, arg_0), arg_0)).collect(Collectors.partitioningBy(arg_0 -> ArtistCatalogRegistry.addAudioItems$lambda$0$5(ArtistCatalogRegistry::addAudioItems$lambda$0$4, arg_0)));
            Intrinsics.checkNotNullExpressionValue(map, (String)"collect(...)");
            Map<Boolean, List<Object>> addedOrReplacedCatalogs = map;
            List<Object> list = addedOrReplacedCatalogs.get(true);
            if (list != null) {
                List<Object> createdCatalogs = list;
                boolean bl2 = false;
                if (!((Collection)createdCatalogs).isEmpty()) {
                    this.getPublisher().emitAsync((TransEvent)new StandardCrudEvent.Create((Collection)createdCatalogs));
                    this.log.debug(() -> ArtistCatalogRegistry.addAudioItems$lambda$0$6$0(createdCatalogs));
                }
            }
            List<Object> list2 = addedOrReplacedCatalogs.get(false);
            if (list2 != null) {
                List<Object> updatedCatalogs = list2;
                boolean bl3 = false;
                if (!((Collection)updatedCatalogs).isEmpty()) {
                    this.getPublisher().emitAsync((TransEvent)new StandardCrudEvent.Update((Collection)updatedCatalogs, (Collection)catalogsBeforeUpdate));
                    this.log.debug(() -> ArtistCatalogRegistry.addAudioItems$lambda$0$7$0(updatedCatalogs));
                }
            }
            boolean bl4 = !addedOrReplacedCatalogs.isEmpty();
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateCatalog(@NotNull I updatedAudioItem, @NotNull I oldAudioItem) {
        Intrinsics.checkNotNullParameter(updatedAudioItem, (String)"updatedAudioItem");
        Intrinsics.checkNotNullParameter(oldAudioItem, (String)"oldAudioItem");
        ArtistCatalogRegistry artistCatalogRegistry = this;
        synchronized (artistCatalogRegistry) {
            boolean bl = false;
            if (this.artistOrAlbumChanged(updatedAudioItem, oldAudioItem)) {
                boolean removed = this.removeAudioItems(CollectionsKt.listOf(oldAudioItem));
                boolean added = this.addAudioItems(CollectionsKt.listOf(updatedAudioItem));
                if (!(removed || added)) {
                    boolean bl2 = false;
                    String string = "Update of an audio item in the catalog is supposed to happen at this point";
                    throw new IllegalStateException(string.toString());
                }
                this.log.debug(() -> ArtistCatalogRegistry.updateCatalog$lambda$0$1(updatedAudioItem));
            } else if (this.audioItemOrderingChanged(updatedAudioItem, oldAudioItem)) {
                MutableArtistCatalog mutableArtistCatalog = (MutableArtistCatalog)this.getEntitiesById().get(this.artistUniqueId((ReactiveAudioItem<I>)updatedAudioItem));
                if (mutableArtistCatalog == null) {
                    throw new IllegalStateException(("Artist catalog for " + this.artistUniqueId((ReactiveAudioItem<I>)updatedAudioItem) + " should exist already at this point").toString());
                }
                MutableArtistCatalog artistCatalog = mutableArtistCatalog;
                MutableArtistCatalog artistCatalogBeforeUpdate = MutableArtistCatalog.copy$default(artistCatalog, null, 1, null);
                artistCatalog.mergeAudioItem(updatedAudioItem);
                this.getPublisher().emitAsync((TransEvent)new StandardCrudEvent.Update((IdentifiableEntity)artistCatalog, (IdentifiableEntity)artistCatalogBeforeUpdate));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean artistOrAlbumChanged(I updatedAudioItem, I oldAudioItem) {
        boolean artistChanged = !Intrinsics.areEqual((Object)updatedAudioItem.getArtist(), (Object)oldAudioItem.getArtist());
        boolean albumChanged = !Intrinsics.areEqual((Object)updatedAudioItem.getAlbum(), (Object)oldAudioItem.getAlbum());
        return artistChanged || albumChanged;
    }

    private final boolean audioItemOrderingChanged(I updatedAudioItem, I oldAudioItem) {
        Short s = updatedAudioItem.getTrackNumber();
        Short s2 = oldAudioItem.getTrackNumber();
        boolean trackNumberChanged = !Intrinsics.areEqual((Object)(s != null ? Integer.valueOf(s.shortValue()) : null), (Object)(s2 != null ? Integer.valueOf(s2.shortValue()) : null));
        Short s3 = updatedAudioItem.getDiscNumber();
        Short s4 = oldAudioItem.getDiscNumber();
        boolean discNumberChanged = !Intrinsics.areEqual((Object)(s3 != null ? Integer.valueOf(s3.shortValue()) : null), (Object)(s4 != null ? Integer.valueOf(s4.shortValue()) : null));
        return trackNumberChanged || discNumberChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeAudioItems(@NotNull Collection<? extends I> audioItems) {
        Intrinsics.checkNotNullParameter(audioItems, (String)"audioItems");
        ArtistCatalogRegistry artistCatalogRegistry = this;
        synchronized (artistCatalogRegistry) {
            boolean bl = false;
            List removedCatalogs = new ArrayList();
            List catalogsBeforeUpdate = new ArrayList();
            List updatedCatalogs = new ArrayList();
            Iterable $this$forEach$iv = audioItems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Boolean bl2;
                MutableArtistCatalog it;
                ReactiveAudioItem audioItem = (ReactiveAudioItem)element$iv;
                boolean bl3 = false;
                if ((MutableArtistCatalog)this.getEntitiesById().get(this.artistUniqueId(audioItem)) == null) continue;
                boolean bl4 = false;
                MutableArtistCatalog oldArtistCatalog = MutableArtistCatalog.copy$default(it, null, 1, null);
                boolean wasRemoved = it.removeAudioItem(audioItem);
                if (!wasRemoved) continue;
                if (it.isEmpty()) {
                    removedCatalogs.add(it);
                    bl2 = this.getEntitiesById().remove(this.artistUniqueId(audioItem));
                    continue;
                }
                updatedCatalogs.add(it);
                bl2 = catalogsBeforeUpdate.add(oldArtistCatalog);
            }
            if (!((Collection)removedCatalogs).isEmpty()) {
                this.getPublisher().emitAsync((TransEvent)new StandardCrudEvent.Delete((Collection)removedCatalogs));
                this.log.debug(() -> ArtistCatalogRegistry.removeAudioItems$lambda$0$1(this, removedCatalogs, audioItems));
            }
            if (!((Collection)updatedCatalogs).isEmpty()) {
                this.getPublisher().emitAsync((TransEvent)new StandardCrudEvent.Update((Collection)updatedCatalogs, (Collection)catalogsBeforeUpdate));
                this.log.debug(() -> ArtistCatalogRegistry.removeAudioItems$lambda$0$2(audioItems, this, updatedCatalogs));
            }
            boolean bl5 = !((Collection)removedCatalogs).isEmpty() || !((Collection)updatedCatalogs).isEmpty();
            return bl5;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toArtistNames(Collection<MutableArtistCatalog<I>> $this$toArtistNames) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toArtistNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MutableArtistCatalog mutableArtistCatalog = (MutableArtistCatalog)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getArtist().getName());
        }
        return (List)destination$iv$iv;
    }

    private final String artistUniqueId(ReactiveAudioItem<I> $this$artistUniqueId) {
        return ImmutableArtist.Companion.id$music_commons_core($this$artistUniqueId.getArtist().getName(), $this$artistUniqueId.getArtist().getCountryCode());
    }

    @NotNull
    public final Optional<ArtistView<I>> getArtistView(@NotNull Artist artist) {
        Intrinsics.checkNotNullParameter((Object)artist, (String)"artist");
        Optional<ArtistView<I>> optional = this.findFirst(artist).map(arg_0 -> ArtistCatalogRegistry.getArtistView$lambda$0(getArtistView.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    @NotNull
    public final Optional<MutableArtistCatalog<I>> findFirst(@NotNull Artist artist) {
        Intrinsics.checkNotNullParameter((Object)artist, (String)"artist");
        Optional<MutableArtistCatalog<I>> optional = Optional.ofNullable(this.getEntitiesById().get(ImmutableArtistKt.id(artist)));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Optional<MutableArtistCatalog<I>> findFirst(@NotNull String artistName) {
        Object v3;
        block1: {
            Intrinsics.checkNotNullParameter((Object)artistName, (String)"artistName");
            Iterable $this$firstOrNull$iv = this.getEntitiesById().entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                String string = ((String)it.getKey()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                CharSequence charSequence = string;
                String string2 = artistName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        Map.Entry entry = v3;
        Optional<MutableArtistCatalog<I>> optional = Optional.ofNullable(entry != null ? (MutableArtistCatalog)entry.getValue() : null);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Set<I> findAlbumAudioItems(@NotNull Artist artist, @NotNull String albumName) {
        Intrinsics.checkNotNullParameter((Object)artist, (String)"artist");
        Intrinsics.checkNotNullParameter((Object)albumName, (String)"albumName");
        Object object = (MutableArtistCatalog)this.getEntitiesById().get(ImmutableArtistKt.id(artist));
        if (object == null || (object = ((MutableArtistCatalog)object).findAlbumAudioItems(albumName)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @NotNull
    public String toString() {
        return "ArtistCatalogRegistry(numberOfArtists=" + this.getEntitiesById().size() + ")";
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final boolean addAudioItems$lambda$0$0(ArtistCatalogRegistry this$0, ReactiveAudioItem audioItem) {
        boolean bl;
        block3: {
            Map $this$any$iv = this$0.getEntitiesById();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    MutableArtistCatalog mutableArtistCatalog = (MutableArtistCatalog)it.getValue();
                    Intrinsics.checkNotNull((Object)audioItem);
                    if (!mutableArtistCatalog.containsAudioItem(audioItem)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private static final boolean addAudioItems$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final MutableArtistCatalog addAudioItems$lambda$0$2(ArtistCatalogRegistry this$0, List $catalogsBeforeUpdate, ReactiveAudioItem audioItem) {
        Map map = this$0.getEntitiesById();
        Intrinsics.checkNotNull((Object)audioItem);
        MutableArtistCatalog mutableArtistCatalog = map.merge(this$0.artistUniqueId(audioItem), new MutableArtistCatalog<ReactiveAudioItem>(audioItem), (arg_0, arg_1) -> ArtistCatalogRegistry.addAudioItems$lambda$0$2$1((arg_0, arg_1) -> ArtistCatalogRegistry.addAudioItems$lambda$0$2$0(audioItem, $catalogsBeforeUpdate, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)mutableArtistCatalog);
        return mutableArtistCatalog;
    }

    private static final MutableArtistCatalog addAudioItems$lambda$0$2$0(ReactiveAudioItem $audioItem, List $catalogsBeforeUpdate, MutableArtistCatalog artistCatalog, MutableArtistCatalog mutableArtistCatalog) {
        MutableArtistCatalog mutableArtistCatalog2;
        Intrinsics.checkNotNullParameter((Object)artistCatalog, (String)"artistCatalog");
        Intrinsics.checkNotNullParameter((Object)mutableArtistCatalog, (String)"<unused var>");
        Intrinsics.checkNotNull((Object)$audioItem);
        artistCatalog.addAudioItem($audioItem);
        MutableArtistCatalog it = mutableArtistCatalog2 = artistCatalog;
        boolean bl = false;
        $catalogsBeforeUpdate.add(it);
        return mutableArtistCatalog2;
    }

    private static final MutableArtistCatalog addAudioItems$lambda$0$2$1(Function2 $tmp0, Object p0, Object p1) {
        return (MutableArtistCatalog)$tmp0.invoke(p0, p1);
    }

    private static final MutableArtistCatalog addAudioItems$lambda$0$3(Function1 $tmp0, Object p0) {
        return (MutableArtistCatalog)$tmp0.invoke(p0);
    }

    private static final boolean addAudioItems$lambda$0$4(MutableArtistCatalog it) {
        return it.getSize() == 1;
    }

    private static final boolean addAudioItems$lambda$0$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object addAudioItems$lambda$0$6$0(List $createdCatalogs) {
        return $createdCatalogs.size() + " artist catalogs were created";
    }

    private static final Object addAudioItems$lambda$0$7$0(List $updatedCatalogs) {
        return $updatedCatalogs.size() + " artist catalogs were updated";
    }

    private static final Object updateCatalog$lambda$0$1(ReactiveAudioItem $updatedAudioItem) {
        return "Artist catalog of " + $updatedAudioItem.getArtist().getName() + " was updated as a result of updating " + $updatedAudioItem;
    }

    private static final Object removeAudioItems$lambda$0$1(ArtistCatalogRegistry this$0, List $removedCatalogs, Collection $audioItems) {
        return "Artist catalogs of " + this$0.toArtistNames($removedCatalogs) + " were deleted as a result of removing " + $audioItems + " from them";
    }

    private static final Object removeAudioItems$lambda$0$2(Collection $audioItems, ArtistCatalogRegistry this$0, List $updatedCatalogs) {
        return "Audio items " + $audioItems + " were removed from artist catalogs of " + this$0.toArtistNames($updatedCatalogs);
    }

    private static final ArtistView getArtistView$lambda$0(Function1 $tmp0, Object p0) {
        return (ArtistView)$tmp0.invoke(p0);
    }
}

