/*
 * Decompiled with CFR 0.152.
 */
package net.transgressoft.commons.music.audio;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import net.transgressoft.commons.music.audio.ReactiveAudioItem;
import net.transgressoft.commons.music.audio.ReactiveAudioItemKt;
import net.transgressoft.commons.persistence.json.TransEntityPolymorphicSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lnet/transgressoft/commons/music/audio/AudioItemSerializerBase;", "I", "Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;", "Lnet/transgressoft/commons/persistence/json/TransEntityPolymorphicSerializer;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "getPropertiesList", "", "", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;)V", "music-commons-core"})
@SourceDebugExtension(value={"SMAP\nAudioItemSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioItemSerializer.kt\nnet/transgressoft/commons/music/audio/AudioItemSerializerBase\n+ 2 SerialDescriptors.kt\nkotlinx/serialization/descriptors/SerialDescriptorsKt\n*L\n1#1,197:1\n347#2,8:198\n347#2,8:206\n*S KotlinDebug\n*F\n+ 1 AudioItemSerializer.kt\nnet/transgressoft/commons/music/audio/AudioItemSerializerBase\n*L\n112#1:198,8\n113#1:206,8\n*E\n"})
public abstract class AudioItemSerializerBase<I extends ReactiveAudioItem<I>>
implements TransEntityPolymorphicSerializer<I> {
    @NotNull
    private final SerialDescriptor descriptor = SerialDescriptorsKt.buildClassSerialDescriptor((String)"AudioItem", (SerialDescriptor[])new SerialDescriptor[0], AudioItemSerializerBase::descriptor$lambda$0);

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public List<Object> getPropertiesList(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        List propertiesList = new ArrayList();
        JsonDecoder jsonDecoder = decoder instanceof JsonDecoder ? (JsonDecoder)decoder : null;
        if (jsonDecoder == null) {
            throw new SerializationException("This class can be saved only by Json");
        }
        JsonDecoder jsonInput = jsonDecoder;
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)jsonInput.decodeJsonElement());
        JsonElement jsonElement = (JsonElement)jsonObject.get((Object)"path");
        if (jsonElement == null) {
            throw new SerializationException("Serialized AudioItem should contain path element");
        }
        JsonElement path = jsonElement;
        Path path2 = Paths.get(JsonElementKt.getJsonPrimitive((JsonElement)path).getContent(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        propertiesList.add(path2);
        JsonElement jsonElement2 = (JsonElement)jsonObject.get((Object)"id");
        if (jsonElement2 == null) {
            throw new SerializationException("Serialized AudioItem should contain id element");
        }
        JsonElement id = jsonElement2;
        propertiesList.add(JsonElementKt.getInt((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)id)));
        JsonElement jsonElement3 = (JsonElement)jsonObject.get((Object)"title");
        if (jsonElement3 == null) {
            throw new SerializationException("Serialized AudioItem should contain title element");
        }
        JsonElement title = jsonElement3;
        propertiesList.add(JsonElementKt.getJsonPrimitive((JsonElement)title).getContent());
        JsonElement jsonElement4 = (JsonElement)jsonObject.get((Object)"duration");
        if (jsonElement4 == null) {
            throw new SerializationException("Serialized AudioItem should contain duration element");
        }
        JsonElement duration = jsonElement4;
        propertiesList.add(Duration.ofSeconds(JsonElementKt.getLong((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)duration))));
        JsonElement jsonElement5 = (JsonElement)jsonObject.get((Object)"bitRate");
        if (jsonElement5 == null) {
            throw new SerializationException("Serialized AudioItem should contain bitRate element");
        }
        JsonElement bitRate = jsonElement5;
        propertiesList.add(JsonElementKt.getInt((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)bitRate)));
        JsonElement jsonElement6 = (JsonElement)jsonObject.get((Object)"artist");
        if (jsonElement6 == null || (jsonElement6 = JsonElementKt.getJsonObject((JsonElement)jsonElement6)) == null) {
            throw new SerializationException("Serialized AudioItem should contain artist element");
        }
        JsonElement artist = jsonElement6;
        JsonElement jsonElement7 = (JsonElement)artist.get((Object)"name");
        if (jsonElement7 == null) {
            throw new SerializationException("Serialized AudioItem should contain artist.name element");
        }
        JsonElement artistName = jsonElement7;
        propertiesList.add(JsonElementKt.getJsonPrimitive((JsonElement)artistName).getContent());
        JsonElement jsonElement8 = (JsonElement)artist.get((Object)"countryCode");
        if (jsonElement8 == null) {
            throw new SerializationException("Serialized AudioItem should contain artist.countryCode element");
        }
        JsonElement countryCode = jsonElement8;
        propertiesList.add(JsonElementKt.getJsonPrimitive((JsonElement)countryCode).getContent());
        JsonElement jsonElement9 = (JsonElement)jsonObject.get((Object)"album");
        if (jsonElement9 == null || (jsonElement9 = JsonElementKt.getJsonObject((JsonElement)jsonElement9)) == null) {
            throw new SerializationException("Serialized AudioItem should contain album element");
        }
        JsonElement album = jsonElement9;
        JsonElement jsonElement10 = (JsonElement)album.get((Object)"name");
        if (jsonElement10 == null) {
            throw new SerializationException("Serialized AudioItem should contain album.name element");
        }
        JsonElement albumName = jsonElement10;
        propertiesList.add(JsonElementKt.getJsonPrimitive((JsonElement)albumName).getContent());
        JsonElement jsonElement11 = (JsonElement)album.get((Object)"albumArtist");
        if (jsonElement11 == null || (jsonElement11 = JsonElementKt.getJsonObject((JsonElement)jsonElement11)) == null) {
            throw new SerializationException("Serialized AudioItem should contain album.albumArtist element");
        }
        JsonElement albumArtist = jsonElement11;
        JsonElement jsonElement12 = (JsonElement)albumArtist.get((Object)"name");
        if (jsonElement12 == null) {
            throw new SerializationException("Serialized AudioItem should contain album.albumArtist.name element");
        }
        JsonElement albumArtistName = jsonElement12;
        propertiesList.add(JsonElementKt.getJsonPrimitive((JsonElement)albumArtistName).getContent());
        JsonElement jsonElement13 = (JsonElement)album.get((Object)"isCompilation");
        if (jsonElement13 == null) {
            throw new SerializationException("Serialized AudioItem should contain album.isCompilation element");
        }
        JsonElement isCompilation = jsonElement13;
        propertiesList.add(JsonElementKt.getBoolean((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)isCompilation)));
        Object object = (JsonElement)album.get((Object)"year");
        propertiesList.add(object != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getIntOrNull((JsonPrimitive)object)) != null ? Short.valueOf((short)((Integer)object).intValue()) : null);
        JsonElement jsonElement14 = (JsonElement)album.get((Object)"label");
        if (jsonElement14 == null || (jsonElement14 = JsonElementKt.getJsonObject((JsonElement)jsonElement14)) == null) {
            throw new SerializationException("Serialized AudioItem should contain album.label element");
        }
        JsonElement label = jsonElement14;
        JsonElement jsonElement15 = (JsonElement)label.get((Object)"name");
        if (jsonElement15 == null) {
            throw new SerializationException("Serialized AudioItem should contain album.label.name element");
        }
        JsonElement labelName = jsonElement15;
        propertiesList.add(JsonElementKt.getJsonPrimitive((JsonElement)labelName).getContent());
        JsonElement jsonElement16 = (JsonElement)jsonObject.get((Object)"genre");
        if (jsonElement16 == null) {
            throw new SerializationException("Serialized AudioItem should contain genre element");
        }
        JsonElement genre = jsonElement16;
        propertiesList.add(JsonElementKt.getJsonPrimitive((JsonElement)genre).getContent());
        JsonElement jsonElement17 = (JsonElement)jsonObject.get((Object)"comments");
        propertiesList.add(jsonElement17 != null && (jsonElement17 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement17)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement17) : null);
        Object object2 = (JsonElement)jsonObject.get((Object)"trackNumber");
        propertiesList.add(object2 != null && (object2 = JsonElementKt.getJsonPrimitive((JsonElement)object2)) != null && (object2 = JsonElementKt.getIntOrNull((JsonPrimitive)object2)) != null ? Short.valueOf((short)((Integer)object2).intValue()) : null);
        Object object3 = (JsonElement)jsonObject.get((Object)"discNumber");
        propertiesList.add(object3 != null && (object3 = JsonElementKt.getJsonPrimitive((JsonElement)object3)) != null && (object3 = JsonElementKt.getIntOrNull((JsonPrimitive)object3)) != null ? Short.valueOf((short)((Integer)object3).intValue()) : null);
        JsonElement jsonElement18 = (JsonElement)jsonObject.get((Object)"bpm");
        propertiesList.add(jsonElement18 != null && (jsonElement18 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement18)) != null ? JsonElementKt.getFloatOrNull((JsonPrimitive)jsonElement18) : null);
        JsonElement jsonElement19 = (JsonElement)jsonObject.get((Object)"encoder");
        propertiesList.add(jsonElement19 != null && (jsonElement19 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement19)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement19) : null);
        JsonElement jsonElement20 = (JsonElement)jsonObject.get((Object)"encoding");
        propertiesList.add(jsonElement20 != null && (jsonElement20 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement20)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement20) : null);
        JsonElement jsonElement21 = (JsonElement)jsonObject.get((Object)"dateOfCreation");
        if (jsonElement21 == null) {
            throw new SerializationException("Serialized AudioItem should contain dateOfCreation element");
        }
        JsonElement dateOfCreation = jsonElement21;
        propertiesList.add(LocalDateTime.ofEpochSecond(JsonElementKt.getLong((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)dateOfCreation)), 0, ZoneOffset.UTC));
        JsonElement jsonElement22 = (JsonElement)jsonObject.get((Object)"lastDateModified");
        if (jsonElement22 == null) {
            throw new SerializationException("Serialized AudioItem should contain lastDateModified element");
        }
        JsonElement lastDateModified = jsonElement22;
        propertiesList.add(LocalDateTime.ofEpochSecond(JsonElementKt.getLong((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)lastDateModified)), 0, ZoneOffset.UTC));
        JsonElement jsonElement23 = (JsonElement)jsonObject.get((Object)"playCount");
        propertiesList.add(jsonElement23 != null && (jsonElement23 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement23)) != null ? Short.valueOf((short)JsonElementKt.getInt((JsonPrimitive)jsonElement23)) : null);
        return propertiesList;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull I value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        JsonEncoder jsonEncoder = encoder instanceof JsonEncoder ? (JsonEncoder)encoder : null;
        if (jsonEncoder == null) {
            throw new SerializationException("This class can be saved only by Json");
        }
        JsonEncoder jsonOutput = jsonEncoder;
        jsonOutput.encodeJsonElement((JsonElement)ReactiveAudioItemKt.toJsonObject(value));
    }

    private static final Unit descriptor$lambda$0(ClassSerialDescriptorBuilder $this$buildClassSerialDescriptor) {
        ClassSerialDescriptorBuilder $this$element_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)$this$buildClassSerialDescriptor, (String)"$this$buildClassSerialDescriptor");
        ClassSerialDescriptorBuilder classSerialDescriptorBuilder = $this$buildClassSerialDescriptor;
        String elementName$iv = "id";
        List annotations$iv = CollectionsKt.emptyList();
        boolean isOptional$iv = false;
        boolean $i$f$element = false;
        SerialDescriptor descriptor$iv = StringSerializer.INSTANCE.getDescriptor();
        $this$element_u24default$iv.element(elementName$iv, descriptor$iv, annotations$iv, isOptional$iv);
        $this$element_u24default$iv = $this$buildClassSerialDescriptor;
        elementName$iv = "path";
        annotations$iv = CollectionsKt.emptyList();
        isOptional$iv = false;
        $i$f$element = false;
        descriptor$iv = StringSerializer.INSTANCE.getDescriptor();
        $this$element_u24default$iv.element(elementName$iv, descriptor$iv, annotations$iv, isOptional$iv);
        return Unit.INSTANCE;
    }
}

