/*
 * Decompiled with CFR 0.152.
 */
package net.transgressoft.commons.music.audio;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import net.transgressoft.commons.entity.IdentifiableEntity;
import net.transgressoft.commons.event.EventType;
import net.transgressoft.commons.event.StandardCrudEvent;
import net.transgressoft.commons.event.TransEvent;
import net.transgressoft.commons.music.audio.AudioItem;
import net.transgressoft.commons.music.audio.AudioLibraryBase;
import net.transgressoft.commons.music.audio.MutableAudioItem;
import net.transgressoft.commons.music.audio.ReactiveAudioItem;
import net.transgressoft.commons.music.player.event.AudioItemPlayerEvent;
import net.transgressoft.commons.persistence.Repository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/transgressoft/commons/music/audio/DefaultAudioLibrary;", "Lnet/transgressoft/commons/music/audio/AudioLibraryBase;", "Lnet/transgressoft/commons/music/audio/AudioItem;", "repository", "Lnet/transgressoft/commons/persistence/Repository;", "", "<init>", "(Lnet/transgressoft/commons/persistence/Repository;)V", "logger", "Lmu/KLogger;", "createFromFile", "audioItemPath", "Ljava/nio/file/Path;", "toString", "", "music-commons-core"})
public final class DefaultAudioLibrary
extends AudioLibraryBase<AudioItem> {
    @NotNull
    private final KLogger logger;

    public DefaultAudioLibrary(@NotNull Repository<Integer, ? super AudioItem> repository) {
        Intrinsics.checkNotNullParameter(repository, (String)"repository");
        super(repository);
        this.logger = KotlinLogging.INSTANCE.logger(DefaultAudioLibrary::logger$lambda$0);
        EventType[] eventTypeArray = new EventType[]{AudioItemPlayerEvent.Type.PLAYED};
        this.getPlayerSubscriber().addOnNextEventAction(eventTypeArray, arg_0 -> DefaultAudioLibrary._init_$lambda$0(this, repository, arg_0));
    }

    @NotNull
    public AudioItem createFromFile(@NotNull Path audioItemPath) {
        MutableAudioItem mutableAudioItem;
        Intrinsics.checkNotNullParameter((Object)audioItemPath, (String)"audioItemPath");
        MutableAudioItem audioItem = mutableAudioItem = new MutableAudioItem(audioItemPath, this.newId());
        boolean bl = false;
        this.add((ReactiveAudioItem)audioItem);
        this.logger.debug(() -> DefaultAudioLibrary.createFromFile$lambda$0$0(audioItemPath, audioItem));
        return mutableAudioItem;
    }

    @NotNull
    public String toString() {
        return "AudioItemJsonRepository(audioItemsCount=" + this.size() + ")";
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$0(DefaultAudioLibrary this$0, Repository $repository, AudioItemPlayerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ReactiveAudioItem audioItem = (ReactiveAudioItem)CollectionsKt.first((Iterable)event.getEntities().values());
        this$0.logger.info(() -> DefaultAudioLibrary.lambda$0$0(audioItem));
        if (audioItem instanceof MutableAudioItem) {
            MutableAudioItem audioItemClone = ((MutableAudioItem)audioItem).clone();
            ((MutableAudioItem)audioItem).incrementPlayCount$music_commons_core();
            $repository.emitAsync((TransEvent)new StandardCrudEvent.Update((IdentifiableEntity)audioItem, (IdentifiableEntity)audioItemClone));
            this$0.logger.debug(() -> DefaultAudioLibrary.lambda$0$1(audioItem));
        }
    }

    private static final Object lambda$0$0(ReactiveAudioItem $audioItem) {
        return "Audio item with id " + $audioItem.getId() + " was played";
    }

    private static final Object lambda$0$1(ReactiveAudioItem $audioItem) {
        return "Play count for audio item " + ((MutableAudioItem)$audioItem).getId() + " increased to " + ((MutableAudioItem)$audioItem).getPlayCount();
    }

    private static final Object createFromFile$lambda$0$0(Path $audioItemPath, MutableAudioItem $audioItem) {
        return "New AudioItem was created from file " + $audioItemPath + " with id " + $audioItem.getId();
    }
}

