/*
 * Decompiled with CFR 0.152.
 */
package net.transgressoft.commons.music.audio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import net.transgressoft.commons.entity.IdentifiableEntity;
import net.transgressoft.commons.music.AudioUtils;
import net.transgressoft.commons.music.audio.AlbumView;
import net.transgressoft.commons.music.audio.Artist;
import net.transgressoft.commons.music.audio.ArtistView;
import net.transgressoft.commons.music.audio.ImmutableArtistKt;
import net.transgressoft.commons.music.audio.ReactiveAudioItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\b\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0013\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\u001c2\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u0010#\u001a\u00020\u0004J\u0013\u0010$\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\nJ\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\b\u0010*\u001a\u00020\u0004H\u0016J\t\u0010+\u001a\u00020\u0006H\u00c6\u0003J\u0019\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010-\u001a\u00020\u001c2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001d\u00a8\u00061"}, d2={"Lnet/transgressoft/commons/music/audio/MutableArtistCatalog;", "I", "Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;", "Lnet/transgressoft/commons/entity/IdentifiableEntity;", "", "artist", "Lnet/transgressoft/commons/music/audio/Artist;", "<init>", "(Lnet/transgressoft/commons/music/audio/Artist;)V", "audioItem", "(Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;)V", "getArtist", "()Lnet/transgressoft/commons/music/audio/Artist;", "logger", "Lmu/KLogger;", "albums", "", "Ljava/util/SortedSet;", "id", "getId", "()Ljava/lang/String;", "uniqueId", "getUniqueId", "size", "", "getSize", "()I", "isEmpty", "", "()Z", "addAudioItem", "(Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;)Z", "removeAudioItem", "findAlbumAudioItems", "", "albumName", "containsAudioItem", "mergeAudioItem", "", "getArtistView", "Lnet/transgressoft/commons/music/audio/ArtistView;", "clone", "toString", "component1", "copy", "equals", "other", "", "hashCode", "music-commons-core"})
@SourceDebugExtension(value={"SMAP\nMutableArtistCatalog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableArtistCatalog.kt\nnet/transgressoft/commons/music/audio/MutableArtistCatalog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1#2:112\n382#3,7:113\n1563#4:120\n1634#4,3:121\n*S KotlinDebug\n*F\n+ 1 MutableArtistCatalog.kt\nnet/transgressoft/commons/music/audio/MutableArtistCatalog\n*L\n62#1:113,7\n104#1:120\n104#1:121,3\n*E\n"})
public final class MutableArtistCatalog<I extends ReactiveAudioItem<I>>
implements IdentifiableEntity<String> {
    @NotNull
    private final Artist artist;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Map<String, SortedSet<I>> albums;
    @NotNull
    private final String id;
    @NotNull
    private final String uniqueId;

    public MutableArtistCatalog(@NotNull Artist artist) {
        Intrinsics.checkNotNullParameter((Object)artist, (String)"artist");
        this.artist = artist;
        this.logger = KotlinLogging.INSTANCE.logger(MutableArtistCatalog::logger$lambda$0);
        Map map = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.albums = map;
        this.logger.debug(() -> MutableArtistCatalog._init_$lambda$0(this));
        this.id = this.artist.getName() + "-" + this.artist.getCountryCode().name();
        this.uniqueId = this.artist.getName() + "-" + this.artist.getCountryCode().name();
    }

    @NotNull
    public final Artist getArtist() {
        return this.artist;
    }

    public MutableArtistCatalog(@NotNull I audioItem) {
        Intrinsics.checkNotNullParameter(audioItem, (String)"audioItem");
        this(audioItem.getArtist());
        this.addAudioItem(audioItem);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getUniqueId() {
        return this.uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int getSize() {
        int n;
        Map<String, SortedSet<I>> map = this.albums;
        synchronized (map) {
            boolean bl = false;
            Iterable iterable = this.albums.values();
            int n2 = 0;
            for (Object t : iterable) {
                void it;
                SortedSet sortedSet = (SortedSet)t;
                int n3 = n2;
                boolean bl2 = false;
                int n4 = it.size();
                n2 = n3 + n4;
            }
            n = n2;
        }
        return n;
    }

    public final boolean isEmpty() {
        return this.albums.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean addAudioItem(@NotNull I audioItem) {
        Intrinsics.checkNotNullParameter(audioItem, (String)"audioItem");
        Map<String, SortedSet<I>> map = this.albums;
        synchronized (map) {
            SortedSet audioItems;
            boolean added;
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map<String, SortedSet<I>> map2 = this.albums;
            String key$iv = audioItem.getAlbum().getName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                SortedSet answer$iv = SetsKt.sortedSetOf(AudioUtils.INSTANCE.audioItemTrackDiscNumberComparator(), (Object[])new ReactiveAudioItem[0]);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if (added = (audioItems = (SortedSet)object).add(audioItem)) {
                this.logger.debug(() -> MutableArtistCatalog.addAudioItem$lambda$0$1(audioItem));
            }
            boolean bl3 = audioItems.size() > 1;
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeAudioItem(@NotNull I audioItem) {
        Intrinsics.checkNotNullParameter(audioItem, (String)"audioItem");
        Map<String, SortedSet<I>> map = this.albums;
        synchronized (map) {
            SortedSet<I> sortedSet;
            String albumName;
            block7: {
                boolean bl = false;
                albumName = audioItem.getAlbum().getName();
                if (this.albums.get(albumName) != null) break block7;
                boolean bl2 = false;
                return bl2;
            }
            SortedSet<I> audioItems = sortedSet;
            boolean removed = audioItems.removeIf(arg_0 -> MutableArtistCatalog.removeAudioItem$lambda$0$1(arg_0 -> MutableArtistCatalog.removeAudioItem$lambda$0$0(audioItem, arg_0), arg_0));
            if (removed) {
                if (audioItems.isEmpty()) {
                    this.albums.remove(albumName);
                    this.logger.debug(() -> MutableArtistCatalog.removeAudioItem$lambda$0$2(audioItem, this));
                } else {
                    this.logger.debug(() -> MutableArtistCatalog.removeAudioItem$lambda$0$3(audioItem));
                }
            }
            boolean bl = removed;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<I> findAlbumAudioItems(@NotNull String albumName) {
        Set<Object> set;
        Intrinsics.checkNotNullParameter((Object)albumName, (String)"albumName");
        Map<String, SortedSet<I>> map = this.albums;
        synchronized (map) {
            boolean bl = false;
            Set<Object> set2 = this.albums.get(albumName);
            if (set2 == null || (set2 = CollectionsKt.toSet((Iterable)set2)) == null) {
                set2 = SetsKt.emptySet();
            }
            set = set2;
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsAudioItem(@NotNull I audioItem) {
        boolean bl;
        Intrinsics.checkNotNullParameter(audioItem, (String)"audioItem");
        Map<String, SortedSet<I>> map = this.albums;
        synchronized (map) {
            boolean bl2 = false;
            SortedSet<I> sortedSet = this.albums.get(audioItem.getAlbum().getName());
            bl = sortedSet != null ? sortedSet.contains(audioItem) : false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mergeAudioItem(@NotNull I audioItem) {
        Intrinsics.checkNotNullParameter(audioItem, (String)"audioItem");
        Map<String, SortedSet<I>> map = this.albums;
        synchronized (map) {
            boolean bl = false;
            this.removeAudioItem(audioItem);
            boolean bl2 = this.addAudioItem(audioItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ArtistView<I> getArtistView() {
        ArtistView artistView;
        Map<String, SortedSet<I>> map = this.albums;
        synchronized (map) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.albums.entrySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new AlbumView((String)it.getKey(), CollectionsKt.toSet((Iterable)((Iterable)it.getValue()))));
            }
            Set it = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            boolean bl3 = false;
            artistView = new ArtistView(this.artist, it);
        }
        return artistView;
    }

    @NotNull
    public MutableArtistCatalog<I> clone() {
        return MutableArtistCatalog.copy$default(this, null, 1, null);
    }

    @NotNull
    public String toString() {
        return "MutableArtistCatalog(artist=" + this.artist + ", size=" + this.getSize() + ")";
    }

    @NotNull
    public final Artist component1() {
        return this.artist;
    }

    @NotNull
    public final MutableArtistCatalog<I> copy(@NotNull Artist artist) {
        Intrinsics.checkNotNullParameter((Object)artist, (String)"artist");
        return new MutableArtistCatalog<I>(artist);
    }

    public static /* synthetic */ MutableArtistCatalog copy$default(MutableArtistCatalog mutableArtistCatalog, Artist artist, int n, Object object) {
        if ((n & 1) != 0) {
            artist = mutableArtistCatalog.artist;
        }
        return mutableArtistCatalog.copy(artist);
    }

    public int hashCode() {
        return this.artist.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MutableArtistCatalog)) {
            return false;
        }
        MutableArtistCatalog mutableArtistCatalog = (MutableArtistCatalog)other;
        return Intrinsics.areEqual((Object)this.artist, (Object)mutableArtistCatalog.artist);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object _init_$lambda$0(MutableArtistCatalog this$0) {
        return "Artist catalog created for " + ImmutableArtistKt.id(this$0.artist);
    }

    private static final Object addAudioItem$lambda$0$1(ReactiveAudioItem $audioItem) {
        return "AudioItem " + $audioItem + " was added to album " + $audioItem.getAlbum();
    }

    private static final boolean removeAudioItem$lambda$0$0(ReactiveAudioItem $audioItem, ReactiveAudioItem it) {
        return ((Number)((Object)it.getId())).intValue() == ((Number)((Object)$audioItem.getId())).intValue();
    }

    private static final boolean removeAudioItem$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object removeAudioItem$lambda$0$2(ReactiveAudioItem $audioItem, MutableArtistCatalog this$0) {
        return "Album " + $audioItem.getAlbum() + " was removed from artist catalog of " + this$0.artist;
    }

    private static final Object removeAudioItem$lambda$0$3(ReactiveAudioItem $audioItem) {
        return "AudioItem " + $audioItem + " was removed from album " + $audioItem.getAlbum();
    }
}

