/*
 * Decompiled with CFR 0.152.
 */
package net.transgressoft.commons.music.audio;

import com.neovisionaries.i18n.CountryCode;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.Transient;
import mu.KLogger;
import mu.KotlinLogging;
import net.transgressoft.commons.entity.ReactiveEntityBase;
import net.transgressoft.commons.music.AudioUtils;
import net.transgressoft.commons.music.audio.Album;
import net.transgressoft.commons.music.audio.Artist;
import net.transgressoft.commons.music.audio.AudioFileType;
import net.transgressoft.commons.music.audio.AudioItem;
import net.transgressoft.commons.music.audio.AudioItemManipulationException;
import net.transgressoft.commons.music.audio.AudioItemSerializer;
import net.transgressoft.commons.music.audio.Genre;
import net.transgressoft.commons.music.audio.ImmutableAlbum;
import net.transgressoft.commons.music.audio.ImmutableArtist;
import net.transgressoft.commons.music.audio.ImmutableLabel;
import net.transgressoft.commons.music.audio.Label;
import net.transgressoft.commons.music.audio.MutableAudioItem;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.wav.WavOptions;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.wav.WavInfoTag;
import org.jaudiotagger.tag.wav.WavTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.base.Objects;

@Serializable(with=AudioItemSerializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b*\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00ae\u00012\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003:\u0002\u00ae\u0001B\u0019\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\u000bB\u009d\u0001\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0004\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u001e\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u0006\u0010!\u001a\u00020 \u0012\u0006\u0010\"\u001a\u00020\u0019\u00a2\u0006\u0004\b\b\u0010#J\u001d\u0010\u0094\u0001\u001a\u0004\u0018\u00010\r2\u0006\u00105\u001a\u0002062\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0002J\u0011\u0010\u0097\u0001\u001a\u00020\u00122\u0006\u00105\u001a\u000206H\u0002J\u001a\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0006\u00105\u001a\u0002062\u0006\u0010Z\u001a\u00020\rH\u0002J\u0010\u0010:\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0002J\f\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u008d\u0001H\u0002J\u0014\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u008d\u00012\u0006\u00105\u001a\u000206H\u0002J\n\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0016J\u0012\u0010\u009d\u0001\u001a\u0002062\u0007\u0010\u009e\u0001\u001a\u00020\rH\u0002J\u0012\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\u0006\u00105\u001a\u000206H\u0002J\u0014\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\b\u0010\u00a3\u0001\u001a\u00030\u008d\u0001H\u0002J\u000f\u0010\u00a4\u0001\u001a\u00020\u0019H\u0000\u00a2\u0006\u0003\b\u00a5\u0001J\u0013\u0010\u00a6\u0001\u001a\u00020\u00042\u0007\u0010\u00a7\u0001\u001a\u00020\u0001H\u0096\u0002J\u0017\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\n\u0010\u00a7\u0001\u001a\u0005\u0018\u00010\u00aa\u0001H\u0096\u0002J\t\u0010\u00ab\u0001\u001a\u00020\u0004H\u0016J\t\u0010\u00ac\u0001\u001a\u00020\u0000H\u0016J\t\u0010\u00ad\u0001\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020)8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010.\u001a\n 0*\u0004\u0018\u00010/0/8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b1\u0010+R\u001e\u00102\u001a\n 0*\u0004\u0018\u000103038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b4\u0010+R\u0016\u00105\u001a\u0002068\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b7\u0010+R\u000e\u00108\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u00020\u00048\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b9\u0010+\u001a\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u00020\u000f8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b=\u0010+\u001a\u0004\b>\u0010?R\u0010\u0010@\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0004\u0018\u00010\r8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bA\u0010+\u001a\u0004\bB\u0010CR\u0010\u0010D\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u0004\u0018\u00010\r8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bE\u0010+\u001a\u0004\bF\u0010CR\u000e\u0010G\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u00020 8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bH\u0010+\u001a\u0004\bI\u0010JR,\u0010!\u001a\u00020 2\u0006\u0010K\u001a\u00020 8\u0016@TX\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bL\u0010+\u001a\u0004\bM\u0010J\"\u0004\bN\u0010OR\u001e\u0010P\u001a\u00020\u00192\u0006\u0010K\u001a\u00020\u0019@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bQ\u0010RR\u001a\u0010\"\u001a\u00020\u00198VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\bS\u0010+\u001a\u0004\bT\u0010UR\u001b\u0010V\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bX\u0010Y\u001a\u0004\bW\u0010CR\u001b\u0010Z\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u0010Y\u001a\u0004\b[\u0010CR\u001a\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00120^8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010`R\u001b\u0010a\u001a\u00020b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\be\u0010Y\u001a\u0004\bc\u0010dR\u0014\u0010f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bg\u0010CR,\u0010\f\u001a\u00020\r2\u0006\u0010K\u001a\u00020\r8\u0016@VX\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bh\u0010+\u001a\u0004\bi\u0010C\"\u0004\bj\u0010kR,\u0010\u0011\u001a\u00020\u00122\u0006\u0010K\u001a\u00020\u00128\u0016@VX\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bl\u0010+\u001a\u0004\bm\u0010n\"\u0004\bo\u0010pR,\u0010\u0015\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\u00168\u0016@VX\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bq\u0010+\u001a\u0004\br\u0010s\"\u0004\bt\u0010uR0\u0010\u0017\u001a\u0004\u0018\u00010\r2\b\u0010K\u001a\u0004\u0018\u00010\r8\u0016@VX\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bv\u0010+\u001a\u0004\bw\u0010C\"\u0004\bx\u0010kR2\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010K\u001a\u0004\u0018\u00010\u00198\u0016@VX\u0097\u000e\u00a2\u0006\u0016\n\u0002\u0010~\u0012\u0004\by\u0010+\u001a\u0004\bz\u0010{\"\u0004\b|\u0010}R4\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010K\u001a\u0004\u0018\u00010\u00198\u0016@VX\u0097\u000e\u00a2\u0006\u0018\n\u0002\u0010~\u0012\u0004\b\u007f\u0010+\u001a\u0005\b\u0080\u0001\u0010{\"\u0005\b\u0081\u0001\u0010}R8\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010K\u001a\u0004\u0018\u00010\u001c8\u0016@VX\u0097\u000e\u00a2\u0006\u001c\n\u0003\u0010\u0087\u0001\u0012\u0005\b\u0082\u0001\u0010+\u001a\u0006\b\u0083\u0001\u0010\u0084\u0001\"\u0006\b\u0085\u0001\u0010\u0086\u0001R1\u0010\u0013\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u00148\u0016@VX\u0097\u000e\u00a2\u0006\u0019\n\u0000\u0012\u0005\b\u0088\u0001\u0010+\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001\"\u0006\b\u008b\u0001\u0010\u008c\u0001R8\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008d\u00012\t\u0010K\u001a\u0005\u0018\u00010\u008d\u00018V@VX\u0097\u000e\u00a2\u0006\u0019\n\u0000\u0012\u0005\b\u008f\u0001\u0010+\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001\"\u0006\b\u0092\u0001\u0010\u0093\u0001\u00a8\u0006\u00af\u0001"}, d2={"Lnet/transgressoft/commons/music/audio/MutableAudioItem;", "Lnet/transgressoft/commons/music/audio/AudioItem;", "", "Lnet/transgressoft/commons/entity/ReactiveEntityBase;", "", "path", "Ljava/nio/file/Path;", "id", "<init>", "(Ljava/nio/file/Path;I)V", "audioItem", "(Lnet/transgressoft/commons/music/audio/AudioItem;)V", "title", "", "duration", "Ljava/time/Duration;", "bitRate", "artist", "Lnet/transgressoft/commons/music/audio/Artist;", "album", "Lnet/transgressoft/commons/music/audio/Album;", "genre", "Lnet/transgressoft/commons/music/audio/Genre;", "comments", "trackNumber", "", "discNumber", "bpm", "", "encoder", "encoding", "dateOfCreation", "Ljava/time/LocalDateTime;", "lastDateModified", "playCount", "(Ljava/nio/file/Path;ILjava/lang/String;Ljava/time/Duration;ILnet/transgressoft/commons/music/audio/Artist;Lnet/transgressoft/commons/music/audio/Album;Lnet/transgressoft/commons/music/audio/Genre;Ljava/lang/String;Ljava/lang/Short;Ljava/lang/Short;Ljava/lang/Float;Ljava/lang/String;Ljava/lang/String;Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;S)V", "getPath", "()Ljava/nio/file/Path;", "getId", "()Ljava/lang/Integer;", "logger", "Lmu/KLogger;", "getLogger$annotations", "()V", "ioScope", "Lkotlinx/coroutines/CoroutineScope;", "audioFile", "Lorg/jaudiotagger/audio/AudioFile;", "kotlin.jvm.PlatformType", "getAudioFile$annotations", "audioHeader", "Lorg/jaudiotagger/audio/AudioHeader;", "getAudioHeader$annotations", "tag", "Lorg/jaudiotagger/tag/Tag;", "getTag$annotations", "_bitRate", "getBitRate$annotations", "getBitRate", "()I", "_duration", "getDuration$annotations", "getDuration", "()Ljava/time/Duration;", "_encoder", "getEncoder$annotations", "getEncoder", "()Ljava/lang/String;", "_encoding", "getEncoding$annotations", "getEncoding", "_dateOfCreation", "getDateOfCreation$annotations", "getDateOfCreation", "()Ljava/time/LocalDateTime;", "value", "getLastDateModified$annotations", "getLastDateModified", "setLastDateModified", "(Ljava/time/LocalDateTime;)V", "_playCount", "set_playCount", "(S)V", "getPlayCount$annotations", "getPlayCount", "()S", "fileName", "getFileName", "fileName$delegate", "Lkotlin/Lazy;", "extension", "getExtension", "extension$delegate", "artistsInvolved", "", "getArtistsInvolved", "()Ljava/util/Set;", "length", "", "getLength", "()J", "length$delegate", "uniqueId", "getUniqueId", "getTitle$annotations", "getTitle", "setTitle", "(Ljava/lang/String;)V", "getArtist$annotations", "getArtist", "()Lnet/transgressoft/commons/music/audio/Artist;", "setArtist", "(Lnet/transgressoft/commons/music/audio/Artist;)V", "getGenre$annotations", "getGenre", "()Lnet/transgressoft/commons/music/audio/Genre;", "setGenre", "(Lnet/transgressoft/commons/music/audio/Genre;)V", "getComments$annotations", "getComments", "setComments", "getTrackNumber$annotations", "getTrackNumber", "()Ljava/lang/Short;", "setTrackNumber", "(Ljava/lang/Short;)V", "Ljava/lang/Short;", "getDiscNumber$annotations", "getDiscNumber", "setDiscNumber", "getBpm$annotations", "getBpm", "()Ljava/lang/Float;", "setBpm", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "getAlbum$annotations", "getAlbum", "()Lnet/transgressoft/commons/music/audio/Album;", "setAlbum", "(Lnet/transgressoft/commons/music/audio/Album;)V", "", "coverImageBytes", "getCoverImageBytes$annotations", "getCoverImageBytes", "()[B", "setCoverImageBytes", "([B)V", "getFieldIfExisting", "fieldKey", "Lorg/jaudiotagger/tag/FieldKey;", "readArtist", "readAlbum", "Lnet/transgressoft/commons/music/audio/ImmutableAlbum;", "getCoverBytes", "writeMetadata", "Lkotlinx/coroutines/Job;", "createTagTag", "format", "setTrackFieldsToTag", "", "createArtwork", "Lorg/jaudiotagger/tag/images/Artwork;", "coverBytes", "incrementPlayCount", "incrementPlayCount$music_commons_core", "compareTo", "other", "equals", "", "", "hashCode", "clone", "toString", "Companion", "music-commons-core"})
@SourceDebugExtension(value={"SMAP\nMutableAudioItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableAudioItem.kt\nnet/transgressoft/commons/music/audio/MutableAudioItem\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,450:1\n47#2,4:451\n1#3:455\n1563#4:456\n1634#4,3:457\n*S KotlinDebug\n*F\n+ 1 MutableAudioItem.kt\nnet/transgressoft/commons/music/audio/MutableAudioItem\n*L\n85#1:451,4\n192#1:456\n192#1:457,3\n*E\n"})
public final class MutableAudioItem
extends ReactiveEntityBase<Integer, AudioItem>
implements AudioItem,
Comparable<AudioItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    private final int id;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final CoroutineScope ioScope;
    private final AudioFile audioFile;
    private final AudioHeader audioHeader;
    @NotNull
    private final Tag tag;
    private int _bitRate;
    private final int bitRate;
    @NotNull
    private Duration _duration;
    @NotNull
    private final Duration duration;
    @Nullable
    private String _encoder;
    @Nullable
    private final String encoder;
    @Nullable
    private String _encoding;
    @Nullable
    private final String encoding;
    @NotNull
    private LocalDateTime _dateOfCreation;
    @NotNull
    private final LocalDateTime dateOfCreation;
    @NotNull
    private LocalDateTime lastDateModified;
    private short _playCount;
    @NotNull
    private final Lazy fileName$delegate;
    @NotNull
    private final Lazy extension$delegate;
    @NotNull
    private final Lazy length$delegate;
    @NotNull
    private String title;
    @NotNull
    private Artist artist;
    @NotNull
    private Genre genre;
    @Nullable
    private String comments;
    @Nullable
    private Short trackNumber;
    @Nullable
    private Short discNumber;
    @Nullable
    private Float bpm;
    @NotNull
    private Album album;
    @Nullable
    private byte[] coverImageBytes;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public MutableAudioItem(@NotNull Path path, int id) {
        block16: {
            block15: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                super();
                this.path = path;
                this.id = id;
                this.logger = KotlinLogging.INSTANCE.logger((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, logger$lambda$0(), ()Lkotlin/Unit;)());
                $i$f$CoroutineExceptionHandler = false;
                var4_5 /* !! */  = CoroutineExceptionHandler.Key;
                this.ioScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineExceptionHandler(var4_5 /* !! */ , this){
                    final /* synthetic */ MutableAudioItem this$0;
                    {
                        this.this$0 = mutableAudioItem;
                        super((CoroutineContext.Key)$super_call_param$1);
                    }

                    public void handleException(CoroutineContext context, Throwable exception) {
                        Throwable exception2 = exception;
                        boolean bl = false;
                        String errorText = "Error writing metadata of " + this.this$0;
                        MutableAudioItem.access$getLogger$p(this.this$0).error(errorText, exception2);
                    }
                }));
                this.audioFile = AudioFileIO.read((File)this.getPath().toFile());
                this.audioHeader = this.audioFile.getAudioHeader();
                v0 = this.audioFile.getTag();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getTag(...)");
                this.tag = v0;
                if (!Files.exists(this.getPath(), new LinkOption[0])) {
                    $i$a$-require-MutableAudioItem$1 = false;
                    $i$a$-require-MutableAudioItem$1 = "File '" + this.getPath().toAbsolutePath() + "' does not exist";
                    throw new IllegalArgumentException($i$a$-require-MutableAudioItem$1.toString());
                }
                v1 = this.audioHeader;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"audioHeader");
                this.bitRate = this._bitRate = this.getBitRate(v1);
                v2 = Duration.ofSeconds(this.audioHeader.getTrackLength());
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"ofSeconds(...)");
                this.duration = this._duration = v2;
                v3 = this;
                v4 = this.getFieldIfExisting(this.tag, FieldKey.ENCODER);
                if (v4 != null) {
                    var5_8 = $i$a$-require-MutableAudioItem$1 = v4;
                    var9_14 = v3;
                    $i$a$-takeIf-MutableAudioItem$_encoder$1 = false;
                    var10_21 = ((CharSequence)it).length() > 0;
                    v3 = var9_14;
                    v5 = var10_21 ? $i$a$-require-MutableAudioItem$1 : null;
                } else {
                    v5 = null;
                }
                v3._encoder = v5;
                this.encoder = this._encoder;
                $i$a$-require-MutableAudioItem$1 = var3_4 = this.audioHeader.getEncodingType();
                var9_14 = this;
                $i$a$-takeIf-MutableAudioItem$_encoding$1 = false;
                Intrinsics.checkNotNull((Object)it);
                var10_21 = ((CharSequence)it).length() > 0;
                var9_14._encoding = var10_21 != false ? var3_4 : null;
                this.encoding = this._encoding;
                v6 = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"now(...)");
                this.dateOfCreation = this._dateOfCreation = v6;
                this.lastDateModified = this._dateOfCreation;
                this.fileName$delegate = LazyKt.lazy((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fileName_delegate$lambda$0(net.transgressoft.commons.music.audio.MutableAudioItem ), ()Ljava/lang/String;)((MutableAudioItem)this));
                this.extension$delegate = LazyKt.lazy((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, extension_delegate$lambda$0(net.transgressoft.commons.music.audio.MutableAudioItem ), ()Ljava/lang/String;)((MutableAudioItem)this));
                this.length$delegate = LazyKt.lazy((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, length_delegate$lambda$0(net.transgressoft.commons.music.audio.MutableAudioItem ), ()Ljava/lang/Long;)((MutableAudioItem)this));
                v7 = this.getFieldIfExisting(this.tag, FieldKey.TITLE);
                if (v7 == null) {
                    v7 = "";
                }
                this.title = v7;
                this.artist = this.readArtist(this.tag);
                v8 = this;
                v9 = this.getFieldIfExisting(this.tag, FieldKey.GENRE);
                if (v9 == null) break block15;
                $i$a$-takeIf-MutableAudioItem$_encoder$1 = v9;
                var9_14 = v8;
                $i$a$-let-MutableAudioItem$genre$1 = false;
                v10 = Genre.Companion.parseGenre((String)it);
                v8 = var9_14;
                v9 = v10;
                if (v10 != null) break block16;
            }
            v9 = Genre.UNDEFINED;
        }
        v8.genre = v9;
        v11 = this;
        v12 = this.getFieldIfExisting(this.tag, FieldKey.COMMENT);
        if (v12 != null) {
            $i$a$-takeIf-MutableAudioItem$_encoding$1 /* !! */  = var4_5 /* !! */  = v12;
            var9_14 = v11;
            $i$a$-takeIf-MutableAudioItem$comments$1 = false;
            var10_21 = ((CharSequence)it).length() > 0;
            v11 = var9_14;
            v13 /* !! */  = var10_21 ? var4_5 /* !! */  : null;
        } else {
            v13 /* !! */  = null;
        }
        v11.comments = v13 /* !! */ ;
        v14 = this;
        v15 = this.getFieldIfExisting(this.tag, FieldKey.TRACK);
        if (v15 == null) ** GOTO lbl-1000
        $i$a$-takeIf-MutableAudioItem$comments$1 = var5_11 = v15;
        var9_14 = v14;
        $i$a$-takeUnless-MutableAudioItem$trackNumber$1 = 0;
        var10_21 = ((CharSequence)it).length() == 0 & Intrinsics.areEqual((Object)it, (Object)"0");
        v14 = var9_14;
        v15 = var10_21 == false ? var5_11 : null;
        if (v15 != null && (v15 = StringsKt.toShortOrNull((String)v15)) != null) {
            it = v15;
            $i$a$-takeUnless-MutableAudioItem$trackNumber$1 = ((Number)it).shortValue();
            var9_14 = v14;
            $i$a$-takeIf-MutableAudioItem$trackNumber$2 = false;
            var10_21 = it > 0;
            v14 = var9_14;
            v16 = var10_21 ? it : null;
        } else lbl-1000:
        // 2 sources

        {
            v16 = null;
        }
        v14.trackNumber = v16;
        v17 = this;
        v18 = this.getFieldIfExisting(this.tag, FieldKey.DISC_NO);
        if (v18 == null) ** GOTO lbl-1000
        var5_12 = v18;
        it = var5_12;
        var9_14 = v17;
        $i$a$-takeUnless-MutableAudioItem$discNumber$1 = 0;
        var10_21 = ((CharSequence)it).length() == 0 & Intrinsics.areEqual((Object)it, (Object)"0");
        v17 = var9_14;
        v18 = var10_21 == false ? var5_12 : null;
        if (v18 != null && (v18 = StringsKt.toShortOrNull((String)v18)) != null) {
            it = v18;
            $i$a$-takeUnless-MutableAudioItem$discNumber$1 = ((Number)it).shortValue();
            var9_14 = v17;
            $i$a$-takeIf-MutableAudioItem$discNumber$2 = false;
            var10_21 = it > 0;
            v17 = var9_14;
            v19 = var10_21 ? it : null;
        } else lbl-1000:
        // 2 sources

        {
            v19 = null;
        }
        v17.discNumber = v19;
        v20 = this;
        v21 = this.getFieldIfExisting(this.tag, FieldKey.BPM);
        if (v21 == null) ** GOTO lbl-1000
        it = var5_13 = v21;
        var9_14 = v20;
        $i$a$-takeUnless-MutableAudioItem$bpm$1 = false;
        var10_21 = ((CharSequence)it).length() == 0 & Intrinsics.areEqual((Object)it, (Object)"0");
        v20 = var9_14;
        v21 = var10_21 == false ? var5_13 : null;
        if (v21 != null && (v21 = StringsKt.toFloatOrNull((String)v21)) != null) {
            var6_20 = v21;
            $i$a$-takeUnless-MutableAudioItem$bpm$1 = ((Number)var6_20).floatValue();
            var9_14 = v20;
            $i$a$-takeIf-MutableAudioItem$bpm$2 = false;
            var10_21 = it > 0.0f;
            v20 = var9_14;
            v22 = var10_21 ? var6_20 : null;
        } else lbl-1000:
        // 2 sources

        {
            v22 = null;
        }
        v20.bpm = v22;
        this.album = this.readAlbum(this.tag, PathsKt.getExtension((Path)this.getPath()));
        this.coverImageBytes = this.getCoverBytes(this.tag);
    }

    public /* synthetic */ MutableAudioItem(Path path, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(path, n);
    }

    @NotNull
    public Path getPath() {
        return this.path;
    }

    @NotNull
    public Integer getId() {
        return this.id;
    }

    @Transient
    private static /* synthetic */ void getLogger$annotations() {
    }

    public MutableAudioItem(@NotNull AudioItem audioItem) {
        Intrinsics.checkNotNullParameter((Object)audioItem, (String)"audioItem");
        this(audioItem.getPath(), ((Number)((Object)audioItem.getId())).intValue());
    }

    public MutableAudioItem(@NotNull Path path, int id, @NotNull String title, @NotNull Duration duration, int bitRate, @NotNull Artist artist, @NotNull Album album, @NotNull Genre genre, @Nullable String comments, @Nullable Short trackNumber, @Nullable Short discNumber, @Nullable Float bpm, @Nullable String encoder, @Nullable String encoding, @NotNull LocalDateTime dateOfCreation, @NotNull LocalDateTime lastDateModified, short playCount) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)artist, (String)"artist");
        Intrinsics.checkNotNullParameter((Object)album, (String)"album");
        Intrinsics.checkNotNullParameter((Object)genre, (String)"genre");
        Intrinsics.checkNotNullParameter((Object)dateOfCreation, (String)"dateOfCreation");
        Intrinsics.checkNotNullParameter((Object)lastDateModified, (String)"lastDateModified");
        this(path, id);
        this.setTitle(title);
        this._duration = duration;
        this.setArtist(artist);
        this.setGenre(genre);
        this.setComments(comments);
        this.setTrackNumber(trackNumber);
        this.setDiscNumber(discNumber);
        this.setBpm(bpm);
        this.setAlbum(album);
        this._bitRate = bitRate;
        this._encoder = encoder;
        this._encoding = encoding;
        this._dateOfCreation = dateOfCreation;
        this.setLastDateModified(lastDateModified);
        this.set_playCount(playCount);
    }

    @Transient
    private static /* synthetic */ void getAudioFile$annotations() {
    }

    @Transient
    private static /* synthetic */ void getAudioHeader$annotations() {
    }

    @Transient
    private static /* synthetic */ void getTag$annotations() {
    }

    public int getBitRate() {
        return this.bitRate;
    }

    @Serializable
    public static /* synthetic */ void getBitRate$annotations() {
    }

    @NotNull
    public Duration getDuration() {
        return this.duration;
    }

    @Serializable
    public static /* synthetic */ void getDuration$annotations() {
    }

    @Nullable
    public String getEncoder() {
        return this.encoder;
    }

    @Serializable
    public static /* synthetic */ void getEncoder$annotations() {
    }

    @Nullable
    public String getEncoding() {
        return this.encoding;
    }

    @Serializable
    public static /* synthetic */ void getEncoding$annotations() {
    }

    @NotNull
    public LocalDateTime getDateOfCreation() {
        return this.dateOfCreation;
    }

    @Serializable
    public static /* synthetic */ void getDateOfCreation$annotations() {
    }

    @NotNull
    public LocalDateTime getLastDateModified() {
        return this.lastDateModified;
    }

    protected void setLastDateModified(@NotNull LocalDateTime localDateTime) {
        Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"<set-?>");
        this.lastDateModified = localDateTime;
    }

    @Serializable
    public static /* synthetic */ void getLastDateModified$annotations() {
    }

    private final void set_playCount(short value) {
        this.setAndNotify(value, this._playCount, arg_0 -> MutableAudioItem._set__playCount_$lambda$0(this, arg_0));
    }

    public short getPlayCount() {
        return this._playCount;
    }

    @Serializable
    public static /* synthetic */ void getPlayCount$annotations() {
    }

    @NotNull
    public String getFileName() {
        Lazy lazy = this.fileName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String getExtension() {
        Lazy lazy = this.extension$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Artist> getArtistsInvolved() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = AudioUtils.INSTANCE.getArtistsNamesInvolved(this.getTitle(), this.getArtist().getName(), this.getAlbum().getAlbumArtist().getName());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ImmutableArtist.Companion.of$default(ImmutableArtist.Companion, (String)it, null, 2, null));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public long getLength() {
        Lazy lazy = this.length$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @NotNull
    public String getUniqueId() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_uniqueId__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_uniqueId__u24lambda_u240.append(StringsKt.replace$default((String)((Object)this.getPath().getFileName()).toString(), (char)' ', (char)'_', (boolean)false, (int)4, null));
        $this$_get_uniqueId__u24lambda_u240.append("-" + this.getTitle());
        $this$_get_uniqueId__u24lambda_u240.append("-" + this.getDuration().toSeconds());
        $this$_get_uniqueId__u24lambda_u240.append("-" + this.getBitRate());
        return stringBuilder.toString();
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setAndNotify(value, this.title, arg_0 -> MutableAudioItem._set_title_$lambda$0(this, arg_0));
    }

    @Serializable
    public static /* synthetic */ void getTitle$annotations() {
    }

    @NotNull
    public Artist getArtist() {
        return this.artist;
    }

    public void setArtist(@NotNull Artist value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setAndNotify(value, this.artist, arg_0 -> MutableAudioItem._set_artist_$lambda$0(this, arg_0));
    }

    @Serializable
    public static /* synthetic */ void getArtist$annotations() {
    }

    @NotNull
    public Genre getGenre() {
        return this.genre;
    }

    public void setGenre(@NotNull Genre value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setAndNotify(value, this.genre, arg_0 -> MutableAudioItem._set_genre_$lambda$0(this, arg_0));
    }

    @Serializable
    public static /* synthetic */ void getGenre$annotations() {
    }

    @Nullable
    public String getComments() {
        return this.comments;
    }

    public void setComments(@Nullable String value) {
        this.setAndNotify(value, this.comments, arg_0 -> MutableAudioItem._set_comments_$lambda$0(this, arg_0));
    }

    @Serializable
    public static /* synthetic */ void getComments$annotations() {
    }

    @Nullable
    public Short getTrackNumber() {
        return this.trackNumber;
    }

    public void setTrackNumber(@Nullable Short value) {
        this.setAndNotify(value, this.trackNumber, arg_0 -> MutableAudioItem._set_trackNumber_$lambda$0(this, arg_0));
    }

    @Serializable
    public static /* synthetic */ void getTrackNumber$annotations() {
    }

    @Nullable
    public Short getDiscNumber() {
        return this.discNumber;
    }

    public void setDiscNumber(@Nullable Short value) {
        this.setAndNotify(value, this.discNumber, arg_0 -> MutableAudioItem._set_discNumber_$lambda$0(this, arg_0));
    }

    @Serializable
    public static /* synthetic */ void getDiscNumber$annotations() {
    }

    @Nullable
    public Float getBpm() {
        return this.bpm;
    }

    public void setBpm(@Nullable Float value) {
        this.setAndNotify(value, this.bpm, arg_0 -> MutableAudioItem._set_bpm_$lambda$0(this, arg_0));
    }

    @Serializable
    public static /* synthetic */ void getBpm$annotations() {
    }

    @NotNull
    public Album getAlbum() {
        return this.album;
    }

    public void setAlbum(@NotNull Album value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setAndNotify(value, this.album, arg_0 -> MutableAudioItem._set_album_$lambda$0(this, arg_0));
    }

    @Serializable
    public static /* synthetic */ void getAlbum$annotations() {
    }

    @Nullable
    public byte[] getCoverImageBytes() {
        byte[] byArray = this.coverImageBytes;
        if (this.coverImageBytes == null) {
            byArray = this.getCoverBytes();
        }
        return byArray;
    }

    public void setCoverImageBytes(@Nullable byte[] value) {
        this.setAndNotify(value, this.coverImageBytes, arg_0 -> MutableAudioItem._set_coverImageBytes_$lambda$0(this, arg_0));
    }

    @Transient
    public static /* synthetic */ void getCoverImageBytes$annotations() {
    }

    private final String getFieldIfExisting(Tag tag, FieldKey fieldKey) {
        Boolean bl = tag.hasField(fieldKey);
        boolean it = bl;
        boolean bl2 = false;
        Boolean $this$getFieldIfExisting_u24lambda_u241 = it ? bl : null;
        boolean bl3 = false;
        return tag.getFirst(fieldKey);
    }

    private final Artist readArtist(Tag tag) {
        String string;
        block9: {
            block6: {
                String string2;
                String artistName;
                block8: {
                    block7: {
                        string = this.getFieldIfExisting(tag, FieldKey.ARTIST);
                        if (string == null) break block6;
                        artistName = string;
                        boolean bl = false;
                        string2 = this.getFieldIfExisting(tag, FieldKey.COUNTRY);
                        if (string2 == null) break block7;
                        String _country = string2;
                        boolean bl2 = false;
                        CountryCode countryCode = ((CharSequence)_country).length() > 0 ? CountryCode.valueOf((String)_country) : CountryCode.UNDEFINED;
                        string2 = countryCode;
                        if (countryCode != null) break block8;
                    }
                    string2 = CountryCode.UNDEFINED;
                }
                String country = string2;
                Artist artist = ImmutableArtist.Companion.of(AudioUtils.INSTANCE.beautifyArtistName(artistName), (CountryCode)country);
                string = artist;
                if (artist != null) break block9;
            }
            string = ImmutableArtist.UNKNOWN;
        }
        return string;
    }

    private final ImmutableAlbum readAlbum(Tag tag, String extension) {
        ImmutableAlbum immutableAlbum;
        String albumName = this.getFieldIfExisting(tag, FieldKey.ALBUM);
        boolean bl = false;
        if (albumName == null) {
            immutableAlbum = ImmutableAlbum.Companion.UNKNOWN();
        } else {
            Label label;
            Object object;
            Object object2;
            boolean isCompilation;
            String string = this.getFieldIfExisting(tag, FieldKey.ALBUM_ARTIST);
            if (string == null) {
                string = "";
            }
            String albumArtistName = string;
            String string2 = this.getFieldIfExisting(tag, FieldKey.IS_COMPILATION);
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                v3 = Intrinsics.areEqual((Object)"m4a", (Object)extension) ? Intrinsics.areEqual((Object)"1", (Object)tag.getFirst(FieldKey.IS_COMPILATION)) : Intrinsics.areEqual((Object)"true", (Object)tag.getFirst(FieldKey.IS_COMPILATION));
            } else {
                v3 = isCompilation = false;
            }
            if ((object2 = this.getFieldIfExisting(tag, FieldKey.YEAR)) != null && (object2 = StringsKt.toShortOrNull((String)object2)) != null) {
                Object object3 = object2;
                short it = ((Number)object3).shortValue();
                boolean bl3 = false;
                object = it > 0 ? object3 : null;
            } else {
                object = null;
            }
            Object year = object;
            String string3 = this.getFieldIfExisting(tag, FieldKey.GROUPING);
            if (string3 != null) {
                String it = string3;
                boolean bl4 = false;
                label = ImmutableLabel.Companion.of$default(ImmutableLabel.Companion, it, null, 2, null);
            } else {
                label = null;
            }
            Intrinsics.checkNotNull(label, (String)"null cannot be cast to non-null type net.transgressoft.commons.music.audio.Label");
            Label label2 = label;
            immutableAlbum = new ImmutableAlbum(albumName, ImmutableArtist.Companion.of$default(ImmutableArtist.Companion, AudioUtils.INSTANCE.beautifyArtistName(albumArtistName), null, 2, null), isCompilation, (Short)year, label2);
        }
        return immutableAlbum;
    }

    private final int getBitRate(AudioHeader audioHeader) {
        int n;
        String bitRate = audioHeader.getBitRate();
        Intrinsics.checkNotNull((Object)bitRate);
        String string = bitRate.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (Intrinsics.areEqual((Object)"~", (Object)string)) {
            String string2 = bitRate.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            n = Integer.parseInt(string2);
        } else {
            n = Integer.parseInt(bitRate);
        }
        return n;
    }

    private final byte[] getCoverBytes() {
        byte[] byArray;
        File it = this.getPath().toFile();
        boolean bl = false;
        if (it.exists() && it.canRead()) {
            Tag tag = AudioFileIO.read((File)it).getTag();
            Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"getTag(...)");
            byArray = this.getCoverBytes(tag);
        } else {
            byArray = null;
        }
        return byArray;
    }

    private final byte[] getCoverBytes(Tag tag) {
        byte[] byArray;
        List list = tag.getArtworkList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArtworkList(...)");
        Boolean bl = !((Collection)list).isEmpty();
        boolean it = bl;
        boolean bl2 = false;
        Boolean bl3 = it ? bl : null;
        if (bl3 != null) {
            it = bl3;
            boolean bl4 = false;
            byArray = tag.getFirstArtwork().getBinaryData();
        } else {
            byArray = null;
        }
        return byArray;
    }

    @NotNull
    public Job writeMetadata() {
        return BuildersKt.launch$default((CoroutineScope)this.ioScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MutableAudioItem this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        MutableAudioItem.access$getLogger$p(this.this$0).debug(() -> writeMetadata.1.invokeSuspend$lambda$0((CoroutineScope)$this$launch, this.this$0));
                        File audioFile = this.this$0.getPath().toFile();
                        AudioFile audio = AudioFileIO.read((File)audioFile);
                        String string = audio.getAudioHeader().getFormat();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormat(...)");
                        Tag it = MutableAudioItem.access$createTagTag(this.this$0, string);
                        boolean bl = false;
                        audio.setTag(it);
                        audio.commit();
                        MutableAudioItem.access$getLogger$p(this.this$0).debug(() -> writeMetadata.1.invokeSuspend$lambda$2((CoroutineScope)$this$launch));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Object invokeSuspend$lambda$0(CoroutineScope $$this$launch, MutableAudioItem this$0) {
                return "Writing metadata of " + $$this$launch + " to file '" + this$0.getPath().toAbsolutePath() + "'";
            }

            private static final Object invokeSuspend$lambda$2(CoroutineScope $$this$launch) {
                return "Metadata of " + $$this$launch + " successfully written to file";
            }
        }), (int)3, null);
    }

    private final Tag createTagTag(String format) {
        Tag tag;
        Tag tag2;
        if (StringsKt.startsWith((String)format, (String)AudioFileType.WAV.getExtension(), (boolean)true)) {
            WavTag wavTag = new WavTag(WavOptions.READ_ID3_ONLY);
            wavTag.setID3Tag((AbstractID3v2Tag)new ID3v24Tag());
            wavTag.setInfoTag(new WavInfoTag());
            tag2 = (Tag)wavTag;
        } else if (StringsKt.startsWith((String)format, (String)AudioFileType.MP3.getExtension(), (boolean)true)) {
            TagOptionSingleton.getInstance().setWriteMp3GenresAsText(true);
            tag = (Tag)new ID3v24Tag();
            tag.getArtworkList().clear();
            tag2 = tag;
        } else if (StringsKt.startsWith((String)format, (String)AudioFileType.FLAC.getExtension(), (boolean)true)) {
            tag = (Tag)new FlacTag();
            tag.getArtworkList().clear();
            tag2 = tag;
        } else if (StringsKt.startsWith((String)format, (String)"Aac", (boolean)true)) {
            TagOptionSingleton.getInstance().setWriteMp4GenresAsText(true);
            tag = (Tag)new Mp4Tag();
            tag.getArtworkList().clear();
            tag2 = tag;
        } else {
            tag2 = (Tag)new WavInfoTag();
        }
        Tag it = tag = tag2;
        boolean bl = false;
        this.setTrackFieldsToTag(it);
        return tag;
    }

    private final void setTrackFieldsToTag(Tag tag) {
        block7: {
            String[] stringArray;
            String[] stringArray2 = new String[]{this.getTitle()};
            tag.setField(FieldKey.TITLE, stringArray2);
            stringArray2 = new String[]{this.getAlbum().getName()};
            tag.setField(FieldKey.ALBUM, stringArray2);
            stringArray2 = new String[]{this.getAlbum().getAlbumArtist().getName()};
            tag.setField(FieldKey.ALBUM_ARTIST, stringArray2);
            stringArray2 = new String[]{this.getArtist().getName()};
            tag.setField(FieldKey.ARTIST, stringArray2);
            stringArray2 = new String[]{this.getGenre().capitalize()};
            tag.setField(FieldKey.GENRE, stringArray2);
            stringArray2 = new String[]{this.getArtist().getCountryCode().name()};
            tag.setField(FieldKey.COUNTRY, stringArray2);
            String string = this.getComments();
            if (string != null) {
                String it = string;
                boolean bl = false;
                stringArray = new String[]{it};
                tag.setField(FieldKey.COMMENT, stringArray);
            }
            Short s = this.getTrackNumber();
            if (s != null) {
                short it = ((Number)s).shortValue();
                boolean bl = false;
                stringArray = new String[]{String.valueOf(it)};
                tag.setField(FieldKey.TRACK, stringArray);
            }
            Short s2 = this.getAlbum().getYear();
            if (s2 != null) {
                short it = ((Number)s2).shortValue();
                boolean bl = false;
                stringArray = new String[]{String.valueOf(it)};
                tag.setField(FieldKey.YEAR, stringArray);
            }
            stringArray2 = new String[]{this.getEncoder()};
            tag.setField(FieldKey.ENCODER, stringArray2);
            stringArray2 = new String[]{this.getAlbum().getLabel().getName()};
            tag.setField(FieldKey.GROUPING, stringArray2);
            Short s3 = this.getDiscNumber();
            if (s3 != null) {
                short it = ((Number)s3).shortValue();
                boolean bl = false;
                stringArray = new String[]{String.valueOf(it)};
                tag.setField(FieldKey.DISC_NO, stringArray);
            }
            stringArray2 = new String[]{String.valueOf(this.getAlbum().isCompilation())};
            tag.setField(FieldKey.IS_COMPILATION, stringArray2);
            Float f = this.getBpm();
            if (f != null) {
                float it = ((Number)f).floatValue();
                boolean bl = false;
                if (tag instanceof Mp4Tag) {
                    stringArray = new String[]{String.valueOf((int)it)};
                    ((Mp4Tag)tag).setField(FieldKey.BPM, stringArray);
                } else {
                    stringArray = new String[]{String.valueOf(it)};
                    tag.setField(FieldKey.BPM, stringArray);
                }
            }
            byte[] byArray = this.getCoverImageBytes();
            if (byArray == null) break block7;
            byte[] it = byArray;
            boolean bl = false;
            tag.deleteArtworkField();
            tag.addField(this.createArtwork(it));
        }
    }

    private final Artwork createArtwork(byte[] coverBytes) {
        Path tempCover = null;
        try {
            Path path = Files.createTempFile("tempCover_" + this.getFileName(), ".tmp", new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
            tempCover = path;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
            Files.write(tempCover, coverBytes, openOptionArray);
            tempCover.toFile().deleteOnExit();
            Artwork artwork = ArtworkFactory.createArtworkFromFile((File)tempCover.toFile());
            Intrinsics.checkNotNullExpressionValue((Object)artwork, (String)"createArtworkFromFile(...)");
            return artwork;
        }
        catch (IOException exception) {
            String errorText = "Error creating artwork of " + this;
            this.logger.error(errorText, (Throwable)exception);
            throw new AudioItemManipulationException(errorText, (Throwable)exception);
        }
    }

    public final short incrementPlayCount$music_commons_core() {
        short s = this._playCount;
        this.set_playCount((short)(s + 1));
        return s;
    }

    @Override
    public int compareTo(@NotNull AudioItem other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return AudioUtils.INSTANCE.audioItemTrackDiscNumberComparator().compare(this, other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) return false;
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        MutableAudioItem that = (MutableAudioItem)other;
        Short s = this.getTrackNumber();
        Short s2 = that.getTrackNumber();
        if (!Intrinsics.areEqual((Object)(s != null ? Integer.valueOf(s.shortValue()) : null), (Object)(s2 != null ? Integer.valueOf(s2.shortValue()) : null))) return false;
        Short s3 = this.getDiscNumber();
        Short s4 = that.getDiscNumber();
        if (!Intrinsics.areEqual((Object)(s3 != null ? Integer.valueOf(s3.shortValue()) : null), (Object)(s4 != null ? Integer.valueOf(s4.shortValue()) : null))) return false;
        if (!Intrinsics.areEqual((Float)this.getBpm(), (Float)that.getBpm())) return false;
        if (!Intrinsics.areEqual((Object)this.getPath(), (Object)that.getPath())) return false;
        if (!Intrinsics.areEqual((Object)this.getTitle(), (Object)that.getTitle())) return false;
        if (!Intrinsics.areEqual((Object)this.getArtist(), (Object)that.getArtist())) return false;
        if (!Intrinsics.areEqual((Object)this.getAlbum(), (Object)that.getAlbum())) return false;
        if (this.getGenre() != that.getGenre()) return false;
        if (!Intrinsics.areEqual((Object)this.getComments(), (Object)that.getComments())) return false;
        if (!Intrinsics.areEqual((Object)this.getDuration(), (Object)that.getDuration())) return false;
        return true;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getPath(), this.getTitle(), this.getArtist(), this.getAlbum(), this.getGenre(), this.getComments(), this.getTrackNumber(), this.getDiscNumber(), this.getBpm(), this.getDuration()};
        return Objects.hashCode((Object[])objectArray);
    }

    @Override
    @NotNull
    public MutableAudioItem clone() {
        return new MutableAudioItem(this.getPath(), this.getId(), this.getTitle(), this.getDuration(), this.getBitRate(), this.getArtist(), this.getAlbum(), this.getGenre(), this.getComments(), this.getTrackNumber(), this.getDiscNumber(), this.getBpm(), this.getEncoder(), this.getEncoding(), this.getDateOfCreation(), this.getLastDateModified(), this.getPlayCount());
    }

    @NotNull
    public String toString() {
        return "AudioItem(id=" + this.getId() + ", path=" + this.getPath() + ", title=" + this.getTitle() + ", artist=" + this.getArtist().getName() + ")";
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void _set__playCount_$lambda$0(MutableAudioItem this$0, Short it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0._playCount = it;
    }

    private static final String fileName_delegate$lambda$0(MutableAudioItem this$0) {
        return ((Object)this$0.getPath().getFileName()).toString();
    }

    private static final String extension_delegate$lambda$0(MutableAudioItem this$0) {
        return PathsKt.getExtension((Path)this$0.getPath());
    }

    private static final long length_delegate$lambda$0(MutableAudioItem this$0) {
        return this$0.getPath().toFile().length();
    }

    private static final void _set_title_$lambda$0(MutableAudioItem this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.title = it;
    }

    private static final void _set_artist_$lambda$0(MutableAudioItem this$0, Artist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.artist = it;
    }

    private static final void _set_genre_$lambda$0(MutableAudioItem this$0, Genre it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.genre = it;
    }

    private static final void _set_comments_$lambda$0(MutableAudioItem this$0, String it) {
        this$0.comments = it;
    }

    private static final void _set_trackNumber_$lambda$0(MutableAudioItem this$0, Short it) {
        this$0.trackNumber = it;
    }

    private static final void _set_discNumber_$lambda$0(MutableAudioItem this$0, Short it) {
        this$0.discNumber = it;
    }

    private static final void _set_bpm_$lambda$0(MutableAudioItem this$0, Float it) {
        this$0.bpm = it;
    }

    private static final void _set_album_$lambda$0(MutableAudioItem this$0, Album it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.album = it;
    }

    private static final void _set_coverImageBytes_$lambda$0(MutableAudioItem this$0, byte[] it) {
        this$0.coverImageBytes = it;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(MutableAudioItem $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Tag access$createTagTag(MutableAudioItem $this, String format) {
        return $this.createTagTag(format);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/transgressoft/commons/music/audio/MutableAudioItem$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/transgressoft/commons/music/audio/MutableAudioItem;", "music-commons-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<MutableAudioItem> serializer() {
            return (KSerializer)AudioItemSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

