/*
 * Decompiled with CFR 0.152.
 */
package net.transgressoft.commons.music.playlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import net.transgressoft.commons.entity.IdentifiableEntityKt;
import net.transgressoft.commons.event.CrudEvent;
import net.transgressoft.commons.music.audio.AudioItem;
import net.transgressoft.commons.music.audio.AudioItemManipulationException;
import net.transgressoft.commons.music.audio.AudioLibrary;
import net.transgressoft.commons.music.playlist.MutableAudioPlaylist;
import net.transgressoft.commons.music.playlist.PlaylistHierarchyBase;
import net.transgressoft.commons.music.playlist.ReactiveAudioPlaylist;
import net.transgressoft.commons.persistence.Repository;
import net.transgressoft.commons.persistence.VolatileRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001aB/\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ2\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00020\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0002J0\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/transgressoft/commons/music/playlist/DefaultPlaylistHierarchy;", "Lnet/transgressoft/commons/music/playlist/PlaylistHierarchyBase;", "Lnet/transgressoft/commons/music/audio/AudioItem;", "Lnet/transgressoft/commons/music/playlist/MutableAudioPlaylist;", "repository", "Lnet/transgressoft/commons/persistence/Repository;", "", "audioLibrary", "Lnet/transgressoft/commons/music/audio/AudioLibrary;", "<init>", "(Lnet/transgressoft/commons/persistence/Repository;Lnet/transgressoft/commons/music/audio/AudioLibrary;)V", "logger", "Lmu/KLogger;", "mapAudioItemsFromIds", "", "kotlin.jvm.PlatformType", "audioItemIds", "findDeserializedPlaylistsFromIds", "playlists", "", "createPlaylist", "name", "", "audioItems", "createPlaylistDirectory", "toString", "MutablePlaylist", "music-commons-core"})
@SourceDebugExtension(value={"SMAP\nDefaultPlaylistHierarchy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultPlaylistHierarchy.kt\nnet/transgressoft/commons/music/playlist/DefaultPlaylistHierarchy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1563#2:143\n1634#2,3:144\n1#3:147\n*S KotlinDebug\n*F\n+ 1 DefaultPlaylistHierarchy.kt\nnet/transgressoft/commons/music/playlist/DefaultPlaylistHierarchy\n*L\n75#1:143\n75#1:144,3\n*E\n"})
public final class DefaultPlaylistHierarchy
extends PlaylistHierarchyBase<AudioItem, MutableAudioPlaylist> {
    @NotNull
    private final KLogger logger;

    public DefaultPlaylistHierarchy(@NotNull Repository<Integer, ? super MutableAudioPlaylist> repository, @Nullable AudioLibrary<AudioItem> audioLibrary) {
        Intrinsics.checkNotNullParameter(repository, (String)"repository");
        super(repository);
        this.logger = KotlinLogging.INSTANCE.logger(DefaultPlaylistHierarchy::logger$lambda$0);
        if (!(repository.isEmpty() || !repository.isEmpty() && audioLibrary != null)) {
            boolean bl = false;
            String string = "AudioLibrary is required when loading a non empty playlistHierarchy";
            throw new IllegalArgumentException(string.toString());
        }
        CrudEvent.Type[] typeArray = new CrudEvent.Type[]{CrudEvent.Type.CREATE, CrudEvent.Type.UPDATE, CrudEvent.Type.DELETE};
        this.disableEvents(typeArray);
        this.runForAll(arg_0 -> DefaultPlaylistHierarchy._init_$lambda$1(this, audioLibrary, arg_0));
        this.runForAll(arg_0 -> DefaultPlaylistHierarchy._init_$lambda$2(repository, this, arg_0));
        typeArray = new CrudEvent.Type[]{CrudEvent.Type.CREATE, CrudEvent.Type.UPDATE, CrudEvent.Type.DELETE};
        this.activateEvents(typeArray);
    }

    public /* synthetic */ DefaultPlaylistHierarchy(Repository repository, AudioLibrary audioLibrary, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            repository = (Repository)new VolatileRepository(null, null, 3, null);
        }
        if ((n & 2) != 0) {
            audioLibrary = null;
        }
        this((Repository<Integer, ? super MutableAudioPlaylist>)repository, (AudioLibrary<AudioItem>)audioLibrary);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AudioItem> mapAudioItemsFromIds(List<Integer> audioItemIds, AudioLibrary<AudioItem> audioLibrary) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = audioItemIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((AudioItem)audioLibrary.findById((Comparable)Integer.valueOf((int)it)).orElseThrow(() -> DefaultPlaylistHierarchy.mapAudioItemsFromIds$lambda$0$0((int)it)));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final List<MutableAudioPlaylist> findDeserializedPlaylistsFromIds(Set<Integer> playlists, Repository<Integer, ? super MutableAudioPlaylist> repository) {
        List<MutableAudioPlaylist> list = playlists.stream().map(arg_0 -> DefaultPlaylistHierarchy.findDeserializedPlaylistsFromIds$lambda$1(arg_0 -> DefaultPlaylistHierarchy.findDeserializedPlaylistsFromIds$lambda$0(repository, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @NotNull
    public MutableAudioPlaylist createPlaylist(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.createPlaylist(name2, CollectionsKt.emptyList());
    }

    @NotNull
    public MutableAudioPlaylist createPlaylist(@NotNull String name2, @NotNull List<? extends AudioItem> audioItems) {
        MutablePlaylist mutablePlaylist;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(audioItems, (String)"audioItems");
        if (!this.findByName(name2).isEmpty()) {
            boolean $i$a$-require-DefaultPlaylistHierarchy$createPlaylist$22 = false;
            String $i$a$-require-DefaultPlaylistHierarchy$createPlaylist$22 = "Playlist with name '" + name2 + "' already exists";
            throw new IllegalArgumentException($i$a$-require-DefaultPlaylistHierarchy$createPlaylist$22.toString());
        }
        MutablePlaylist it = mutablePlaylist = new MutablePlaylist(this, this.newId(), false, name2, audioItems, null, 16, null);
        boolean bl = false;
        this.logger.debug(() -> DefaultPlaylistHierarchy.createPlaylist$lambda$1$0(it));
        this.add((ReactiveAudioPlaylist)it);
        return mutablePlaylist;
    }

    @NotNull
    public MutableAudioPlaylist createPlaylistDirectory(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.createPlaylistDirectory(name2, CollectionsKt.emptyList());
    }

    @NotNull
    public MutableAudioPlaylist createPlaylistDirectory(@NotNull String name2, @NotNull List<? extends AudioItem> audioItems) {
        MutablePlaylist mutablePlaylist;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(audioItems, (String)"audioItems");
        if (!this.findByName(name2).isEmpty()) {
            boolean $i$a$-require-DefaultPlaylistHierarchy$createPlaylistDirectory$22 = false;
            String $i$a$-require-DefaultPlaylistHierarchy$createPlaylistDirectory$22 = "Playlist with name '" + name2 + "' already exists";
            throw new IllegalArgumentException($i$a$-require-DefaultPlaylistHierarchy$createPlaylistDirectory$22.toString());
        }
        MutablePlaylist it = mutablePlaylist = new MutablePlaylist(this, this.newId(), true, name2, audioItems, null, 16, null);
        boolean bl = false;
        this.logger.debug(() -> DefaultPlaylistHierarchy.createPlaylistDirectory$lambda$1$0(it));
        this.add((ReactiveAudioPlaylist)it);
        return mutablePlaylist;
    }

    @NotNull
    public String toString() {
        return "PlaylistRepository(playlistsCount=" + this.size() + ")";
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(DefaultPlaylistHierarchy this$0, AudioLibrary $audioLibrary, MutableAudioPlaylist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int n = ((Number)((Object)it.getId())).intValue();
        boolean bl = it.isDirectory();
        String string = it.getName();
        List list = IdentifiableEntityKt.toIds((List)it.getAudioItems());
        AudioLibrary audioLibrary = $audioLibrary;
        Intrinsics.checkNotNull((Object)audioLibrary);
        MutablePlaylist playlistWithAudioItems = new MutablePlaylist(this$0, n, bl, string, this$0.mapAudioItemsFromIds(list, (AudioLibrary<AudioItem>)audioLibrary), null, 16, null);
        this$0.remove((ReactiveAudioPlaylist)it);
        this$0.add((ReactiveAudioPlaylist)playlistWithAudioItems);
    }

    private static final void _init_$lambda$2(Repository $repository, DefaultPlaylistHierarchy this$0, MutableAudioPlaylist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MutableAudioPlaylist playlistMissingPlaylists = (MutableAudioPlaylist)$repository.findById(it.getId()).orElseThrow(() -> DefaultPlaylistHierarchy.lambda$2$0(it));
        List<MutableAudioPlaylist> foundPlaylists = this$0.findDeserializedPlaylistsFromIds(IdentifiableEntityKt.toIds((Set)it.getPlaylists()), (Repository<Integer, ? super MutableAudioPlaylist>)$repository);
        playlistMissingPlaylists.addPlaylists(foundPlaylists);
    }

    private static final IllegalStateException lambda$2$0(MutableAudioPlaylist $it) {
        return new IllegalStateException("Playlist ID " + $it.getId() + " not found after initial processing");
    }

    private static final AudioItemManipulationException mapAudioItemsFromIds$lambda$0$0(int $it) {
        return new AudioItemManipulationException("AudioItem with id " + $it + " not found during deserialization");
    }

    private static final MutableAudioPlaylist findDeserializedPlaylistsFromIds$lambda$0(Repository $repository, Integer it) {
        Intrinsics.checkNotNull((Object)it);
        return (MutableAudioPlaylist)$repository.findById((Comparable)it).orElseThrow(() -> DefaultPlaylistHierarchy.findDeserializedPlaylistsFromIds$lambda$0$0(it));
    }

    private static final AudioItemManipulationException findDeserializedPlaylistsFromIds$lambda$0$0(Integer $it) {
        return new AudioItemManipulationException("AudioPlaylist with id " + $it + " not found during deserialization");
    }

    private static final MutableAudioPlaylist findDeserializedPlaylistsFromIds$lambda$1(Function1 $tmp0, Object p0) {
        return (MutableAudioPlaylist)$tmp0.invoke(p0);
    }

    private static final Object createPlaylist$lambda$1$0(MutablePlaylist $it) {
        return "Created playlist " + $it;
    }

    private static final Object createPlaylistDirectory$lambda$1$0(MutablePlaylist $it) {
        return "Created playlist directory " + $it;
    }

    public DefaultPlaylistHierarchy() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00120\u0001R\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u00020\u0004B?\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\f\u0010\u0011\u001a\u00060\u0000R\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lnet/transgressoft/commons/music/playlist/DefaultPlaylistHierarchy$MutablePlaylist;", "Lnet/transgressoft/commons/music/playlist/PlaylistHierarchyBase$MutablePlaylistBase;", "Lnet/transgressoft/commons/music/playlist/PlaylistHierarchyBase;", "Lnet/transgressoft/commons/music/audio/AudioItem;", "Lnet/transgressoft/commons/music/playlist/MutableAudioPlaylist;", "id", "", "isDirectory", "", "name", "", "audioItems", "", "playlists", "", "<init>", "(Lnet/transgressoft/commons/music/playlist/DefaultPlaylistHierarchy;IZLjava/lang/String;Ljava/util/List;Ljava/util/Set;)V", "clone", "Lnet/transgressoft/commons/music/playlist/DefaultPlaylistHierarchy;", "music-commons-core"})
    private final class MutablePlaylist
    extends PlaylistHierarchyBase.MutablePlaylistBase
    implements MutableAudioPlaylist {
        final /* synthetic */ DefaultPlaylistHierarchy this$0;

        public MutablePlaylist(DefaultPlaylistHierarchy this$0, int id, @NotNull boolean isDirectory2, @NotNull String name2, @NotNull List<? extends AudioItem> audioItems, Set<? extends MutableAudioPlaylist> playlists) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(audioItems, (String)"audioItems");
            Intrinsics.checkNotNullParameter(playlists, (String)"playlists");
            this.this$0 = this$0;
            super(this$0, id, isDirectory2, name2, audioItems, playlists);
        }

        public /* synthetic */ MutablePlaylist(DefaultPlaylistHierarchy defaultPlaylistHierarchy, int n, boolean bl, String string, List list, Set set, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n2 & 0x10) != 0) {
                set = SetsKt.emptySet();
            }
            this(defaultPlaylistHierarchy, n, bl, string, list, set);
        }

        @NotNull
        public MutablePlaylist clone() {
            return new MutablePlaylist(this.this$0, (int)this.getId(), this.isDirectory(), this.getName(), CollectionsKt.toList((Iterable)this.getAudioItems()), CollectionsKt.toSet((Iterable)this.getPlaylists()));
        }
    }
}

